package com.ejianc.business.rmat.api;

import com.ejianc.business.rmat.hystrix.ArchivesHystrix;
import com.ejianc.business.rmat.vo.ArchivesVO;
import com.ejianc.business.rmat.vo.ArchivesVOS;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name= "cscec5b-rmat-web", url="${common.env.feign-client-url}", path="cscec5b-rmat-web", fallback = ArchivesHystrix.class)
public interface IArchivesApi {
    /**
     * 根据物料ids/分类ids、组织主键查询周转材档案
     * @param vos
     * @return
     */
    @PostMapping("/api/archives/queryIds")
    CommonResponse<List<ArchivesVO>> queryIds(@RequestBody ArchivesVOS vos);


}
