package com.ejianc.business.rmat.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 退场单
 * 
 * @author generator
 * 
 */
public class ExitVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectSourceId; // 项目来源ID
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgSourceId; // 组织来源ID
    private String orgName; // 组织名称
    private Long parentOrgId; // 上级组织
    private String parentOrgSourceId; // 上级组织来源ID
    private String contractId; // 合同主键
    private String contractName; // 合同名称
    private String contractCode; // 合同编号
    private Long supplierId; // 设备供应商
    private String supplierName; // 供应商名称
    private String supplierSourceId; // 供应商来源ID
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date exitDate; // 止租日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date confirmDate; // 确认日期
    private String materialName; // 物资名称
    private Integer confirmFlag; // 确认状态0-未确认1-已确认2-已拒绝
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long confirmerId; // 确认人
    private String confirmerName; // 确认人名称
    private String exitNote; // 退场说明
    private String confirmNote; // 确认说明
    private Integer billState; // 单据状态（审批必须字段）
    private String def1; // 
    private String def2; // 
    private String def3; // 
    private String def4; // 
    private String def5; // 
    private Long applyId; // 申请单ID
    private Integer saveState; // 保存状态（0-暂存态，1-保存态）
    private Integer useState; // 推送NC状态，0-未推送，1-已推送
    private Long pushUserId; // 推送人主键
    private String pushUserSourceId; // 推送人来源ID
    private String pushUserName; // 推送人名称
    private String isaddrecord; // 是否补录，0-否，1-是
    private String addrcdreson; // 补录原因
    private Long commitId; // 提交人
    private Long linkId; // 联系人
    private String linkName; // 联系人名称
    private String linkTelephone; // 联系人电话
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyDate; // 申请日期
    private Integer applyState; // 关闭状态(1已关闭/0未关闭)
    private String billStateName;
    private String confirmFlagName;
    private Long projectDepartmentId; // 项目部id

    private List<ExitDetailVO> exitDetail = new ArrayList<>(); // 退场单明细

    private List<ExitSupplierVO> exitSupplierList = new ArrayList<>(); // 退场单劳务队明细


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgSourceId() {
        return orgSourceId;
    }

    public void setOrgSourceId(String orgSourceId) {
        this.orgSourceId = orgSourceId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgSourceId() {
        return parentOrgSourceId;
    }

    public void setParentOrgSourceId(String parentOrgSourceId) {
        this.parentOrgSourceId = parentOrgSourceId;
    }
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }
    public Date getExitDate() {
        return exitDate;
    }

    public void setExitDate(Date exitDate) {
        this.exitDate = exitDate;
    }
    public Date getConfirmDate() {
        return confirmDate;
    }

    public void setConfirmDate(Date confirmDate) {
        this.confirmDate = confirmDate;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Integer getConfirmFlag() {
        return confirmFlag;
    }

    public void setConfirmFlag(Integer confirmFlag) {
        this.confirmFlag = confirmFlag;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getConfirmerId() {
        return confirmerId;
    }

    public void setConfirmerId(Long confirmerId) {
        this.confirmerId = confirmerId;
    }
    public String getConfirmerName() {
        return confirmerName;
    }

    public void setConfirmerName(String confirmerName) {
        this.confirmerName = confirmerName;
    }
    public String getExitNote() {
        return exitNote;
    }

    public void setExitNote(String exitNote) {
        this.exitNote = exitNote;
    }
    public String getConfirmNote() {
        return confirmNote;
    }

    public void setConfirmNote(String confirmNote) {
        this.confirmNote = confirmNote;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getDef1() {
        return def1;
    }

    public void setDef1(String def1) {
        this.def1 = def1;
    }
    public String getDef2() {
        return def2;
    }

    public void setDef2(String def2) {
        this.def2 = def2;
    }
    public String getDef3() {
        return def3;
    }

    public void setDef3(String def3) {
        this.def3 = def3;
    }
    public String getDef4() {
        return def4;
    }

    public void setDef4(String def4) {
        this.def4 = def4;
    }
    public String getDef5() {
        return def5;
    }

    public void setDef5(String def5) {
        this.def5 = def5;
    }
    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }
    public Integer getSaveState() {
        return saveState;
    }

    public void setSaveState(Integer saveState) {
        this.saveState = saveState;
    }
    public Integer getUseState() {
        return useState;
    }

    public void setUseState(Integer useState) {
        this.useState = useState;
    }
    public Long getPushUserId() {
        return pushUserId;
    }

    public void setPushUserId(Long pushUserId) {
        this.pushUserId = pushUserId;
    }
    public String getPushUserSourceId() {
        return pushUserSourceId;
    }

    public void setPushUserSourceId(String pushUserSourceId) {
        this.pushUserSourceId = pushUserSourceId;
    }
    public String getPushUserName() {
        return pushUserName;
    }

    public void setPushUserName(String pushUserName) {
        this.pushUserName = pushUserName;
    }
    public String getIsaddrecord() {
        return isaddrecord;
    }

    public void setIsaddrecord(String isaddrecord) {
        this.isaddrecord = isaddrecord;
    }
    public String getAddrcdreson() {
        return addrcdreson;
    }

    public void setAddrcdreson(String addrcdreson) {
        this.addrcdreson = addrcdreson;
    }
    public Long getCommitId() {
        return commitId;
    }

    public void setCommitId(Long commitId) {
        this.commitId = commitId;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getLinkId() {
        return linkId;
    }

    @ReferDeserialTransfer
    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }
    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }
    public String getLinkTelephone() {
        return linkTelephone;
    }

    public void setLinkTelephone(String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public List<ExitDetailVO> getExitDetail() {
        return exitDetail;
    }

    public void setExitDetail(List<ExitDetailVO> exitDetail) {
        this.exitDetail = exitDetail;
    }

    public Integer getApplyState() {
        return applyState;
    }

    public void setApplyState(Integer applyState) {
        this.applyState = applyState;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getConfirmFlagName() {
        return confirmFlagName;
    }

    public void setConfirmFlagName(String confirmFlagName) {
        this.confirmFlagName = confirmFlagName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public List<ExitSupplierVO> getExitSupplierList() {
        return exitSupplierList;
    }

    public void setExitSupplierList(List<ExitSupplierVO> exitSupplierList) {
        this.exitSupplierList = exitSupplierList;
    }
}
