package com.ejianc.business.rmat.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 内部调拨单
 * 
 * @author generator
 * 
 */
public class TransferVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectCode; // 项目code
    private String projectName; // 项目名称
    private Long parentOrgId; // 上级组织
    private String parentOrgCode; // 上级组织code
    private String parentOrgName; // 上级组织名称
    private Long orgId; // 组织
    private String orgCode; // 组织code
    private String orgName; // 组织名称
    private Long allotInId; // 调入单位id
    private String allotInName; // 调入单位名称
    private Long allotOutId; // 调出单位id
    private String allotOutName; // 调出单位名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date transferDate; // 调拨日期
    private Integer billState; // 单据状态（审批必须字段）
    
    private List<TransferDetailVO> detailList = new ArrayList<>(); // 内部调拨单明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getAllotInId() {
        return allotInId;
    }
    @ReferDeserialTransfer
    public void setAllotInId(Long allotInId) {
        this.allotInId = allotInId;
    }
    public String getAllotInName() {
        return allotInName;
    }

    public void setAllotInName(String allotInName) {
        this.allotInName = allotInName;
    }
    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getAllotOutId() {
        return allotOutId;
    }
    @ReferDeserialTransfer
    public void setAllotOutId(Long allotOutId) {
        this.allotOutId = allotOutId;
    }
    public String getAllotOutName() {
        return allotOutName;
    }

    public void setAllotOutName(String allotOutName) {
        this.allotOutName = allotOutName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getTransferDate() {
        return transferDate;
    }

    public void setTransferDate(Date transferDate) {
        this.transferDate = transferDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<TransferDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<TransferDetailVO> detailList) {
        this.detailList = detailList;
    }
}
