package com.ejianc.business.rmat.consts;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 流水类型
 */
public enum TransFlowTypeEnum {

    //验收单
    验收(1, "验收", "check","BT210816000000002"),
    //退场单
    退场(2, "退场", "exit","EJCBT202210000013"),
    //内部调入单
    调入(3, "调入", "allotIn","EJCBT202210000007"),
    //内部调出单
    调出(4, "调出", "allotOut","EJCBT202210000007");


    /**
     * 流水类型编码,参照枚举对象
     */
    private Integer flowType;

    /**
     * 流水类型名称,参照枚举对象
     */
    private String flowTypeName;

    /**
     * 流水类型标识
     */
    private String flowFlag;

    /**
     * 单据类型编号
     */
    private String billTypeCode;

    private static Map<Integer, TransFlowTypeEnum> enumMap = new HashMap();
    private static Map<String, TransFlowTypeEnum> enumMapByCode = new HashMap();

    static {
        enumMap = EnumSet.allOf(TransFlowTypeEnum.class).stream().collect(Collectors.toMap(TransFlowTypeEnum::getFlowType, Function.identity(), (k1, k2) -> k2));
        enumMapByCode = EnumSet.allOf(TransFlowTypeEnum.class).stream().collect(Collectors.toMap(TransFlowTypeEnum::getBillTypeCode, Function.identity(), (k1, k2) -> k2));
    }

    /**
     * 根据入库类型编码,获取枚举对象
     */
    public static TransFlowTypeEnum getEnumByInOutType(Integer flowType) {
        return enumMap.get(flowType);
    }
    public static TransFlowTypeEnum getEnumByCode(String billTypeCode) {
        return enumMapByCode.get(billTypeCode);
    }

    TransFlowTypeEnum(Integer flowType, String flowTypeName, String flowFlag,String billTypeCode) {
        this.flowType = flowType;
        this.flowTypeName = flowTypeName;
        this.flowFlag = flowFlag;
        this.billTypeCode = billTypeCode;
    }

    public Integer getFlowType() {
        return flowType;
    }

    public void setFlowType(Integer flowType) {
        this.flowType = flowType;
    }

    public String getFlowTypeName() {
        return flowTypeName;
    }

    public void setFlowTypeName(String flowTypeName) {
        this.flowTypeName = flowTypeName;
    }

    public String getFlowFlag() {
        return flowFlag;
    }

    public void setFlowFlag(String flowFlag) {
        this.flowFlag = flowFlag;
    }

    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }
}
