package com.ejianc.business.rmat.api;

import com.ejianc.business.rmat.hystrix.RmatFlowHystrix;
import com.ejianc.business.rmat.vo.RmatFlowApiVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Date;
import java.util.Map;

@FeignClient(name= "cscec5b-rmat-web", url="${common.env.feign-client-url}", path="cscec5b-rmat-web", fallback = RmatFlowHystrix.class)
public interface IRmatFlowApi {
    /**
     * 插入流水
     * @param vo
     * @return
     */
    @PostMapping("/api/rmatFlow/insertFlow")
    CommonResponse<Boolean> insertFlow(@RequestBody RmatFlowApiVO vo);

    /**
     * 删除流水
     * @param vo
     * @return
     */
    @PostMapping("/api/rmatFlow/delFlow")
    CommonResponse<Boolean> delFlow(@RequestBody RmatFlowApiVO vo);

    /**
     *  校验同一个合同只能存在一个自由态或审批中的单据（验收单、启用单、停用单、退赔单、遗失单、租金计算单）
     * @param contractId    合同主键
     * @param billType  待校验单据类型
     * @param billId    待校验单据主键
     * @return
     */
    @GetMapping(value = "/api/rmatFlow/validateContract")
    CommonResponse<String> validateContract(@RequestParam("contractId") String contractId,
               @RequestParam(value = "billType", required = false) String billType,
               @RequestParam(value = "billId", required = false) Long billId);

    /**
     * @Description getLastDate 获取最大单据日期
     * @param params contractId，billType，billId
     */
    @GetMapping(value = "/api/rmatFlow/getLastDate")
    public CommonResponse<Date> getLastDate(@RequestParam(required = false) Map<String, Object> params);
}
