package com.ejianc.business.rmat.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.rmat.vo.CalculateDailyVO;
import com.ejianc.business.rmat.vo.CalculateScrapVO;
import com.ejianc.business.rmat.vo.CalculateOtherVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 租金计算单
 * 
 * @author generator
 * 
 */
public class CalculateVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; //
    private String projectSourceId; // 项目来源ID
    private Long orgId; // 项目组织id
    private String orgCode; // 项目组织编码
    private String orgName; // 
    private Long parentOrgId; // 父级组织id
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 
    private String contractId; // 合同id
    private String contractCode; // 合同编号
    private String contractName; // 
    private Long supplierId; // 供应商
    private String supplierName; //
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rentDate; // 租金计算日期
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private BigDecimal rentTaxMny; // 本次租赁金额
    private BigDecimal rentMny; // 本次租赁金额(无税)
    private BigDecimal rentTax; // 本次租赁税额
    private String memo; // 备注
    private String calculateType; // 租金计算类型（0：手动计算，1：自动计算）
    private BigDecimal scrapTaxMny; // 本次退赔金额
    private BigDecimal scrapMny; // 本次退赔金额(无税)
    private BigDecimal scrapTax; // 本次退赔税额
    private BigDecimal otherTaxMny; // 本次其他费用金额
    private BigDecimal otherMny; // 本次其他费用金额(无税)
    private BigDecimal otherTax; // 本次其他费用税额
    private BigDecimal dailyTaxMny; // 日租金额
    private BigDecimal dailyMny; // 日租金额(无税)
    private BigDecimal dailyTax; // 日租税额
    
    private List<CalculateDailyVO> dailyList = new ArrayList<>(); // 租金计算单-日租
    private List<CalculateScrapVO> scrapList = new ArrayList<>(); // 租金计算单-退赔
    private List<CalculateOtherVO> otherList = new ArrayList<>(); // 租金计算单-其他费用

    private String billStateName; // 单据状态名称

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getRentDate() {
        return rentDate;
    }

    public void setRentDate(Date rentDate) {
        this.rentDate = rentDate;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getRentTaxMny() {
        return rentTaxMny;
    }

    public void setRentTaxMny(BigDecimal rentTaxMny) {
        this.rentTaxMny = rentTaxMny;
    }
    public BigDecimal getRentMny() {
        return rentMny;
    }

    public void setRentMny(BigDecimal rentMny) {
        this.rentMny = rentMny;
    }
    public BigDecimal getRentTax() {
        return rentTax;
    }

    public void setRentTax(BigDecimal rentTax) {
        this.rentTax = rentTax;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getCalculateType() {
        return calculateType;
    }

    public void setCalculateType(String calculateType) {
        this.calculateType = calculateType;
    }
    public BigDecimal getScrapTaxMny() {
        return scrapTaxMny;
    }

    public void setScrapTaxMny(BigDecimal scrapTaxMny) {
        this.scrapTaxMny = scrapTaxMny;
    }
    public BigDecimal getScrapMny() {
        return scrapMny;
    }

    public void setScrapMny(BigDecimal scrapMny) {
        this.scrapMny = scrapMny;
    }
    public BigDecimal getScrapTax() {
        return scrapTax;
    }

    public void setScrapTax(BigDecimal scrapTax) {
        this.scrapTax = scrapTax;
    }
    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }
    public BigDecimal getDailyTaxMny() {
        return dailyTaxMny;
    }

    public void setDailyTaxMny(BigDecimal dailyTaxMny) {
        this.dailyTaxMny = dailyTaxMny;
    }
    public BigDecimal getDailyMny() {
        return dailyMny;
    }

    public void setDailyMny(BigDecimal dailyMny) {
        this.dailyMny = dailyMny;
    }
    public BigDecimal getDailyTax() {
        return dailyTax;
    }

    public void setDailyTax(BigDecimal dailyTax) {
        this.dailyTax = dailyTax;
    }

    public List<CalculateDailyVO> getDailyList() {
        return dailyList;
    }

    public void setDailyList(List<CalculateDailyVO> dailyList) {
        this.dailyList = dailyList;
    }

    public List<CalculateScrapVO> getScrapList() {
        return scrapList;
    }

    public void setScrapList(List<CalculateScrapVO> scrapList) {
        this.scrapList = scrapList;
    }

    public List<CalculateOtherVO> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<CalculateOtherVO> otherList) {
        this.otherList = otherList;
    }
}
