package com.ejianc.business.rmat.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 退赔单
 * 
 * @author generator
 * 
 */
public class RestituteVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码
    private Long projectId; // 项目id
    private String pkProject; // 项目来源id
    private String projectSourceId; // 项目来源id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private String contractId; // 合同ID
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long parentOrgId; // 父级组织
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Integer billState; // 单据状态（审批必须字段）
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private String pkSupplier;
    private Long supplierId; // 供应商主键
    private String supplierName; // 供应商名称
    private String memo; // 备注
    private Integer confirmFlag; // 供方确认状态(0-待确认,1-已确认,2-已拒绝）
    private Integer supplierSignStatus; // 签字状态(已签字-1,未签字-0)
    private String supOperatorName; // 供方经办人名称
    private Date supOperateTime; // 供方经办人签字时间
    private String supOperatorPhone; // 供方经办人手机号
    private String supOperatorUserCode; // 供方经办人账号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date restituteDate; // 退赔日期
    private BigDecimal totalMaintainTaxMny; // 本次维修金额汇总
    private BigDecimal totalMaintainMny; // 本次维修金额汇总(无税)
    private BigDecimal totalMaintainTax; // 维修税额汇总
    private BigDecimal totalScrapTaxMny; // 本次报废金额汇总
    private BigDecimal totalScrapMny; // 本次报废金额汇总(无税)
    private BigDecimal totalScrapTax; // 报废税额汇总
    private Integer pushFlag; // 推送标识：0未推送 1已推送
    private BigDecimal restituteSumMny; // 赔偿金额汇总无税
    private BigDecimal restituteSumTaxMny; // 赔偿金额汇总含税
    private Integer settleFlag; // 是否结算：0 未结算 1 已结算
    private String supplierSignStatusName;//签字状态
    private String billStateName;//单据状态
    private String materialTypeNames; // 材料分类
    private Long linkId; // 确认人
    private String linkName; // 确认人名
    private String confirmerName;//确认名称
    private Date confirmDate; // 确认日期
    private String commitId; // 终审人,推送供方
    private String confirmNote; // 供方确认说明
    private String sysmark;
    private String supplierSourceId; // 供应商来源ID
    private String confirmFlagName;//确认状态名称

    private List<RestituteMaintainVO> restituteMaintainList = new ArrayList<>(); // 退赔单维修清单明细
    private List<RestituteScrapVO> restituteDetailList = new ArrayList<>(); // 退赔单报废清单明细
    private List<RestituteOtherVO> otherList = new ArrayList<>(); // 退赔单其他费用明细

    public BigDecimal getRestituteSumTaxMny() {
        return restituteSumTaxMny;
    }

    public void setRestituteSumTaxMny(BigDecimal restituteSumTaxMny) {
        this.restituteSumTaxMny = restituteSumTaxMny;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public List<RestituteScrapVO> getRestituteDetailList() {
        return restituteDetailList;
    }

    public void setRestituteDetailList(List<RestituteScrapVO> restituteDetailList) {
        this.restituteDetailList = restituteDetailList;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getConfirmFlag() {
        return confirmFlag;
    }

    public void setConfirmFlag(Integer confirmFlag) {
        this.confirmFlag = confirmFlag;
    }

    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }
    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }
    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }
    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }
    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }
    public Date getRestituteDate() {
        return restituteDate;
    }

    public void setRestituteDate(Date restituteDate) {
        this.restituteDate = restituteDate;
    }
    public BigDecimal getTotalMaintainTaxMny() {
        return totalMaintainTaxMny;
    }

    public void setTotalMaintainTaxMny(BigDecimal totalMaintainTaxMny) {
        this.totalMaintainTaxMny = totalMaintainTaxMny;
    }
    public BigDecimal getTotalMaintainMny() {
        return totalMaintainMny;
    }

    public void setTotalMaintainMny(BigDecimal totalMaintainMny) {
        this.totalMaintainMny = totalMaintainMny;
    }
    public BigDecimal getTotalMaintainTax() {
        return totalMaintainTax;
    }

    public void setTotalMaintainTax(BigDecimal totalMaintainTax) {
        this.totalMaintainTax = totalMaintainTax;
    }
    public BigDecimal getTotalScrapTaxMny() {
        return totalScrapTaxMny;
    }

    public void setTotalScrapTaxMny(BigDecimal totalScrapTaxMny) {
        this.totalScrapTaxMny = totalScrapTaxMny;
    }
    public BigDecimal getTotalScrapMny() {
        return totalScrapMny;
    }

    public void setTotalScrapMny(BigDecimal totalScrapMny) {
        this.totalScrapMny = totalScrapMny;
    }
    public BigDecimal getTotalScrapTax() {
        return totalScrapTax;
    }

    public void setTotalScrapTax(BigDecimal totalScrapTax) {
        this.totalScrapTax = totalScrapTax;
    }
    public Integer getPushFlag() {
        return pushFlag;
    }

    public void setPushFlag(Integer pushFlag) {
        this.pushFlag = pushFlag;
    }
    public BigDecimal getRestituteSumMny() {
        return restituteSumMny;
    }

    public void setRestituteSumMny(BigDecimal restituteSumMny) {
        this.restituteSumMny = restituteSumMny;
    }

    public Integer getSettleFlag() {
        return settleFlag;
    }

    public void setSettleFlag(Integer settleFlag) {
        this.settleFlag = settleFlag;
    }

    public String getSupplierSignStatusName() {
        return supplierSignStatusName;
    }

    public void setSupplierSignStatusName(String supplierSignStatusName) {
        this.supplierSignStatusName = supplierSignStatusName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<RestituteMaintainVO> getRestituteMaintainList() {
        return restituteMaintainList;
    }

    public void setRestituteMaintainList(List<RestituteMaintainVO> restituteMaintainList) {
        this.restituteMaintainList = restituteMaintainList;
    }



    public List<RestituteOtherVO> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<RestituteOtherVO> otherList) {
        this.otherList = otherList;
    }

    public String getMaterialTypeNames() {
        return materialTypeNames;
    }

    public void setMaterialTypeNames(String materialTypeNames) {
        this.materialTypeNames = materialTypeNames;
    }

    public String getConfirmNote() {
        return confirmNote;
    }

    public void setConfirmNote(String confirmNote) {
        this.confirmNote = confirmNote;
    }

    public Long getLinkId() {
        return linkId;
    }

    public void setLinkId(Long linkId) {
        this.linkId = linkId;
    }

    public String getLinkName() {
        return linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public Date getConfirmDate() {
        return confirmDate;
    }

    public void setConfirmDate(Date confirmDate) {
        this.confirmDate = confirmDate;
    }

    public String getCommitId() {
        return commitId;
    }

    public void setCommitId(String commitId) {
        this.commitId = commitId;
    }

    public String getSysmark() {
        return sysmark;
    }

    public void setSysmark(String sysmark) {
        this.sysmark = sysmark;
    }

    public String getPkProject() {
        return pkProject;
    }

    public void setPkProject(String pkProject) {
        this.pkProject = pkProject;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    public String getPkSupplier() {
        return pkSupplier;
    }

    public void setPkSupplier(String pkSupplier) {
        this.pkSupplier = pkSupplier;
    }

    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }

    public String getConfirmerName() {
        return confirmerName;
    }

    public void setConfirmerName(String confirmerName) {
        this.confirmerName = confirmerName;
    }

    public String getConfirmFlagName() {
        return confirmFlagName;
    }

    public void setConfirmFlagName(String confirmFlagName) {
        this.confirmFlagName = confirmFlagName;
    }
}
