package com.ejianc.business.rmat.api;

import com.ejianc.business.rmat.hystrix.PriceFlowHystrix;
import com.ejianc.business.rmat.vo.PriceFlowApiVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name= "cscec5b-rmat-web", url="${common.env.feign-client-url}", path="cscec5b-rmat-web", fallback = PriceFlowHystrix.class)
public interface IPriceFlowApi {
    /**
     * 插入流水
     * @param vo
     * @return
     */
    @PostMapping("/api/priceFlow/insertFlow")
    CommonResponse<Boolean> insertFlow(@RequestBody PriceFlowApiVO vo);

    /**
     * 删除流水
     * @param vo
     * @return
     */
    @PostMapping("/api/priceFlow/delFlow")
    CommonResponse<Boolean> delFlow(@RequestBody PriceFlowApiVO vo);

}
