package com.ejianc.business.rmat.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import javax.validation.constraints.NotEmpty;

/**
 * 材料流水表
 *
 * @author generator
 *
 */
public class RmatFlowVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    @NotEmpty(message = "来源单据类型编码不能为空")
    private String billTypeCode; // 来源单据类型编码
    @NotEmpty(message = "来源单据id不能为空")
    private Long sourceId; // 来源单据id
    @NotEmpty(message = "来源单据明细id不能为空")
    private Long sourceDetailId; // 来源单据明细id
    @NotEmpty(message = "来源单据编码不能为空")
    private String billCode; // 来源单据编码
    private Long projectId; // 项目ID
    private String projectName; //
    private Long orgId; // 所属组织
    private String orgName; //
    @NotEmpty(message = "合同id不能为空")
    private String contractId; // 合同id
    private String contractCode; // 合同编号
    private String contractName; // 合同名称
    private Long supplierId; // 供应商id
    private String supplierName; // 供应商名称
    private Long employeeId; // 业务经办人ID
    private String employeeName; // 业务经办人名称
    @NotEmpty(message = "来源单据日期不能为空")
    private Date billDate; // 来源单据日期
    private Date billCreateTime; // 来源单据编制日期
    @NotEmpty(message = "来源单据明细日期不能为空")
    private Date detailDate; // 来源单据明细日期
    private String infoId; // 合同清单主键
    private Date effectiveDate; // 生效时间
    @NotEmpty(message = "生效状态不能为空")
    private Integer effectiveState; // 生效状态0自由1已生效
    @NotEmpty(message = "流水类型不能为空")
    private String flowType; // 流水类型: 1-验收，2-停用，3-启用，4-退赔，5-遗失
    @NotEmpty(message = "进退场属性不能为空")
    private Integer inOutFlag; // 进退场属性1进场2退场
    @NotEmpty(message = "使用状态不能为空")
    private String useStatus; // 使用状态：0-停用，1-启用
    private Long materialTypeId; // 物资分类id
    private String materialTypeName; // 物资分类名称
    @NotEmpty(message = "物资id不能为空")
    private Long materialId; // 物资id
    private String materialCode; // 物资编码
    private String materialName; // 物资名称
    @NotEmpty(message = "物资来源主键不能为空")
    private String materialSourceId; // 物资来源主键
    private String spec; // 规格型号
    private String unitId; // 档案单位id
    private String unitName; // 档案单位
    private BigDecimal num; // 数量
    private String realUnitId; // 实物单位id
    private String realUnitName; // 实物单位
    private BigDecimal realNum; // 实物数量
    private BigDecimal realTransScale; // 实物转换系数
    private String rentUnitId; // 计租单位id
    private String rentUnitName; // 计租单位
    private BigDecimal rentNum; // 计租数量
    private BigDecimal rentTransScale; // 计租转换系数
    private Integer signRowType; // 合同签订方式,1-分类，2-材料
    /** 在场信息 */
    private BigDecimal checkedNum; // 已进场数量
    private BigDecimal startedNum; // 在场已启用数量
    private BigDecimal stopedNum; // 在场已停用数量
    private BigDecimal restitutedNum; // 已退赔数量
    private BigDecimal losedNum; // 已遗失数量
    private BigDecimal tempRestNum; // 未生效退赔数量
    private BigDecimal tempLoseNum; // 未生效遗失数量
    private BigDecimal refNum; // 可参照数量
    private String memo; // 备注

    private Long realCorpId; // NC所属组织ID
    private String realNcCorp; // NC所属组织PK
    private String realCorpName; // NC所属组织名称

    public BigDecimal getCheckedNum() {
        return checkedNum;
    }

    public void setCheckedNum(BigDecimal checkedNum) {
        this.checkedNum = checkedNum;
    }

    public BigDecimal getStartedNum() {
        return startedNum;
    }

    public void setStartedNum(BigDecimal startedNum) {
        this.startedNum = startedNum;
    }

    public BigDecimal getStopedNum() {
        return stopedNum;
    }

    public void setStopedNum(BigDecimal stopedNum) {
        this.stopedNum = stopedNum;
    }

    public BigDecimal getRestitutedNum() {
        return restitutedNum;
    }

    public void setRestitutedNum(BigDecimal restitutedNum) {
        this.restitutedNum = restitutedNum;
    }

    public BigDecimal getLosedNum() {
        return losedNum;
    }

    public void setLosedNum(BigDecimal losedNum) {
        this.losedNum = losedNum;
    }

    public BigDecimal getTempRestNum() {
        return tempRestNum;
    }

    public void setTempRestNum(BigDecimal tempRestNum) {
        this.tempRestNum = tempRestNum;
    }

    public BigDecimal getTempLoseNum() {
        return tempLoseNum;
    }

    public void setTempLoseNum(BigDecimal tempLoseNum) {
        this.tempLoseNum = tempLoseNum;
    }

    public BigDecimal getRefNum() {
        return refNum;
    }

    public void setRefNum(BigDecimal refNum) {
        this.refNum = refNum;
    }

    public String getBillTypeCode() {
        return billTypeCode;
    }

    public void setBillTypeCode(String billTypeCode) {
        this.billTypeCode = billTypeCode;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public Long getSourceDetailId() {
        return sourceDetailId;
    }

    public void setSourceDetailId(Long sourceDetailId) {
        this.sourceDetailId = sourceDetailId;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public Date getBillCreateTime() {
        return billCreateTime;
    }

    public void setBillCreateTime(Date billCreateTime) {
        this.billCreateTime = billCreateTime;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Integer getEffectiveState() {
        return effectiveState;
    }

    public void setEffectiveState(Integer effectiveState) {
        this.effectiveState = effectiveState;
    }
    public String getFlowType() {
        return flowType;
    }

    public void setFlowType(String flowType) {
        this.flowType = flowType;
    }
    public Integer getInOutFlag() {
        return inOutFlag;
    }

    public void setInOutFlag(Integer inOutFlag) {
        this.inOutFlag = inOutFlag;
    }
    public String getUseStatus() {
        return useStatus;
    }

    public void setUseStatus(String useStatus) {
        this.useStatus = useStatus;
    }
    public Date getDetailDate() {
        return detailDate;
    }

    public void setDetailDate(Date detailDate) {
        this.detailDate = detailDate;
    }
    public String getInfoId() {
        return infoId;
    }

    public void setInfoId(String infoId) {
        this.infoId = infoId;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialSourceId() {
        return materialSourceId;
    }

    public void setMaterialSourceId(String materialSourceId) {
        this.materialSourceId = materialSourceId;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnitId() {
        return unitId;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }
    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }
    public BigDecimal getNum() {
        return num;
    }

    public void setNum(BigDecimal num) {
        this.num = num;
    }
    public String getRealUnitId() {
        return realUnitId;
    }

    public void setRealUnitId(String realUnitId) {
        this.realUnitId = realUnitId;
    }
    public String getRealUnitName() {
        return realUnitName;
    }

    public void setRealUnitName(String realUnitName) {
        this.realUnitName = realUnitName;
    }
    public BigDecimal getRealNum() {
        return realNum;
    }

    public void setRealNum(BigDecimal realNum) {
        this.realNum = realNum;
    }
    public BigDecimal getRealTransScale() {
        return realTransScale;
    }

    public void setRealTransScale(BigDecimal realTransScale) {
        this.realTransScale = realTransScale;
    }
    public String getRentUnitId() {
        return rentUnitId;
    }

    public void setRentUnitId(String rentUnitId) {
        this.rentUnitId = rentUnitId;
    }
    public String getRentUnitName() {
        return rentUnitName;
    }

    public void setRentUnitName(String rentUnitName) {
        this.rentUnitName = rentUnitName;
    }
    public BigDecimal getRentNum() {
        return rentNum;
    }

    public void setRentNum(BigDecimal rentNum) {
        this.rentNum = rentNum;
    }
    public BigDecimal getRentTransScale() {
        return rentTransScale;
    }

    public void setRentTransScale(BigDecimal rentTransScale) {
        this.rentTransScale = rentTransScale;
    }
    public Integer getSignRowType() {
        return signRowType;
    }

    public void setSignRowType(Integer signRowType) {
        this.signRowType = signRowType;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getRealCorpId() {
        return realCorpId;
    }

    public void setRealCorpId(Long realCorpId) {
        this.realCorpId = realCorpId;
    }

    public String getRealNcCorp() {
        return realNcCorp;
    }

    public void setRealNcCorp(String realNcCorp) {
        this.realNcCorp = realNcCorp;
    }

    public String getRealCorpName() {
        return realCorpName;
    }

    public void setRealCorpName(String realCorpName) {
        this.realCorpName = realCorpName;
    }
}
