package com.ejianc.business.rmat.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.rmat.bean.TransferFlowEntity;
import com.ejianc.business.rmat.service.ITransferFlowService;
import com.ejianc.business.rmat.vo.TransferFlowVO;

/**
 * 内部调拨流水表
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("transferFlow")
public class TransferFlowController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ITransferFlowService service;


    /**
     * @param vos 数据
     * @description: 插入流水
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @PostMapping(value="/insertFlow")
    public CommonResponse<Boolean> insertFlow(@RequestBody List<TransferFlowVO> vos) {
        Boolean flag = service.insertFlow(vos);
        if (Boolean.FALSE.equals(flag)) {
            return CommonResponse.error("插入流水数据失败！");
        }
        return CommonResponse.success("插入流水数据成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param queryId
     */
    @GetMapping(value = "/queryDetail")
    public CommonResponse<TransferFlowVO> queryDetail(@RequestParam String queryId) {
        List<TransferFlowEntity> list = service.list(new QueryWrapper<TransferFlowEntity>()
                .eq("query_id", queryId)
                .eq("effective_state",RmatCommonConsts.YES));
        //拼数据/基本信息
        TransferFlowVO vo = new TransferFlowVO();
        TransferFlowEntity entity = list.get(0);
        vo.setProjectId(entity.getProjectId());
        vo.setSupplierId(entity.getSupplierId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode()!=null ?entity.getProjectCode() : null);
        vo.setSupplierName(entity.getSupplierName());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgName(entity.getOrgName());
        vo.setOrgCode(entity.getOrgCode()!=null ? entity.getOrgCode() : null);
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode()!=null ? entity.getParentOrgCode() : null);
        vo.setParentOrgName(entity.getParentOrgName()!=null ? entity.getParentOrgName() : null);
        List<TransferFlowVO> details = vo.getDetailList();//在场材料明细
        //拼子表明细数据
        Map<Long,List<TransferFlowEntity>> flowMap = list.stream().collect(Collectors.groupingBy(TransferFlowEntity::getMaterialId));
        for (Map.Entry<Long, List<TransferFlowEntity>> entry : flowMap.entrySet()) {
            TransferFlowVO fvo = service.getFlowData(entry.getValue());
            details.add(fvo);
        }
        vo.setDetailList(details);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryRmatDetail 查询物资周转明细
     * @param materialId
     */
    @GetMapping(value = "/queryRmatDetail")
    public CommonResponse<List<TransferFlowVO>> queryRmatDetail(@RequestParam String queryId,@RequestParam Long materialId) {
        List<TransferFlowEntity> list = service.list(new QueryWrapper<TransferFlowEntity>()
                .eq("query_id", queryId)
                .eq("effective_state",RmatCommonConsts.YES).eq("material_id",materialId));
        return CommonResponse.success("查询详情数据成功！",BeanMapper.mapList(list,TransferFlowVO.class));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @PostMapping(value="/delete")
    public CommonResponse<String> delete(@RequestBody List<Long> sourceIds, @RequestParam Integer flowType) {
        return CommonResponse.success(service.delete(sourceIds, flowType));
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<TransferFlowVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //param.getParams().put("effectiveState", new Parameter(QueryParam.EQ, RmatCommonConsts.YES));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        if(!param.getParams().containsKey("orgId")) {// 非移动端默认项目，走PC端
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        IPage<TransferFlowEntity> page = service.queryPage(param,false);
        IPage<TransferFlowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<TransferFlowVO> flowVo = BeanMapper.mapList(page.getRecords(), TransferFlowVO.class);
  		pageData.setRecords(service.getListData(flowVo));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if(!param.getParams().containsKey("orgId")) {// 非移动端默认项目，走PC端
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        List<TransferFlowEntity> list = service.queryList(param);
        List<TransferFlowVO> flowVoS = service.getListData(BeanMapper.mapList(list,TransferFlowVO.class));
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", BeanMapper.mapList(flowVoS,TransferFlowEntity.class));
        ExcelExport.getInstance().export("TransferFlow-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param pageNumber
     * @Return void
     */
    @RequestMapping(value = "/refTransferFlowData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<TransferFlowVO>> refTransferFlowData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("materialCode");
        param.getFuzzyFields().add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
//        param.getParams().put("effectiveState", new Parameter(QueryParam.EQ, RmatCommonConsts.YES));
//        param.getParams().put("useStatus", new Parameter(QueryParam.NE, "1"));
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(!param.getParams().containsKey("orgId")) {// 非移动端默认项目，走PC端
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        if(StringUtils.isNotEmpty(condition)){
            Map<String, Object> conditionMap = JSON.parseObject(condition, Map.class);
            if (null != conditionMap.get("supplierId")) {
                Long supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
                param.getParams().put("supplierId", new Parameter(QueryParam.EQ, supplierId));
            }
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, projectId));
            }
        }
        IPage<TransferFlowEntity> page = service.queryPage(param,false);
        //拼子表明细数据
        List<TransferFlowVO> flows = new ArrayList<>();
        Map<Long,List<TransferFlowEntity>> flowMap = page.getRecords().stream().collect(Collectors.groupingBy(TransferFlowEntity::getMaterialId));
        for (Map.Entry<Long, List<TransferFlowEntity>> entry : flowMap.entrySet()) {
            TransferFlowVO fvo = service.getFlowData(entry.getValue());
            flows.add(fvo);
        }
        IPage<TransferFlowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(flows);
        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
