package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.bean.ExitApplyEntity;
import com.ejianc.business.rmat.service.CommonSupportService;
import com.ejianc.business.rmat.service.IExitApplyService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.HashMap;
import java.util.Map;

@Service("exitApply") 
public class ExitApplyBpmServiceImpl implements ICommonBusinessService {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private IExitApplyService service;

	@Autowired
	private CommonSupportService commonSupportService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ExitApplyEntity exitApplyEntity = service.selectById(billId);

		//推送供方
		Map<String, String> headers = new HashMap<>();
		CommonResponse<String> tokenres = commonSupportService.getAccessToken(headers);
		if (tokenres.isSuccess()) {
			logger.info("获取供方token--" + headers);
			CommonResponse<String> pushres = service.pushConfirmEntity(headers, exitApplyEntity);
			logger.info("获取推送供方结果--" + pushres);
			if (pushres.isSuccess()) {
				//推送成功后处理逻辑
				if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state) {
					exitApplyEntity.setCommitId(InvocationInfoProxy.getUserid().toString());
					//已拒绝,重新提交需要改为未确认状态
					if (2 == exitApplyEntity.getConfirmFlag()) {
						exitApplyEntity.setConfirmFlag(0);
					}
				}
				service.saveOrUpdate(exitApplyEntity, false);
			} else {
				return pushres;
			}
		} else {
			return tokenres;
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.error("退场申请单暂不支持回退功能!");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
