package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.rmat.bean.*;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.consts.TransFlowTypeEnum;
import com.ejianc.business.rmat.vo.TransferFlowVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rmat.mapper.TransferFlowMapper;
import com.ejianc.business.rmat.service.ITransferFlowService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 内部调拨流水表
 * 
 * @author generator
 * 
 */
@Service("transferFlowService")
public class TransferFlowServiceImpl extends BaseServiceImpl<TransferFlowMapper, TransferFlowEntity> implements ITransferFlowService{

    @Override
    public Boolean insertTransferFlow(TransferEntity entity,Integer flowType, Integer effectiveState) {
        if(effectiveState.equals(RmatCommonConsts.TWO)){
            Boolean flag = verify(entity.getId(),TransFlowTypeEnum.调入.getFlowType());
            if (Boolean.FALSE.equals(flag)) {
                throw new BusinessException("撤回失败!子表材料已被内部调拨单占用！");
            }
            //撤回
            List<TransferFlowEntity> flowList = this.list(new QueryWrapper<TransferFlowEntity>().eq("source_id",entity.getId()));
            flowList.forEach(e->{
                e.setEffectiveDate(null);
                e.setEffectiveState(RmatCommonConsts.NO);
            });
            return this.saveOrUpdateBatch(flowList);
        }
        List<TransferFlowVO> flowList = transfer(entity,flowType,effectiveState);
        return insertFlow(flowList);
    }   

    @Override
    public Boolean insertExitFlow(ExitEntity entity, Integer flowType, Integer effectiveState) {
        if (effectiveState.equals(RmatCommonConsts.TWO)){
            //撤回
            List<TransferFlowEntity> flowList = this.list(new QueryWrapper<TransferFlowEntity>().eq("source_id",entity.getId()));
            flowList.forEach(e->{
                e.setEffectiveDate(null);
                e.setEffectiveState(RmatCommonConsts.NO);
            });
            return this.saveOrUpdateBatch(flowList);
        }
        List<TransferFlowVO> flowList = new ArrayList<>();
        List<ExitSupplierEntity> detailList = entity.getExitSupplierList();
        for(ExitSupplierEntity detail : detailList){
            TransferFlowVO vo = new TransferFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            // 单据类型编码
            vo.setBillTypeCode(TransFlowTypeEnum.退场.getBillTypeCode());
            // 来源单据主键
            vo.setSourceId(entity.getId());
            // 来源单据明细主键
            vo.setSourceDetailId(detail.getId());
            // 单据编号
            vo.setBillCode(entity.getBillCode());
            // 上级组织
            vo.setParentOrgId(entity.getParentOrgId());
//            vo.setParentOrgCode(entity.getParentOrgCode());
//            vo.setParentOrgName(entity.getParentOrgName());
            //项目
            vo.setProjectId(entity.getProjectId());
            //vo.setProjectCode(entity.getProjectCode());
            vo.setProjectName(entity.getProjectName());
            // 所属组织
            vo.setOrgId(entity.getOrgId());
//            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            // 经办人
            vo.setEmployeeId(entity.getEmployeeId());
            vo.setEmployeeName(entity.getEmployeeName());
            // 业务日期
            vo.setBillDate(entity.getExitDate());
            // 生效日期默认当前日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);
            // 审批通过后生效
            vo.setEffectiveState(effectiveState);
            // 物料分类
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            // 物料
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            // 规格型号
            vo.setSpec(detail.getSpec());
            // 档案单位
            vo.setUnitId(detail.getUnitId());
            vo.setUnitName(detail.getUnitName());
            // 档案数量
            vo.setNum(detail.getNum());
            vo.setRealUnitId(detail.getRealUnitId());
            // 实物单位
            vo.setRealUnitName(detail.getRealUnitName());
            // 实物数量
            vo.setRealNum(detail.getRealNum());
            // 转换系数
            vo.setRealTransScale(detail.getRealTransScale());
            // 新增/编辑/删除
            vo.setRowState(detail.getRowState());
            vo.setRentUnitId(detail.getRentUnitId());
            vo.setRentUnitName(detail.getRentUnitName());
            vo.setRentNum(detail.getRentNum());
            vo.setRentTransScale(detail.getRentTransScale());
            vo.setRealUnitId(detail.getRealUnitId());
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealNum());
            vo.setRealTransScale(detail.getRentTransScale());
            vo.setUnitId(detail.getUnitId());
            vo.setUnitName(detail.getUnitName());
            vo.setNum(detail.getNum());
            vo.setAmount(detail.getRealOutNum());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSupplierId(detail.getSupplierId());
            vo.setSupplierName(detail.getSupplierName());
            vo.setFlowType(String.valueOf(flowType));
            vo.setInOutFlag(RmatCommonConsts.OUT);// 退场
            vo.setQueryId(entity.getProjectId() + "_"+ entity.getSupplierId());
            vo.setUseStatus("0");
            flowList.add(vo);
        }
        writeBack(flowList,entity.getSupplierId());
        return insertFlow(flowList);
    }

    @Override
    public Boolean delFlow(List<Long> sourceIds, Integer flowType) {
        if(CollectionUtils.isEmpty(sourceIds)){
            return true;
        }
        QueryWrapper ew = new QueryWrapper();
        ew.in("source_id", sourceIds);
        ew.eq("bill_type_code", TransFlowTypeEnum.getEnumByInOutType(flowType).getBillTypeCode());
        return super.remove(ew);
    }

    @Override
    public List<TransferFlowVO> getListData(List<TransferFlowVO> flowVo) {
        Map<String,List<TransferFlowVO>> flowMap = flowVo.stream().collect(Collectors.groupingBy(x -> x.getProjectId()+"_"+x.getSupplierId()));
        TransferFlowVO fvo;
        List<TransferFlowVO> flowVoS = new ArrayList<>();
        for (Map.Entry<String,List<TransferFlowVO>> entry : flowMap.entrySet()){
            fvo = entry.getValue().get(0);
            TransferFlowVO vo = new TransferFlowVO();
            String[] temp = entry.getKey().split("_");
            vo.setProjectId(Long.valueOf(temp[0]));
            vo.setProjectCode(fvo.getProjectCode()!=null ?fvo.getProjectCode() : null);
            vo.setSupplierId(Long.valueOf(temp[1]));
            vo.setProjectName(fvo.getProjectName());
            vo.setSupplierName(fvo.getSupplierName());
            vo.setOrgId(fvo.getOrgId());
            vo.setOrgName(fvo.getOrgName());
            vo.setOrgCode(fvo.getOrgCode()!=null ? fvo.getOrgCode() : null);
            vo.setParentOrgId(fvo.getParentOrgId());
            vo.setParentOrgCode(fvo.getParentOrgCode()!=null ? fvo.getParentOrgCode() : null);
            vo.setParentOrgName(fvo.getParentOrgName()!=null ? fvo.getParentOrgName() : null);
            vo.setSumOnHandNums(entry.getValue().stream()
                    .filter(x-> RmatCommonConsts.IN.equals(x.getInOutFlag()) && x.getAmount()!=null && x.getEffectiveState().equals(RmatCommonConsts.YES)).
                            map(TransferFlowVO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setSumExitNums(entry.getValue().stream()
                    .filter(x-> RmatCommonConsts.OUT.equals(x.getInOutFlag()) && x.getAmount()!=null).
                            map(TransferFlowVO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            flowVoS.add(vo);
        }
        return flowVoS;
    }

    @Override
    public TransferFlowVO getFlowData(List<TransferFlowEntity> v) {
        TransferFlowEntity e;
        BigDecimal sumOnHandNums;
        BigDecimal sumExitNums;
        e = v.get(0);
        TransferFlowVO fvo = new TransferFlowVO();
        fvo.setId(e.getId());
        fvo.setMaterialId(e.getMaterialId());
        fvo.setMaterialCode(e.getMaterialCode());
        fvo.setMaterialName(e.getMaterialName());
        fvo.setMaterialTypeId(e.getMaterialTypeId());
        fvo.setMaterialTypeName(e.getMaterialTypeName());
        fvo.setUnitId(e.getUnitId());
        fvo.setUnitName(e.getUnitName());
        fvo.setRealUnitId(e.getRealUnitId());
        fvo.setRealUnitName(e.getRealUnitName());
        fvo.setRealNum(e.getRealNum());
        fvo.setNum(e.getNum());
        fvo.setSpec(e.getSpec());
        fvo.setMaterialSourceId(e.getMaterialSourceId());
        fvo.setRealTransScale(e.getRealTransScale());
        sumOnHandNums = v.stream()
                .filter(x-> RmatCommonConsts.IN.equals(x.getInOutFlag()) && x.getAmount()!=null && x.getEffectiveState().equals(RmatCommonConsts.YES)).
                        map(TransferFlowEntity::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        fvo.setSumOnHandNums(sumOnHandNums);//累计在场数量
        sumExitNums = v.stream()
                .filter(x-> RmatCommonConsts.OUT.equals(x.getInOutFlag()) && x.getAmount()!=null).
                        map(TransferFlowEntity::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        fvo.setSumExitNums(sumExitNums);//累计退场数量
        fvo.setRealOnHandNums(ComputeUtil.safeSub(sumOnHandNums,sumExitNums));//剩余实物在场材料
        fvo.setSumNums(ComputeUtil.safeMultiply(fvo.getRealOnHandNums(),fvo.getRealTransScale()));
        return fvo;
    }

    @Override
    public Boolean verify(Long id,Integer flowType) {
        List<TransferFlowEntity> list = this.list(new QueryWrapper<TransferFlowEntity>()
                .eq("source_id", id).eq("flow_type",flowType)
                .eq("effective_state",RmatCommonConsts.YES).isNotNull("occup_num"));
        return !CollectionUtils.isNotEmpty(list);
    }

    @Override
    public String delete(List<Long> sourceIds, Integer flowType) {
        if (flowType.equals(TransFlowTypeEnum.调出.getFlowType()) || flowType.equals(TransFlowTypeEnum.退场.getFlowType())){
            for (Long id : sourceIds) {
                if (flowType.equals(TransFlowTypeEnum.调出.getFlowType())){
                    Boolean flag = verify(id,TransFlowTypeEnum.调入.getFlowType());
                    if (Boolean.FALSE.equals(flag)) {
                        throw new BusinessException("删除失败!子表材料已被内部调拨单占用！");
                    }
                }
                backNumAndId(id,flowType);
            }
        }else {
            //入场材料撤回删除
            Boolean flag = verify(sourceIds.get(0),flowType);
            if (Boolean.FALSE.equals(flag)) {
                throw new BusinessException("删除失败!子表材料已被内部调拨单占用！");
            }
        }
        delFlow(sourceIds,flowType);
        return "删除成功！";
    }

    @Override
    public Boolean insertFlow(List<TransferFlowVO> vos) {
        List<TransferFlowVO> addList = new ArrayList<>();
        List<Long> delIds = new ArrayList<>();
        for(TransferFlowVO vo : vos){
            vo.setId(vo.getSourceDetailId());// 默认主键为子表主键
            if(!"del".equals(vo.getRowState())){
                addList.add(vo);
            } else {
                delIds.add(vo.getId());
            }
        }
        if(CollectionUtils.isNotEmpty(addList)){
            List<TransferFlowEntity> list = BeanMapper.mapList(addList, TransferFlowEntity.class);
            super.saveOrUpdateBatch(list);
        }
        if(CollectionUtils.isNotEmpty(delIds)){
            super.removeByIds(delIds);
        }
        return true;
    }

    public List<TransferFlowVO> transfer(TransferEntity entity, Integer flowType, Integer effectiveState) {
        List<TransferFlowVO> flowList = new ArrayList<>();
        List<TransferDetailEntity> detailList = entity.getDetailList();
        for(TransferDetailEntity detail : detailList){
            TransferFlowVO vo = new TransferFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            // 单据类型编码
            vo.setBillTypeCode(TransFlowTypeEnum.getEnumByInOutType(flowType).getBillTypeCode());
            // 来源单据主键
            vo.setSourceId(entity.getId());
            // 来源单据明细主键
            vo.setSourceDetailId(detail.getId());
            // 单据编号
            vo.setBillCode(entity.getBillCode());
            //项目
            vo.setProjectId(entity.getProjectId());
            vo.setProjectCode(entity.getProjectCode());
            vo.setProjectName(entity.getProjectName());
            // 上级组织
            vo.setParentOrgId(entity.getParentOrgId());
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            // 所属组织
            vo.setOrgId(entity.getOrgId());
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            // 经办人
            vo.setEmployeeId(entity.getEmployeeId());
            vo.setEmployeeName(entity.getEmployeeName());
            // 业务日期
            vo.setBillDate(entity.getTransferDate());
            // 生效日期默认当前日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);
            // 审批通过后生效
            vo.setEffectiveState(effectiveState);
            // 物料分类
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            // 物料
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            // 规格型号
            vo.setSpec(detail.getSpec());
            // 档案单位
            vo.setUnitId(detail.getUnitId());
            vo.setUnitName(detail.getUnitName());
            // 档案数量
            vo.setNum(detail.getNum()== null?ComputeUtil.safeMultiply(detail.getAllotInNum(),detail.getRealTransScale()):detail.getNum());
            vo.setRealUnitId(detail.getRealUnitId());
            // 实物单位
            vo.setRealUnitName(detail.getRealUnitName());
            // 实物数量
            vo.setRealNum(detail.getRealNum()== null?detail.getAllotInNum():detail.getRealNum());
            // 转换系数
            vo.setRealTransScale(detail.getRealTransScale());
            // 新增/编辑/删除
            vo.setRowState(detail.getRowState());
            vo.setAmount(detail.getAllotInNum());//调入数量/调出数量
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            if (TransFlowTypeEnum.getEnumByInOutType(flowType).equals(TransFlowTypeEnum.调出)){
                TransferFlowVO inVo = BeanMapper.map(vo,TransferFlowVO.class);
                inVo.setFlowType(String.valueOf(TransFlowTypeEnum.调入.getFlowType()));
                inVo.setUseStatus("0");
                // 进场
                inVo.setInOutFlag(RmatCommonConsts.IN);
                // 供应商
                inVo.setSupplierId(entity.getAllotInId());
                inVo.setSupplierName(entity.getAllotInName());
                inVo.setQueryId(entity.getProjectId() + "_"+ entity.getAllotInId());
                vo.setSupplierId(entity.getAllotOutId());
                vo.setSupplierName(entity.getAllotOutName());
                vo.setQueryId(entity.getProjectId() + "_"+ entity.getAllotOutId());
                vo.setFlowType(String.valueOf(TransFlowTypeEnum.调出.getFlowType()));
                vo.setInOutFlag(RmatCommonConsts.OUT);// 退场
                vo.setUseStatus("0");
                flowList.add(inVo);
            }else {
                // 供应商
                vo.setSupplierId(entity.getAllotInId());
                vo.setSupplierName(entity.getAllotInName());
                vo.setQueryId(entity.getProjectId() + "_"+ entity.getAllotInId());
                vo.setFlowType(String.valueOf(TransFlowTypeEnum.调入.getFlowType()));
                vo.setUseStatus("0");
                // 进场
                vo.setInOutFlag(RmatCommonConsts.IN);
            }
            flowList.add(vo);
        }
        if (flowType.equals(RmatCommonConsts.FOUR)){
            writeBack(flowList,entity.getAllotOutId());
        }
        return flowList;
    }

    //回写占用
    private void writeBack(List<TransferFlowVO> flowList, Long supplierId){
        List<Long> ids = flowList.stream().map(TransferFlowVO::getMaterialId).distinct().collect(Collectors.toList());
        //查询最先进场未占用的在场材料
        List<TransferFlowEntity> list = this.list(new QueryWrapper<TransferFlowEntity>()
                .eq("supplier_id", supplierId).eq("in_out_flag",RmatCommonConsts.IN)
                .eq("effective_state",RmatCommonConsts.YES).in("material_id",ids).orderByAsc("effective_date"));
        Map<String, TransferFlowEntity> maps = list.stream().collect(Collectors.toMap(x->String.valueOf(x.getId()), Function.identity()));
        for (TransferFlowVO vo : flowList) {
            if (!"add".equals(vo.getRowState())){
                backNumAndId(vo,maps);
            }
        }
        Map<Long, List<TransferFlowEntity>> flowMap = new ArrayList<>(maps.values()).stream().collect(Collectors.groupingBy(TransferFlowEntity::getMaterialId,LinkedHashMap::new,Collectors.toList()));
        List<TransferFlowEntity> entities = new ArrayList<>();
        BigDecimal count;
        BigDecimal onNum;
        String occNum;
        List<TransferFlowEntity> flows;
        for (TransferFlowVO vo : flowList) {
            if ("del".equals(vo.getRowState())){
                continue;
            }
            //在场材料
            flows = flowMap.get(vo.getMaterialId());
            //退场数量
            count = vo.getAmount();
            for (TransferFlowEntity e : flows) {
                onNum = ComputeUtil.safeSub(e.getAmount(),StringUtils.isBlank(e.getOccupNum())?BigDecimal.ZERO:new BigDecimal(e.getOccupNum()));
                count = ComputeUtil.safeSub(count, onNum);
                vo.setOccupId(StringUtils.isNotBlank(vo.getOccupId())?vo.getId()+ "," + e.getId() : e.getId().toString());
                if (count.compareTo(BigDecimal.ZERO) < 0) {
                    occNum = ComputeUtil.safeAdd(onNum, count).toString();
                    //在场材料未占完
                    e.setUseStatus("2");//部分占用
                    e.setOccupNum(occNum);
                    vo.setOccupNum(StringUtils.isNotBlank(vo.getOccupNum())?vo.getOccupNum()+","+occNum:occNum);
                    entities.add(e);
                    break;
                } else if (count.compareTo(BigDecimal.ZERO) > 0) {
                    //退场材料未退完
                    e.setUseStatus("1");//全部占用
                    e.setOccupNum(String.valueOf(e.getAmount()));
                    vo.setOccupNum(StringUtils.isNotBlank(vo.getOccupNum())?vo.getOccupNum()+","+onNum:String.valueOf(onNum));
                    entities.add(e);
                } else {
                    e.setUseStatus("1");//全部占用
                    e.setOccupNum(String.valueOf(e.getAmount()));
                    vo.setOccupNum(StringUtils.isNotBlank(vo.getOccupNum())?vo.getOccupNum()+","+onNum:String.valueOf(onNum));
                    entities.add(e);
                    break;
                }
            }
        }
        this.saveOrUpdateBatch(entities);
    }

    public void backNumAndId(Long sourceId, Integer flowType){
        //根据source_id查询退场材料
        List<TransferFlowEntity> list = this.list(new QueryWrapper<TransferFlowEntity>()
                .eq("source_id", sourceId).eq("flow_type",flowType.toString()));
        List<String> sids = list.stream().map(TransferFlowEntity::getOccupId).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> stemp = new ArrayList<>();
        //获取所占用的在场材料id
        sids.forEach(e->{
            if (e.contains(",")){
                stemp.addAll(new ArrayList<>(Arrays.asList(e.split(","))));
            }else {
                stemp.add(e);
            }
        });
        List<Long> ids = stemp.stream().map(Long::valueOf).collect(Collectors.toList());
        //查询被占用流水
        List<TransferFlowEntity> entityList = this.list(new QueryWrapper<TransferFlowEntity>().in("id",ids));
        Map<String, TransferFlowEntity> maps = entityList.stream().collect(Collectors.toMap(x->String.valueOf(x.getId()), Function.identity()));
        //占用退还
        for (TransferFlowVO vo : BeanMapper.mapList(list,TransferFlowVO.class)) {
            backNumAndId(vo,maps);
        }
        List<TransferFlowEntity> entities = new ArrayList<>(maps.values());
        this.saveOrUpdateBatch(entities);
    }

    TransferFlowEntity t;
    List<String> temps;
    List<String> femp;
    int index;
    List<String> femps;
    public void backNumAndId(TransferFlowVO vo,Map<String,TransferFlowEntity> maps){
        if (vo.getOccupId().contains(",")){
            temps = new ArrayList<>(Arrays.asList(vo.getOccupNum().split(",")));
            femp = new ArrayList<>(Arrays.asList(vo.getOccupId().split(",")));
            femps = femp;
            for (String s : femp) {
                t = maps.get(s);
                if (t.getOccupId().contains(",")){
                    //材料被多个单据占用
                    index = vo.getOccupId().indexOf(s);
                    t.setOccupNum(String.valueOf(ComputeUtil.safeSub(new BigDecimal(t.getOccupNum()),new BigDecimal(temps.get(index)))));
                    t.setUseStatus("2");
                    femps.remove(s);
                    temps.remove(index);
                    vo.setOccupId(String.join(",", femps));
                    vo.setOccupNum(String.join(",", temps));
                }else {
                    vo.setOccupId(null);
                    vo.setOccupNum(null);
                    t.setUseStatus("0");
                    t.setOccupNum(null);
                }
                maps.put(t.getId().toString(), t);
            }
        }
    }

}
