package com.ejianc.business.rmat.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.rmat.vo.ArchivesVOS;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.rmat.bean.ArchivesEntity;
import com.ejianc.business.rmat.service.IArchivesService;
import com.ejianc.business.rmat.vo.ArchivesVO;

/**
 * 周转材档案实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("archives")
public class ArchivesController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IArchivesService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ArchivesVO> saveOrUpdate(@RequestBody ArchivesVO saveOrUpdateVO) {
        ArchivesVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ArchivesVO> queryDetail(Long id) {
    	ArchivesEntity entity = service.selectById(id);
    	ArchivesVO vo = BeanMapper.map(entity, ArchivesVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ArchivesVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ArchivesVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ArchivesVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ArchivesVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        if (param.getParams().size()!=0 && param.getParams().get("categoryId") != null){
            param.getParams().put("categoryInnerCode", new Parameter(QueryParam.LIKE, param.getParams().get("categoryId").getValue()));
            param.getParams().remove("categoryId");
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getOrgId()));//只查询当前组织，不查询本下
        IPage<ArchivesEntity> page = service.queryPage(param,false);
        IPage<ArchivesVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ArchivesVO.class));


        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ArchivesEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Archives-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refArchivesData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ArchivesVO>> refArchivesData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 0));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ArchivesEntity> page = service.queryPage(param,false);
        IPage<ArchivesVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ArchivesVO.class));
        CommonResponse<OrgVO> orgVo = iOrgApi.detailById(InvocationInfoProxy.getOrgId());
        String orgInnerCode = orgVo.getData().getInnerCode();
        String[] codes = orgInnerCode.split("\\|");
        List<ArchivesVO> list = new ArrayList<>(); // 最终结果
        List<ArchivesVO> archivesVOS = new ArrayList<>();
        List<Long> longs = new ArrayList<>();
        for (ArchivesVO vo : pageData.getRecords()) {
            if (orgInnerCode.equals(vo.getOrgInnerCode())) {
                list.add(vo);
                longs.add(vo.getMaterialId()); // 去重过后的matrialId列表
            }
        }
        for (ArchivesVO vo : pageData.getRecords()) {
            if (!longs.contains(vo.getMaterialId())) {
                longs.add(vo.getMaterialId()); // 去重过后的matrialId列表
                archivesVOS.add(vo);  // 剩余未查询到最终结果、每种物料只包含一条数据
            }
        }
        for (int i = codes.length - 1; i >= 0; i--) {
            for (ArchivesVO vo : archivesVOS) {
                if (!list.contains(vo.getMaterialId())){
                    LambdaQueryWrapper<ArchivesEntity> queryWrapper = new LambdaQueryWrapper<>();
                    queryWrapper.eq(ArchivesEntity::getMaterialId, vo.getMaterialId());
                    queryWrapper.eq(ArchivesEntity::getOrgId, codes[i]);
                    queryWrapper.eq(ArchivesEntity::getStatus, 0);
                    ArchivesEntity archivesEntity = service.getOne(queryWrapper);
                    if (archivesEntity != null) {
                        list.add(BeanMapper.map(archivesEntity, ArchivesVO.class));
                    }
                }
            }
        }
        pageData.setRecords(list);
        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    @RequestMapping(value = "/lazyMaterialCategory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialCategoryVO>> lazyMaterialCategory(Long parentId) {
        List<MaterialCategoryVO> materialCategoryVO = new ArrayList<>();
        List list = new ArrayList();
        LambdaQueryWrapper<ArchivesEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ArchivesEntity::getDr,0);
        queryWrapper.eq(ArchivesEntity::getOrgId,InvocationInfoProxy.getOrgId());//只查询当前组织
        queryWrapper.like(parentId != null,ArchivesEntity::getCategoryInnerCode,parentId);
        List<ArchivesEntity> archivesEntities = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(archivesEntities)){
            for (ArchivesEntity archivesEntity:archivesEntities){
                list.add(archivesEntity.getMaterialTypeId());
            }
            CommonResponse<List<MaterialCategoryVO>> materialCategoryVOS = materialApi.queryCategoryListByChildren(list);
            List<MaterialCategoryVO> dateList = materialCategoryVOS.getData();
            if (parentId != null){ // 选择树形查找子集
                for (MaterialCategoryVO materialCategoryVO1 : dateList){
                    if (materialCategoryVO1.getParentId() !=null && materialCategoryVO1.getParentId().equals(parentId)){
                        materialCategoryVO.add(materialCategoryVO1);
                    }
                }
            }else { // 刷新页面查询全部树形
                for (MaterialCategoryVO materialCategoryVO1 : dateList){
                    if (materialCategoryVO1.getParentId() ==null ){
                        materialCategoryVO.add(materialCategoryVO1);
                    }
                }
            }
        }
        return CommonResponse.success(materialCategoryVO);
    }

    /**
     * @Description 启用停用
     */
    @RequestMapping(value = "/turnSwitch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> turnSwitch(@RequestBody Long id) {
        return CommonResponse.success(service.turnSwitch(id));
    }

    /**
     * @Description 查询最近上级的周转材档案
     */
    @RequestMapping(value = "/queryArchives", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ArchivesVO> queryArchives(@RequestBody ArchivesVO vo) {
        return CommonResponse.success(service.queryArchives(vo));
    }

    /**
     * @Description 查询最近上级的周转材档案根据材料ids
     */
    @RequestMapping(value = "/queryByIds", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<Long,ArchivesVO>> queryByIds(@RequestBody ArchivesVO vo) {
        return CommonResponse.success(service.queryByIds(vo.getIds(),vo.getOrgId()));
    }

    /**
     * @Description 查询最近上级的周转材档案根据材料ids
     */
    @RequestMapping(value = "/queryIds", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ArchivesVO>> queryIds(@RequestBody ArchivesVOS vos) {
        return CommonResponse.success(service.queryIds(vos));
    }

}
