package com.ejianc.business.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rmat.bean.ExitApplyDetailEntity;
import com.ejianc.business.rmat.bean.ExitApplyEntity;
import com.ejianc.business.rmat.service.IExitApplyDetailService;
import com.ejianc.business.rmat.service.IExitApplyService;
import com.ejianc.business.rmat.vo.ExitApplyDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 退场申请单明细
 *
 * @author generator
 */
@Controller
@RequestMapping("exitApplyDetail")
public class ExitApplyDetailController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IExitApplyDetailService service;

    @Autowired
    private IExitApplyService exitApplyService;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitApplyDetailVO> saveOrUpdate(@RequestBody ExitApplyDetailVO saveorUpdateVO) {
        ExitApplyDetailEntity entity = BeanMapper.map(saveorUpdateVO, ExitApplyDetailEntity.class);
        service.saveOrUpdate(entity, false);
        ExitApplyDetailVO vo = BeanMapper.map(entity, ExitApplyDetailVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExitApplyDetailVO> queryDetail(Long id) {
        ExitApplyDetailEntity entity = service.selectById(id);
        ExitApplyDetailVO vo = BeanMapper.map(entity, ExitApplyDetailVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExitApplyDetailVO> vos) {
        service.removeByIds(vos.stream().map(ExitApplyDetailVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExitApplyDetailVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        IPage<ExitApplyDetailEntity> page = service.queryPage(param, false);
        IPage<ExitApplyDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExitApplyDetailVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * 退场明细参照
     *
     * @Param pageNumber: 当前页
     * @Param pageSize: 每页数
     * @Param condition: 查询条件
     * @Param searchText: 模糊查询  pId  退场申请单主键
     * @Return com.ejianc.framework.core.response.CommonResponse<com.baomidou.mybatisplus.core.metadata.IPage < com.ejianc.business.wzxt.vo.OrderDetailVO>>
     **/
    @RequestMapping(value = "exitApplyDetailRef", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ExitApplyDetailVO>> orderDetailRef(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber);
        queryParam.setPageSize(pageSize);
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("materialName");
        queryParam.getFuzzyFields().add("materialTypeName");
        queryParam.getFuzzyFields().add("materialCode");
        IPage<ExitApplyDetailVO> pageData = new Page<>();
        if (StringUtils.isNotBlank(condition)) {
            Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                LambdaQueryWrapper<ExitApplyEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(ExitApplyEntity::getProjectId, conditionMap.get("projectId"));
                queryWrapper.in(ExitApplyEntity::getBillState, 1,3);
                ExitApplyEntity exitApplyEntities = exitApplyService.getOne(queryWrapper,false);
                if(exitApplyEntities != null){
                    queryParam.getParams().put("pId", new Parameter("eq", exitApplyEntities.getId()));
                    IPage<ExitApplyDetailEntity> page = service.queryPage(queryParam, false);
                    pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
                    pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExitApplyDetailVO.class));
                }else{
                    throw new BusinessException("该项目没有已生效的退场申请单！");
                }
            }else{
                throw new BusinessException("网络异常，未获取到项目主键！");
            }
        }
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


}
