package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.rmat.vo.ArchivesVO;
import com.ejianc.business.rmat.vo.ArchivesVOS;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rmat.mapper.ArchivesMapper;
import com.ejianc.business.rmat.bean.ArchivesEntity;
import com.ejianc.business.rmat.service.IArchivesService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 周转材档案实体
 *
 * @author generator
 *
 */
@Service("archivesService")
public class ArchivesServiceImpl extends BaseServiceImpl<ArchivesMapper, ArchivesEntity> implements IArchivesService{

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;

    @Override
    public ArchivesVO saveOrUpdate(ArchivesVO saveOrUpdateVO) {
        ArchivesVO archivesVO = new ArchivesVO();
        LambdaQueryWrapper<ArchivesEntity> query = new LambdaQueryWrapper<>();
        query.eq(ArchivesEntity::getId,saveOrUpdateVO.getId());
        List<ArchivesEntity> archivesEntities1 = super.list(query);
        if (CollectionUtils.isNotEmpty(archivesEntities1)){
            // 修改
            ArchivesEntity archivesEntity =  selectById(saveOrUpdateVO.getId());
            archivesEntity.setRealUnitId(saveOrUpdateVO.getRealUnitId());
            archivesEntity.setRealUnitName(saveOrUpdateVO.getRealUnitName());
            archivesEntity.setTransScale(saveOrUpdateVO.getTransScale());
            archivesEntity.setStatus(saveOrUpdateVO.getStatus());
            super.saveOrUpdate(archivesEntity);
            archivesVO = (BeanMapper.map(archivesEntity,ArchivesVO.class));
        }else {
            // 新增
            LambdaQueryWrapper<ArchivesEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(ArchivesEntity::getMaterialId,saveOrUpdateVO.getId());
            queryWrapper.eq(ArchivesEntity::getOrgId, InvocationInfoProxy.getOrgId());
            List<ArchivesEntity> archivesEntities = super.list(queryWrapper);
            if (CollectionUtils.isNotEmpty(archivesEntities)){
                throw  new BusinessException("编号为"+saveOrUpdateVO.getCode()+"的物资已被引用！");
            }
            CommonResponse<MaterialCategoryVO> materialCategoryVO = materialApi.queryCategoryById(saveOrUpdateVO.getCategoryId());
            saveOrUpdateVO.setCategoryInnerCode(materialCategoryVO.getData().getInnerCode());
            saveOrUpdateVO.setMaterialId(saveOrUpdateVO.getId());
            saveOrUpdateVO.setMaterialCode(saveOrUpdateVO.getCode());
            saveOrUpdateVO.setMaterialName(saveOrUpdateVO.getName());
            saveOrUpdateVO.setMaterialSourceId(saveOrUpdateVO.getSourceId());
            saveOrUpdateVO.setMaterialTypeId(saveOrUpdateVO.getCategoryId());
            saveOrUpdateVO.setMaterialTypeName(saveOrUpdateVO.getCategoryName());
            saveOrUpdateVO.setOrgId(InvocationInfoProxy.getOrgId());
            CommonResponse<OrgVO> orgVo = iOrgApi.detailById(saveOrUpdateVO.getOrgId());
            saveOrUpdateVO.setOrgCode(orgVo.getData().getCode());
            saveOrUpdateVO.setOrgName(orgVo.getData().getName());
            saveOrUpdateVO.setOrgInnerCode(orgVo.getData().getInnerCode());
            saveOrUpdateVO.setUnitId(saveOrUpdateVO.getDef3()); // 档案单位主键为自定义字段3
            saveOrUpdateVO.setStatus(0); //状态默认启用
            saveOrUpdateVO.setRealUnitId(String.valueOf(IdWorker.getId())); // 实物单位主键生成
            saveOrUpdateVO.setRealUnitName(saveOrUpdateVO.getUnitName());
            saveOrUpdateVO.setTransScale(new BigDecimal(1));
            saveOrUpdateVO.setId(null);
            ArchivesEntity entity = BeanMapper.map(saveOrUpdateVO, ArchivesEntity.class);
            super.saveOrUpdate(entity);
            archivesVO = (BeanMapper.map(entity,ArchivesVO.class));
        }
        return archivesVO;
    }

    @Override
    public String turnSwitch(Long id) {
        ArchivesEntity archivesEntity = selectById(id);
        if (archivesEntity.getStatus() == 0){
            archivesEntity.setStatus(1);
            super.saveOrUpdate(archivesEntity);
            return "停用成功！";
        }else {
            archivesEntity.setStatus(0);
            super.saveOrUpdate(archivesEntity);
            return "启用成功！";
        }
    }

    @Override
    public ArchivesVO queryArchives(ArchivesVO vo) {
        ArchivesVO archivesVO = new ArchivesVO();
        CommonResponse<OrgVO> orgVo = iOrgApi.detailById(vo.getOrgId());
        String[] orgInnerCode = (orgVo.getData().getInnerCode()).split("\\|");
        List<String> list = Lists.newArrayList(orgInnerCode);
        for (int i=list.size()-1;i>=0;i--) {
            LambdaQueryWrapper<ArchivesEntity> query = new LambdaQueryWrapper<>();
            query.eq(ArchivesEntity::getOrgId, list.get(i));
            query.eq(ArchivesEntity::getMaterialId, vo.getMaterialId());
            List<ArchivesEntity> archivesEntities = super.list(query);
            if (CollectionUtils.isNotEmpty(archivesEntities)) {
                for (ArchivesEntity entity : archivesEntities) {
                    archivesVO = BeanMapper.map(entity, ArchivesVO.class);
                    break;
                }
            }
        }
        return archivesVO;
    }

    @Override
    public Map<Long, ArchivesVO> queryByIds(List<Long> ids, Long orgId) {
        Map<Long, ArchivesVO> voMap = new HashMap<>();
        CommonResponse<OrgVO> orgVo = iOrgApi.detailById(orgId);
        List<Long> orgIds = Arrays.stream(orgVo.getData().getInnerCode().split("\\|")).map(Long::parseLong).collect(Collectors.toList());
        Collections.reverse(orgIds);
        List<ArchivesEntity> list = this.list(new QueryWrapper<ArchivesEntity>().in("org_id",orgIds).in("material_id",ids));
        if (CollectionUtils.isEmpty(list)){
            return Collections.emptyMap();
        }
        //同一组织下，每条物料只有一条数据
        Map<String, ArchivesVO> map = BeanMapper.mapList(list,ArchivesVO.class).stream().collect(Collectors.toMap(x->(x.getOrgId()+"|"+x.getMaterialId()), Function.identity()));
        //Map<String,List<ArchivesVO>> map = BeanMapper.mapList(list,ArchivesVO.class).stream().collect(Collectors.groupingBy(x -> x.getOrgId()+"|"+x.getMaterialId(),LinkedHashMap::new, Collectors.toList()));
        List<String> joinIds = new ArrayList<>();
        String s;
        for (Long oid : orgIds) {
            for (Long id : ids) {
                s = oid + "|" + id;
                joinIds.add(s);
            }
        }
        Long key;
        for (String joinId : joinIds) {
            key = Long.parseLong(joinId.split("\\|")[1]);
            if (voMap.containsKey(key)){
                continue;
            }
            if (map.containsKey(joinId)) {
                voMap.put(key,map.get(joinId));
            }
        }
        return voMap;
    }

    @Override
    public List<ArchivesVO> queryIds(ArchivesVOS vos) {
        List<ArchivesVO> archivesVOList = new ArrayList<>();
        CommonResponse<OrgVO> orgVo = iOrgApi.detailById(vos.getOrgId());
        List<Long> orgIds = Arrays.stream(orgVo.getData().getInnerCode().split("\\|")).map(Long::parseLong).collect(Collectors.toList());
        Collections.reverse(orgIds);
        List<ArchivesEntity> list = new ArrayList<>();
        List ids = new ArrayList();
        switch (vos.getType()) {
            case 0:
                list = this.list(new QueryWrapper<ArchivesEntity>().in("org_id",orgIds).in("material_id",vos.getMaterialIds()));
                break;
            case 1:
                list = this.list(new QueryWrapper<ArchivesEntity>().in("org_id",orgIds).in("material_type_id",vos.getCategoryIds()));
                break;
        }
        for (Long orgId : orgIds) {
            for (ArchivesEntity entity : list) {
                if (!ids.contains(entity.getMaterialId())) {
                    if (entity.getOrgId().equals(orgId)) {
                        archivesVOList.add(BeanMapper.map(entity,ArchivesVO.class));
                        ids.add(entity.getMaterialId());
                    }
                }
            }
        }
        return archivesVOList;
    }
}
