package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.rmat.vo.CoordinationSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rmat.mapper.CoordinationSetMapper;
import com.ejianc.business.rmat.bean.CoordinationSetEntity;
import com.ejianc.business.rmat.service.ICoordinationSetService;

import java.util.List;

/**
 * 周转材协同设置
 *
 * @author generator
 *
 */
@Service("coordinationSetService")
public class CoordinationSetServiceImpl extends BaseServiceImpl<CoordinationSetMapper, CoordinationSetEntity> implements ICoordinationSetService{

    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public CoordinationSetVO saveOrUpdate(CoordinationSetVO saveOrUpdateVO) {
        CoordinationSetVO coordinationSetVO = new CoordinationSetVO();
        LambdaQueryWrapper<CoordinationSetEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(CoordinationSetEntity::getOrgId, saveOrUpdateVO.getOrgId());
        List<CoordinationSetEntity> entities = super.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(entities)) {
            // 修改
            LambdaUpdateWrapper<CoordinationSetEntity> updateWrapper=new LambdaUpdateWrapper<>();
            updateWrapper.set(saveOrUpdateVO.getSupplyStatus()!=null,CoordinationSetEntity::getSupplyStatus, saveOrUpdateVO.getSupplyStatus());
            updateWrapper.set(saveOrUpdateVO.getMandatoryStatus() != null, CoordinationSetEntity::getMandatoryStatus, saveOrUpdateVO.getMandatoryStatus());
            updateWrapper.eq(CoordinationSetEntity::getOrgId, saveOrUpdateVO.getOrgId());
            super.update(updateWrapper);
            for (CoordinationSetEntity coordinationSetEntity : entities) {
                coordinationSetVO = BeanMapper.map(coordinationSetEntity, CoordinationSetVO.class);
            }
        }else {
            // 新增
            CoordinationSetEntity coordinationSetEntity = BeanMapper.map(saveOrUpdateVO, CoordinationSetEntity.class);
            coordinationSetEntity.setOrgInnerCode(iOrgApi.detailById(InvocationInfoProxy.getOrgId()).getData().getInnerCode());
            super.saveOrUpdate(coordinationSetEntity);
            coordinationSetVO = BeanMapper.map(coordinationSetEntity, CoordinationSetVO.class);
        }
        return coordinationSetVO;
    }
}
