package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.bean.RmatFlowEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.MaterialConstant;
import com.ejianc.business.rmat.consts.MaterialStateEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.mapper.MaterialMapper;
import com.ejianc.business.rmat.service.IManageSetService;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.vo.ManageSetVO;
import com.ejianc.business.rmat.vo.MaterialFlowVO;
import com.ejianc.business.rmat.vo.MaterialVO;
import com.ejianc.business.rmat.vo.MaxTimeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

/**
 * 材料公共接口
 * 
 * @author generator
 * 
 */
@Service("materialService")
public class MaterialServiceImpl extends BaseServiceImpl<MaterialMapper, RmatFlowEntity> implements IMaterialService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

//    @Autowired
//    private IRentCalculateService rentService;

    @Autowired
    private IRmatFlowService flowService;

//    @Autowired
//    private IConvertService convertService;

    @Autowired
    private IManageSetService manageSetService;

    @Override
    public List<MaterialVO> queryCheckList(QueryParam param, String type) {
        if("report".equals(type)){
            param.getFuzzyFields().add("contractName");
            param.getFuzzyFields().add("supplierName");
            param.getFuzzyFields().add("billCode");
        }
        param.getFuzzyFields().add("materilCode");
        param.getFuzzyFields().add("materilName");
        param.getFuzzyFields().add("spec");
        List<RmatFlowEntity> flowList = flowService.queryList(param, false);

        List<RmatFlowEntity> checkList = new ArrayList<>();// 验收单
        List<RmatFlowEntity> startList = new ArrayList<>();// 启用单
        List<RmatFlowEntity> stopList = new ArrayList<>();// 停用单
        List<RmatFlowEntity> restList = new ArrayList<>();// 退赔单
        List<RmatFlowEntity> loseList = new ArrayList<>();// 遗失单
        List<RmatFlowEntity> tempRestList = new ArrayList<>();// 未生效退赔单
        List<RmatFlowEntity> tempLoseList = new ArrayList<>();// 未生效遗失单
        for(RmatFlowEntity flow : flowList){
            if(RmatCommonConsts.YES.equals(flow.getEffectiveState())){
                if(BillTypeEnum.验收单.getCode().equals(flow.getBillTypeCode())){
                    checkList.add(flow);
                }
                if(BillTypeEnum.停用单.getCode().equals(flow.getBillTypeCode())){
                    stopList.add(flow);
                }
                if(BillTypeEnum.启用单.getCode().equals(flow.getBillTypeCode())){
                    startList.add(flow);
                }
                if(BillTypeEnum.退场单.getCode().equals(flow.getBillTypeCode())){
                    restList.add(flow);
                }
                if(BillTypeEnum.赔偿单.getCode().equals(flow.getBillTypeCode())){
                    loseList.add(flow);
                }
            }
            if(RmatCommonConsts.NO.equals(flow.getEffectiveState())){
                if(BillTypeEnum.退场单.getCode().equals(flow.getBillTypeCode())){
                    tempRestList.add(flow);
                }
                if(BillTypeEnum.赔偿单.getCode().equals(flow.getBillTypeCode())){
                    tempLoseList.add(flow);
                }
            }
        }

        Map<String, MaterialVO> map = new HashMap<>();// key-合同主键+物料主键+使用状态+转换系数，value-物料
        String key = null;
        for(RmatFlowEntity detail: checkList){// 验收单
            for(int i = 0; i< 2; i++){// 0-停用，1-启用
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + i + "|" + detail.getRentTransScale();
                MaterialVO vo = new MaterialVO();
                if(!map.containsKey(key)){
                    vo.setId(key);
                    // 转换材料明细信息
                    this.transferVO(detail, vo);
                    vo.setUseStatus(String.valueOf(i));
                } else {
                    vo = map.get(key);
                }
                // 已进场
                vo.setCheckedNum(ComputeUtil.safeAdd(vo.getCheckedNum(), detail.getNum()));
                // 已启用 = 已进场
                vo.setStartedNum(ComputeUtil.safeAdd(vo.getStartedNum(), detail.getNum()));
                // 辅数量(停用状态物料初始辅数量应为0)
                if(i == 1){
                    this.collectNum(detail, vo, true);
                }
                map.put(key, vo);
            }
        }
        for(RmatFlowEntity detail: startList){// 启用单
            for(int i = 0; i< 2; i++) {// 0-停用，1-启用
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + i + "|" + detail.getRentTransScale();
                if(!map.containsKey(key)){
                    continue;
                }
                MaterialVO vo = map.get(key);
                if (i == 0){// 已停用 = 已停用 - 已启用
                    vo.setStopedNum(ComputeUtil.safeSub(vo.getStopedNum(), detail.getNum()));
                    // 停用单辅数量 = 停用单辅数量 - 启用单辅数量
                    this.collectNum(detail, vo, false);
                } else {// 已启用
                    vo.setStartedNum(ComputeUtil.safeAdd(vo.getStartedNum(), detail.getNum()));
                    // 启用单辅数量 = 启用单辅数量 + 启用单辅数量
                    this.collectNum(detail, vo, true);
                }
            }
        }
        for(RmatFlowEntity detail: stopList){// 停用单
            for(int i = 0; i< 2; i++) {// 0-停用，1-启用
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + i + "|" + detail.getRentTransScale();
                if(!map.containsKey(key)){
                    continue;
                }
                MaterialVO vo = map.get(key);
                if (i == 0){// 已停用
                    vo.setStopedNum(ComputeUtil.safeAdd(vo.getStopedNum(), detail.getNum()));
                    // 停用单辅数量 = 停用单辅数量 + 停用单辅数量
                    this.collectNum(detail, vo, true);
                } else {
                    // 已启用 = 已启用 - 已停用
                    vo.setStartedNum(ComputeUtil.safeSub(vo.getStartedNum(), detail.getNum()));
                    // 启用单辅数量 = 启用单辅数量 - 停用单辅数量
                    this.collectNum(detail, vo, false);
                }
            }
        }
        for(RmatFlowEntity detail: restList){
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getUseStatus() + "|" + detail.getRentTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            vo.setRestitutedNum(ComputeUtil.safeAdd(vo.getRestitutedNum(), detail.getNum()));
            // 辅数量 = 辅数量 - 退赔单辅数量
            this.collectNum(detail, vo, false);
        }
        for(RmatFlowEntity detail : loseList){// 遗失单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getUseStatus() + "|" + detail.getRentTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            vo.setLosedNum(ComputeUtil.safeAdd(vo.getLosedNum(), detail.getNum()));
            // 辅数量 = 辅数量 - 遗失单辅数量
            this.collectNum(detail, vo, false);
        }
        for(RmatFlowEntity detail : tempRestList){// 未生效退赔单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getUseStatus() + "|" + detail.getRentTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            vo.setTempRestNum(ComputeUtil.safeAdd(vo.getTempRestNum(), detail.getNum()));
            if("lose".equals(type)){
                // 辅数量 = 辅数量 - 未生效退赔单辅数量
                this.collectNum(detail, vo, false);
            }
        }
        for(RmatFlowEntity detail : tempLoseList){// 未生效遗失单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getUseStatus() + "|" + detail.getRentTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            vo.setTempLoseNum(ComputeUtil.safeAdd(vo.getTempLoseNum(), detail.getNum()));
            if("rest".equals(type)){
                // 辅数量 = 辅数量 - 未生效遗失单辅数量
                this.collectNum(detail, vo, false);
            }
        }
        for(Iterator<MaterialVO> it = map.values().iterator(); it.hasNext();){
            MaterialVO vo = it.next();
            switch(type){
                case "start":// 在场可启用数量 = 已停用 - 已退赔 - 已遗失
                    if("1".equals(vo.getUseStatus())){
                        it.remove();
                        continue;
                    }
                    vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    break;
                case "stop":// 在场可停用数量 = 已启用 - 已退赔 - 已遗失
                    if("0".equals(vo.getUseStatus())){
                        it.remove();
                        continue;
                    }
                    vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    break;
                case "rest":
                    if("0".equals(vo.getUseStatus())){// 可退赔数量 = 已停用 - 已退赔 - 已遗失 - 未生效遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempLoseNum()));
                    }
                    if("1".equals(vo.getUseStatus())){// 可退赔数量 = 已启用 - 已退赔 - 已遗失 - 未生效遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempLoseNum()));
                    }
                    break;
                case "lose":
                    if("0".equals(vo.getUseStatus())){// 可遗失数量 = 已停用 - 已退赔 - 已遗失 - 未生效退赔
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempRestNum()));
                    }
                    if("1".equals(vo.getUseStatus())){// 可遗失数量 = 已启用 - 已退赔 - 已遗失 - 未生效退赔
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempRestNum()));
                    }
                    break;
                case "report":
                    if("0".equals(vo.getUseStatus())){// 在场停用数量 = 已停用 - 已退赔 - 已遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    }
                    if("1".equals(vo.getUseStatus())){// 在场启用数量 = 已停用 - 已退赔 - 已遗失
                        vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum()));
                    }
                    break;
                case "restNoUse":// 退赔在场材料不需要区分启用停用，进行汇总
                    if("0".equals(vo.getUseStatus())){// 可退赔数量 = 已停用 - 已退赔 - 已遗失 - 未生效遗失
                        BigDecimal refNum = ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempLoseNum());
                        key = vo.getContractId() + "|" + vo.getMaterialId() + "|" + 1 + "|" + vo.getRentTransScale();
                        if(map.containsKey(key)){
                            MaterialVO data = map.get(key);
                            data.setRefNum(ComputeUtil.safeAdd(data.getRefNum(), refNum));
                        }
                        it.remove();
                        continue;
                    }
                    if("1".equals(vo.getUseStatus())){// 可退赔数量 = 已启用 - 已退赔 - 已遗失 - 未生效遗失
                        BigDecimal refNum = ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempLoseNum());
                        vo.setRefNum(ComputeUtil.safeAdd(vo.getRefNum(), refNum));
                        vo.setUseStatus(null);
                    }
                    break;
                default:
                    break;
            }
            vo.setNumM(vo.getRefNum());// 可参照主数量记录
            // 在场材料档案的可参照数量使用辅数量，台账的在场数量使用主数量
            if(!"report".equals(type)){
                vo.setRefNum(vo.getRentNum());
            }
            // 过滤数量小于0
            if(vo.getRefNum() == null || vo.getRefNum().compareTo(BigDecimal.ZERO) <= 0){
                it.remove();
                continue;
            }
        }
        return new ArrayList<>(map.values());
    }

    @Override
    public List<MaterialVO> queryRmatList(QueryParam param) {
        param.getFuzzyFields().add("materilCode");
        param.getFuzzyFields().add("materilName");
        param.getFuzzyFields().add("spec");
        List<RmatFlowEntity> flowList = flowService.queryList(param, false);

        List<RmatFlowEntity> checkList = new ArrayList<>();// 验收单
        List<RmatFlowEntity> startList = new ArrayList<>();// 启用单
        List<RmatFlowEntity> stopList = new ArrayList<>();// 停用单
        List<RmatFlowEntity> restList = new ArrayList<>();// 退赔单
        List<RmatFlowEntity> loseList = new ArrayList<>();// 遗失单
        List<RmatFlowEntity> tempLoseList = new ArrayList<>();// 未生效遗失单
        for(RmatFlowEntity flow : flowList){
            if(RmatCommonConsts.YES.equals(flow.getEffectiveState())){
                if(BillTypeEnum.验收单.getCode().equals(flow.getBillTypeCode())){
                    checkList.add(flow);
                }
                if(BillTypeEnum.停用单.getCode().equals(flow.getBillTypeCode())){
                    stopList.add(flow);
                }
                if(BillTypeEnum.启用单.getCode().equals(flow.getBillTypeCode())){
                    startList.add(flow);
                }
                if(BillTypeEnum.退场单.getCode().equals(flow.getBillTypeCode())){
                    restList.add(flow);
                }
                if(BillTypeEnum.赔偿单.getCode().equals(flow.getBillTypeCode())){
                    loseList.add(flow);
                }
            }
            if(RmatCommonConsts.NO.equals(flow.getEffectiveState())){
                if(BillTypeEnum.赔偿单.getCode().equals(flow.getBillTypeCode())){
                    tempLoseList.add(flow);
                }
            }
        }

        Map<String, MaterialVO> map = new HashMap<>();// key-合同主键+物料主键+使用状态+转换系数，value-物料
        String key = null;
        for(RmatFlowEntity detail: checkList){// 验收单
            for(int i = 0; i< 2; i++){// 0-停用，1-启用
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + i + "|" + detail.getRentTransScale();
                MaterialVO vo = new MaterialVO();
                if(!map.containsKey(key)){
                    vo.setId(key);
                    // 转换材料明细信息
                    this.transferVO(detail, vo);
                    vo.setUseStatus(String.valueOf(i));
                } else {
                    vo = map.get(key);
                }
                // 已进场
                vo.setCheckedNum(ComputeUtil.safeAdd(vo.getCheckedNum(), detail.getNum()));
                // 已启用 = 已进场
                vo.setStartedNum(ComputeUtil.safeAdd(vo.getStartedNum(), detail.getNum()));
                // 辅数量(停用状态物料初始辅数量应为0)
                if(i == 1){
                    this.collectNum(detail, vo, true);
                }
                map.put(key, vo);
            }
        }
        for(RmatFlowEntity detail: startList){// 启用单
            for(int i = 0; i< 2; i++) {// 0-停用，1-启用
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + i + "|" + detail.getRentTransScale();
                if(!map.containsKey(key)){
                    continue;
                }
                MaterialVO vo = map.get(key);
                if (i == 0){// 已停用 = 已停用 - 已启用
                    vo.setStopedNum(ComputeUtil.safeSub(vo.getStopedNum(), detail.getNum()));
                    // 停用单辅数量 = 停用单辅数量 - 启用单辅数量
                    this.collectNum(detail, vo, false);
                } else {// 已启用
                    vo.setStartedNum(ComputeUtil.safeAdd(vo.getStartedNum(), detail.getNum()));
                    // 启用单辅数量 = 启用单辅数量 + 启用单辅数量
                    this.collectNum(detail, vo, true);
                }
            }
        }
        for(RmatFlowEntity detail: stopList){// 停用单
            for(int i = 0; i< 2; i++) {// 0-停用，1-启用
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + i + "|" + detail.getRentTransScale();
                if(!map.containsKey(key)){
                    continue;
                }
                MaterialVO vo = map.get(key);
                if (i == 0){// 已停用
                    vo.setStopedNum(ComputeUtil.safeAdd(vo.getStopedNum(), detail.getNum()));
                    // 停用单辅数量 = 停用单辅数量 + 停用单辅数量
                    this.collectNum(detail, vo, true);
                } else {
                    // 已启用 = 已启用 - 已停用
                    vo.setStartedNum(ComputeUtil.safeSub(vo.getStartedNum(), detail.getNum()));
                    // 启用单辅数量 = 启用单辅数量 - 停用单辅数量
                    this.collectNum(detail, vo, false);
                }
            }
        }
        for(RmatFlowEntity detail: restList){
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getUseStatus() + "|" + detail.getRentTransScale();
            MaterialVO vo = new MaterialVO();
            if(!map.containsKey(key)){
                vo.setId(key);
                // 转换材料明细信息
                this.transferVO(detail, vo);
                vo.setUseStatus(detail.getUseStatus());
                vo.setSignRowType(RmatCommonConsts.ONE);// 退场新增默认合同签订方式为分类
                vo.setExitAdd(true);// 退场新增
            } else {
                vo = map.get(key);
            }
            vo.setRestitutedNum(ComputeUtil.safeAdd(vo.getRestitutedNum(), detail.getNum()));
            // 辅数量 = 辅数量 - 退赔单辅数量
            this.collectNum(detail, vo, false);
            map.put(key, vo);
        }
        for(RmatFlowEntity detail : loseList){// 遗失单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getUseStatus() + "|" + detail.getRentTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            vo.setLosedNum(ComputeUtil.safeAdd(vo.getLosedNum(), detail.getNum()));
            // 辅数量 = 辅数量 - 遗失单辅数量
            this.collectNum(detail, vo, false);
        }
        for(RmatFlowEntity detail : tempLoseList){// 未生效遗失单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getUseStatus() + "|" + detail.getRentTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            vo.setTempLoseNum(ComputeUtil.safeAdd(vo.getTempLoseNum(), detail.getNum()));
            // 辅数量 = 辅数量 - 未生效遗失单辅数量
            this.collectNum(detail, vo, false);
        }
        for(Iterator<MaterialVO> it = map.values().iterator(); it.hasNext();){
            MaterialVO vo = it.next();
            if("0".equals(vo.getUseStatus())){// 可退赔数量 = 已停用 - 已退赔 - 已遗失 - 未生效遗失
                vo.setRefNum(ComputeUtil.safeSub(vo.getStopedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempLoseNum()));
            }
            if("1".equals(vo.getUseStatus())){// 可退赔数量 = 已启用 - 已退赔 - 已遗失 - 未生效遗失
                vo.setRefNum(ComputeUtil.safeSub(vo.getStartedNum(), vo.getRestitutedNum(), vo.getLosedNum(), vo.getTempLoseNum()));
            }
            vo.setNumM(vo.getRefNum());// 可参照主数量记录
            // 在场材料档案的可参照数量使用辅数量，台账的在场数量使用主数量
            vo.setRefNum(vo.getRentNum());
            // 过滤数量小于0
            if(!vo.getExitAdd() && (vo.getRefNum() == null || vo.getRefNum().compareTo(BigDecimal.ZERO) <= 0)){
                it.remove();
                continue;
            }
        }
        // 汇总
        List<MaterialVO> refList = new ArrayList<>(map.values());
        refList = this.getResultList(refList);
        return refList;
    }

    /**
     * 合同签订维度为分类，且管理方式为分类时，则根据计租单位分类汇总
     * @param refList
     * @return
     */
    private List<MaterialVO> getResultList(List<MaterialVO> refList) {
        List<ManageSetVO> vos = new ArrayList<>();
        for(MaterialVO ref : refList){
            ManageSetVO vo = new ManageSetVO();
            vo.setOrgId(ref.getOrgId());
            vo.setMaterialTypeId(ref.getMaterialTypeId());
            vos.add(vo);
        }
        if(CollectionUtils.isNotEmpty(vos)){
            vos = manageSetService.queryManageSet(vos);
        }
        Set<Long> materialTypeIds = vos.stream().map(ManageSetVO::getMaterialTypeId).collect(Collectors.toSet());
        Map<String, MaterialVO> result = new HashMap<>();
        for(MaterialVO vo : refList){
            String paentId = vo.getContractId() + "|" + vo.getMaterialTypeId() + "|" + vo.getRentUnitId();// key-合同主键+物料分类主键+计租单位主键，value-物料
            // 合同签订维度为分类，且管理方式为分类，则按照分类汇总。如果合同签订的为明细，管理方式为大类，则按照明细管理
            if(RmatCommonConsts.ONE.equals(vo.getSignRowType()) && materialTypeIds.contains(vo.getMaterialTypeId())){
                MaterialVO parent = new MaterialVO();
                List<MaterialVO> children = new ArrayList<>();
                List<MaterialFlowVO> flowList = new ArrayList<>();
                if(result.containsKey(paentId)){
                    parent = result.get(paentId);
                    children = parent.getChildren();
                    flowList = parent.getFlowList();
                } else {
                    parent.setId(paentId);
                    parent.setMaterialTypeId(vo.getMaterialTypeId());
                    parent.setMaterialTypeName(vo.getMaterialTypeName());
                    parent.setRentUnitId(vo.getRentUnitId());
                    parent.setRentUnitName(vo.getRentUnitName());
                    parent.setRentTransScale(vo.getRentTransScale());
                }
                parent.setRefNum(ComputeUtil.safeAdd(parent.getRefNum(), vo.getRefNum()));// 可参照数量
                // 可能没啥用
                parent.setNumM(ComputeUtil.safeAdd(parent.getNumM(), vo.getNumM()));// 主数量
                parent.setNum(ComputeUtil.safeAdd(parent.getNum(), vo.getNum()));// 档案数量
                parent.setRealNum(ComputeUtil.safeAdd(parent.getRealNum(), vo.getRealNum()));// 实物数量
                parent.setRentNum(ComputeUtil.safeAdd(parent.getRentNum(), vo.getRentNum()));// 计租数量
                vo.setParentId(paentId);
                children.add(vo);
                parent.setChildren(children);
                flowList.addAll(vo.getFlowList());
                parent.setFlowList(flowList);
                result.put(paentId, parent);
            } else {
                result.put(vo.getId(), vo);
            }
        }
        return new ArrayList<>(result.values());
    }

    /**
     * 计算数量
     * @param detail
     * @param vo
     * @param add   是否相加
     */
    private void collectNum(RmatFlowEntity detail, MaterialVO vo, Boolean add) {
        if(add){
            vo.setNum(ComputeUtil.safeAdd(vo.getNum(), detail.getNum()));
            vo.setRealNum(ComputeUtil.safeAdd(vo.getRealNum(), detail.getRealNum()));
            vo.setRentNum(ComputeUtil.safeAdd(vo.getRentNum(), detail.getRentNum()));
        } else {
            vo.setNum(ComputeUtil.safeSub(vo.getNum(), detail.getNum()));
            vo.setRealNum(ComputeUtil.safeSub(vo.getRealNum(), detail.getRealNum()));
            vo.setRentNum(ComputeUtil.safeSub(vo.getRentNum(), detail.getRentNum()));
        }
    }

    @Override
    public List<MaterialVO> queryCalculateList(String contractId, Date startDate, Date endDate) {
        ExecutorService threadPool = Executors.newFixedThreadPool(7);
        QueryParam param = new QueryParam();// 深拷贝
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        param.getOrderMap().put("createTime", QueryParam.ASC);
        Parameter parameter = new Parameter(QueryParam.LE, DateUtil.formatSeconds(endDate));
        param.getParams().put("billDate", parameter);
        List<RmatFlowEntity> rmatFlowList = flowService.queryList(param, false);

        List<RmatFlowEntity> checkList = new ArrayList<>();// 验收单
        List<RmatFlowEntity> startList = new ArrayList<>();// 启用单
        List<RmatFlowEntity> stopList = new ArrayList<>();// 停用单
        List<RmatFlowEntity> restList = new ArrayList<>();// 退赔单
        List<RmatFlowEntity> loseList = new ArrayList<>();// 遗失单
        for(RmatFlowEntity flow : rmatFlowList){
            if(RmatCommonConsts.YES.equals(flow.getEffectiveState())){
                if(BillTypeEnum.验收单.getCode().equals(flow.getBillTypeCode())){
                    checkList.add(flow);
                }
                if(BillTypeEnum.停用单.getCode().equals(flow.getBillTypeCode())){
                    stopList.add(flow);
                }
                if(BillTypeEnum.启用单.getCode().equals(flow.getBillTypeCode())){
                    startList.add(flow);
                }
                if(BillTypeEnum.退场单.getCode().equals(flow.getBillTypeCode())){
                    restList.add(flow);
                }
                if(BillTypeEnum.赔偿单.getCode().equals(flow.getBillTypeCode())){
                    loseList.add(flow);
                }
            }
        }

        Map<String, MaterialVO> map = new HashMap<>();// key-合同主键+物料主键+计组方式+转换系数，value-物料
        String key = null;// 0-停用，1-启用
        Map<Date, List<Date>> dateMap = new HashMap<>();
        Map<Date, List<Date>> cdateMap = new HashMap<>();
        for(RmatFlowEntity detail : checkList){// 验收单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentTransScale();
            MaterialVO vo = new MaterialVO();
            if(!map.containsKey(key)){
                vo.setId(key);
                // 转换材料明细信息
                this.transferVO(detail, vo);
            } else {
                vo = map.get(key);
            }
            vo.setUseStatus(MaterialConstant.YES);
            // 过滤统计开始日期大于操作日期不生成流水作为期初
            Date date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if(startDate != null && DateUtil.compareDate(startDate, date) > 0){
                // 已进场
                vo.setCheckedNum(ComputeUtil.safeAdd(vo.getCheckedNum(), detail.getRentNum()));
                // 已启用 = 已进场
                vo.setStartedNum(ComputeUtil.safeAdd(vo.getStartedNum(), detail.getRentNum()));
            } else {
                // 生成流水
                this.addFlowVO(vo, MaterialStateEnum.启用, date, detail.getId(), detail.getRentNum());
            }
            map.put(key, vo);
        }
        for(RmatFlowEntity detail : startList){// 启用单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentTransScale();
            MaterialVO vo = new MaterialVO();
            if(!map.containsKey(key)){
                vo.setId(key);
                // 转换材料明细信息
                this.transferVO(detail, vo);
            } else {
                vo = map.get(key);
            }
            vo.setUseStatus(MaterialConstant.YES);
            // 过滤统计开始日期大于操作日期不生成流水作为期初
            Date date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if(startDate != null && DateUtil.compareDate(startDate, date) > 0){
                // 已停用
                vo.setStopedNum(ComputeUtil.safeSub(vo.getStopedNum(), detail.getRentNum()));
                // 已启用
                vo.setStartedNum(ComputeUtil.safeAdd(vo.getStartedNum(), detail.getRentNum()));
            } else {
                // 生成流水
                this.addFlowVO(vo, MaterialStateEnum.启用, date, detail.getId(), detail.getRentNum());
            }
            map.put(key, vo);
        }
        for(RmatFlowEntity detail : stopList){// 停用单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentTransScale();
            MaterialVO vo = new MaterialVO();
            if(!map.containsKey(key)){
                vo.setId(key);
                // 转换材料明细信息
                this.transferVO(detail, vo);
            } else {
                vo = map.get(key);
            }
            vo.setUseStatus(MaterialConstant.NO);
            // 过滤统计开始日期大于操作日期不生成流水作为期初
            Date date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if(startDate != null && DateUtil.compareDate(startDate, date) > 0){
                // 已停用
                vo.setStopedNum(ComputeUtil.safeAdd(vo.getStopedNum(), detail.getRentNum()));
                // 已启用
                vo.setStartedNum(ComputeUtil.safeSub(vo.getStartedNum(), detail.getRentNum()));
            } else {
                // 生成流水
                this.addFlowVO(vo, MaterialStateEnum.停用, date, detail.getId(), detail.getRentNum());
            }
            map.put(key, vo);
        }
        for(RmatFlowEntity detail : restList){// 退赔单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentTransScale();
            MaterialVO vo = new MaterialVO();
            if(!map.containsKey(key)){
                vo.setId(key);
                // 转换材料明细信息
                this.transferVO(detail, vo);
                vo.setUseStatus(detail.getUseStatus());
                vo.setSignRowType(RmatCommonConsts.ONE);// 退场新增默认合同签订方式为分类
                vo.setExitAdd(true);// 退场新增
            } else {
                vo = map.get(key);
            }
            vo.setUseStatus(detail.getUseStatus());
//            BigDecimal restNum = ComputeUtil.safeAdd(detail.getFullNum(), detail.getMaintainNum(), detail.getScrapNum());
            // 过滤统计开始日期大于操作日期不生成流水作为期初
            Date date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if(startDate != null && DateUtil.compareDate(startDate, date) > 0){
                vo.setRestitutedNum(ComputeUtil.safeAdd(vo.getRestitutedNum(), detail.getRentNum()));
                if(MaterialConstant.NO.equals(vo.getUseStatus())) {// 已停用
                    vo.setStopedNum(ComputeUtil.safeSub(vo.getStopedNum(), detail.getRentNum()));
                }
                if(MaterialConstant.YES.equals(vo.getUseStatus())) {// 已启用
                    vo.setStartedNum(ComputeUtil.safeSub(vo.getStartedNum(), detail.getRentNum()));
                }
            } else {
                // 生成流水
                this.addFlowVO(vo, MaterialStateEnum.退场, date, detail.getId(), detail.getRentNum());
            }
            map.put(key, vo);
        }
        for(RmatFlowEntity detail : loseList){// 遗失单
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentTransScale();
            if(!map.containsKey(key)){
                continue;
            }
            MaterialVO vo = map.get(key);
            vo.setUseStatus(detail.getUseStatus());
            // 过滤统计开始日期大于操作日期不生成流水作为期初
            Date date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if(startDate != null && DateUtil.compareDate(startDate, date) > 0){
                vo.setLosedNum(ComputeUtil.safeAdd(vo.getLosedNum(), detail.getRentNum()));
                if(MaterialConstant.NO.equals(vo.getUseStatus())) {// 已停用
                    vo.setStopedNum(ComputeUtil.safeSub(vo.getStopedNum(), detail.getRentNum()));
                }
                if(MaterialConstant.YES.equals(vo.getUseStatus())) {// 已启用
                    vo.setStartedNum(ComputeUtil.safeSub(vo.getStartedNum(), detail.getRentNum()));
                }
            } else {
                // 生成流水
                this.addFlowVO(vo, MaterialStateEnum.退场, date, detail.getId(), detail.getRentNum());
            }
        }
        for(String keys : map.keySet()){
            MaterialVO vo = map.get(keys);
            if(MaterialConstant.NO.equals(vo.getUseStatus())){// 在场停用数量
                vo.setRefNum(vo.getStopedNum());
            }
            if(MaterialConstant.YES.equals(vo.getUseStatus())){// 在场启用数量
                vo.setRefNum(vo.getStartedNum());
            }
            if(ComputeUtil.isGreaterThan(vo.getStopedNum(), BigDecimal.ZERO)){// 停用存在期初数量
                // 生成期初
                vo.setUseStatus(MaterialConstant.NO);
                this.addBeginVO(vo, MaterialStateEnum.停用, startDate, IdWorker.getId(), vo.getStopedNum());
            }
            if(ComputeUtil.isGreaterThan(vo.getStartedNum(), BigDecimal.ZERO)){// 启用存在期初数量
                // 生成期初
                vo.setUseStatus(MaterialConstant.YES);
                this.addBeginVO(vo, MaterialStateEnum.启用, startDate, IdWorker.getId(), vo.getStartedNum());
            }
            List<MaterialFlowVO> flowList = vo.getFlowList();
            if(CollectionUtils.isNotEmpty(flowList)){
                flowList.sort(Comparator.comparing(MaterialFlowVO::getOperationDate));
            }
            vo.setFlowList(flowList);
        }
        // 汇总
        List<MaterialVO> refList = new ArrayList<>(map.values());
        refList = this.getResultList(refList);
        return refList;
    }

    /**
     * 获取最大操作时间
     * @param dateMap
     * @param cdateMap
     * @param billDate
     * @param createTime
     * @return
     */
    private Date getMaxDate(Map<Date, List<Date>> dateMap, Map<Date, List<Date>> cdateMap, Date billDate, Date createTime) {
        Date date = DateUtil.concatDate(billDate, createTime);
        List<Date> list = new ArrayList<>();
        List<Date> clist = new ArrayList<>();
        Date day = DateUtil.parseDate(DateUtil.formatSeconds(date).substring(0,10));
        if(dateMap.containsKey(day)){
            list = dateMap.get(day);
            Date maxDate = list.stream().max(Comparator.comparing(x->x)).orElse(null);
            clist = cdateMap.get(day);
            Date cmaxDate = clist.stream().max(Comparator.comparing(x->x)).orElse(null);
            if(DateUtil.compareDate(date, maxDate) < 0 && DateUtil.compareDate(createTime, cmaxDate) > 0){
                date = DateUtil.addSeconds(maxDate, 1);
                if(DateUtil.compareDate(date, DateUtil.endOfDate(date)) > 0){
                    date = DateUtil.endOfDate(date);
                }
            }
        }
        list.add(date);
        dateMap.put(day, list);
        clist.add(createTime);
        cdateMap.put(day, clist);
        return date;
    }

    /**
     * 生成流水
     * @param vo
     * @param stateEnum
     * @param date
     * @param id
     * @param num
     */
    private void addFlowVO(MaterialVO vo, MaterialStateEnum stateEnum, Date date, Long id, BigDecimal num) {
        MaterialFlowVO flowVO = new MaterialFlowVO();
        flowVO.setParameterId(vo.getId());
        flowVO.setMaterialState(stateEnum.getCode());
        flowVO.setOperationDate(date);
        flowVO.setSourceId(id);
        flowVO.setSourceType(stateEnum.getDescription());
        flowVO.setNum(num);
        flowVO.setUseStatus(vo.getUseStatus());
        flowVO.setStopedNum(vo.getStopedNum());
        flowVO.setStartedNum(vo.getStartedNum());
        flowVO.setId(id);
        List<MaterialFlowVO> flowList = vo.getFlowList() != null ? vo.getFlowList() : new ArrayList<>();
        flowList.add(flowVO);
        vo.setFlowList(flowList);
    }

    /**
     * 生成期初
     * @param vo
     * @param stateEnum
     * @param date
     * @param id
     * @param num
     */
    private void addBeginVO(MaterialVO vo, MaterialStateEnum stateEnum, Date date, Long id, BigDecimal num) {
        MaterialFlowVO flowVO = new MaterialFlowVO();
        flowVO.setParameterId(vo.getId());
        flowVO.setMaterialState(stateEnum.getCode());
        flowVO.setOperationDate(date);
        flowVO.setSourceId(id);
        flowVO.setSourceType(stateEnum.getDescription());
        flowVO.setNum(num);
        flowVO.setUseStatus(vo.getUseStatus());
        flowVO.setId(id);
        flowVO.setStopedNum(vo.getStopedNum());
        flowVO.setStartedNum(vo.getStartedNum());
        List<MaterialFlowVO> beginList = vo.getBeginList() != null ? vo.getBeginList() : new ArrayList<>();
        beginList.add(flowVO);
        vo.setBeginList(beginList);
    }

    /**
     * 转换材料明细信息
     * @param detail
     * @param vo
     */
    private void transferVO(RmatFlowEntity detail, MaterialVO vo) {
        vo.setContractId(detail.getContractId());
        vo.setContractCode(detail.getContractCode());
        vo.setContractName(detail.getContractName());
        vo.setOrgId(detail.getOrgId());
        vo.setOrgName(detail.getOrgName());
        vo.setSupplierId(detail.getSupplierId());
        vo.setSupplierName(detail.getSupplierName());
        vo.setInfoId(detail.getInfoId());

        vo.setMaterialTypeId(detail.getMaterialTypeId());
        vo.setMaterialTypeName(detail.getMaterialTypeName());
        vo.setMaterialId(detail.getMaterialId());
        vo.setMaterialCode(detail.getMaterialCode());
        vo.setMaterialName(detail.getMaterialName());
        vo.setMaterialSourceId(detail.getMaterialSourceId());
        vo.setSpec(detail.getSpec());
        vo.setUnitId(detail.getUnitId());
        vo.setUnitName(detail.getUnitName());
        vo.setRealUnitId(detail.getRealUnitId());
        vo.setRealUnitName(detail.getRealUnitName());
        vo.setRealTransScale(detail.getRealTransScale());
        vo.setRentUnitId(detail.getRentUnitId());
        vo.setRentUnitName(detail.getRentUnitName());
        vo.setRentTransScale(detail.getRentTransScale());
        vo.setSignRowType(detail.getSignRowType());
        vo.setExitAdd(false);
    }

    @Override
    public String validateContract(String contractId, String billType, Long billId, String type) {
        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        param.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        if(MaterialConstant.租金计算单.equals(billType) && billId != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }
        List<RmatFlowEntity> rentList = new ArrayList<>();// 租金计算单
//        List<RentCalculateEntity> rentList = rentService.queryList(param, false);// 租金计算单

        QueryParam param2 = new QueryParam();
        param2.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        param2.getParams().put("effectiveState", new Parameter(QueryParam.EQ, RmatCommonConsts.NO));
        if(!MaterialConstant.租金计算单.equals(billType) && billId != null){
            param.getParams().put("sourceId", new Parameter(QueryParam.NE, billId));
        }
        List<RmatFlowEntity> flowList = flowService.queryList(param2, false);

        List<RmatFlowEntity> checkList = new ArrayList<>();// 验收单
        List<RmatFlowEntity> startList = new ArrayList<>();// 启用单
        List<RmatFlowEntity> stopList = new ArrayList<>();// 停用单
        List<RmatFlowEntity> restList = new ArrayList<>();// 退赔单
        List<RmatFlowEntity> loseList = new ArrayList<>();// 遗失单
        for(RmatFlowEntity flow : flowList){
            if(RmatCommonConsts.YES.equals(flow.getEffectiveState())){
                if(BillTypeEnum.验收单.getCode().equals(flow.getBillTypeCode())){
                    checkList.add(flow);
                }
                if(BillTypeEnum.停用单.getCode().equals(flow.getBillTypeCode())){
                    stopList.add(flow);
                }
                if(BillTypeEnum.启用单.getCode().equals(flow.getBillTypeCode())){
                    startList.add(flow);
                }
                if(BillTypeEnum.退场单.getCode().equals(flow.getBillTypeCode())){
                    restList.add(flow);
                }
                if(BillTypeEnum.赔偿单.getCode().equals(flow.getBillTypeCode())){
                    loseList.add(flow);
                }
            }
        }

        if(CollectionUtils.isNotEmpty(checkList)){
            throw new BusinessException("当前合同存在非审批通过态的验收单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(startList)){
            throw new BusinessException("当前合同存在非审批通过态的再启租单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(stopList)){
            throw new BusinessException("当前合同存在非审批通过态的停用单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(restList)){
            throw new BusinessException("当前合同存在非审批通过态的退场单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(loseList)){
            throw new BusinessException("当前合同存在非审批通过态的赔偿单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(rentList)){
            throw new BusinessException("当前合同存在非审批通过态的租金计算单，不允许" + type + "!");
        }
        return "校验通过！";
    }

    @Override
    public Date getLastDate(Map<String, Object> params) {
        return baseMapper.getLastDate(params);
    }

    @Override
    public Map<Date, Date> getMaxTime(Map<String, Object> params) {
        List<MaxTimeVO> list = baseMapper.getMaxTime(params);
        list.removeAll(Collections.singleton(null));
        if(CollectionUtils.isEmpty(list)){
            return new HashMap<>();
        }
        return list.stream().filter(x->x.getTime() != null).collect(Collectors.toMap(MaxTimeVO::getDate, MaxTimeVO::getTime));
    }

    @Override
    public List<MaterialVO> proMaterialList(QueryParam param) {
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        String type = "report";// start-在场可启用，stop-在场可停用，rest-在场可退赔，lose-在场可遗失，report-验收台账

        // 使用状态(启用、停用)
        Parameter useStatusParameter = param.getParams().get("useStatus");
        List<String> useStatusList = new ArrayList<>();
        if(useStatusParameter != null && useStatusParameter.getValue() != null){
            String useStatus = (String)useStatusParameter.getValue();
            String[] split = useStatus.split(",");
            useStatusList = Arrays.asList(split);
            param.getParams().remove("useStatus");
        }
        List<MaterialVO> list = this.queryCheckList(param, type);

        List<MaterialVO> resList = new ArrayList<>();
        for(MaterialVO vo : list){
            boolean flag = false;
            if(useStatusList.size()>0 && !useStatusList.contains(vo.getUseStatus())){
                flag = true;
            }
            if(!flag){
                resList.add(vo);
            }
        }
        resList.forEach(vo -> {
            if (null != vo.getUseStatus()) {
                if ("0".equals(vo.getUseStatus())) {
                    vo.setUseStatusName("停用");
                } else if ("1".equals(vo.getUseStatus())) {
                    vo.setUseStatusName("启用");
                }
            } else {
                vo.setUseStatusName("");
            }
        });
        return resList;
    }
}
