package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.bean.RestituteEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.MaterialConstant;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IRestituteService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.vo.RestituteVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.Date;

@Service("restitute") 
public class RestituteBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IRestituteService service;

	@Autowired
	private IMaterialService materialService;

	@Autowired
	private IRmatFlowService flowService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		/*RestituteEntity entity = service.selectById(billId);
		entity.setSubmitTime(new Date());
		service.saveOrUpdate(entity,false);*/
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		RestituteEntity entity = service.selectById(billId);
		//单据协同推送
		boolean pushResult = service.pushBillToSupCenter(entity);
		if(pushResult) {
			entity.setPushFlag(1);
		} else {
			logger.error("单据-{}id-{}推送供应商服务失败", BillTypeEnum.赔偿单.getName(), billId);
			entity.setPushFlag(0);
		}
		//entity.setSubmitTime(new Date());
		// 推送流水生效
		if(!flowService.insertRestFlow(entity, billTypeCode, RmatCommonConsts.YES)){
			return CommonResponse.error("审批回调失败，单据推送流水失败！");
		}
		service.saveOrUpdate(entity, false);
		return CommonResponse.success("审批回调成功！");
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		RestituteEntity entity = service.selectById(billId);
		//检测单据是否供应商已签字，
		if(SupplierSignStatusEnum.乙方已签字.getCode().equals(entity.getSupplierSignStatus())) {
			return CommonResponse.error("供应商已签字，无法执行此操作！");
		}
		// 同一个合同只能存在一个自由态或审批中的单据
		materialService.validateContract(entity.getContractId(), null, null, MaterialConstant.弃审);
		// 校验必须大于最大单据日期
		service.validateTime(BeanMapper.map(entity, RestituteVO.class), MaterialConstant.弃审);
		// 是否被其他单据引用
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {//单据未被下游单据引用
			return CommonResponse.error(res.getMsg());
		}
		//将推送至供方的单据作废
		if (entity.getPushFlag() == 1) {
			boolean pushResult = service.delPushBill(entity);
			if (!pushResult) {
				return CommonResponse.error("弃审前回调失败，单据作废协同服务失败！");
			} else {
				entity.setPushFlag(0);
			}
		}
		service.saveOrUpdate(entity, false);
		// 推送流水未生效
		if(!flowService.insertRestFlow(entity, billTypeCode, RmatCommonConsts.NO)){
			return CommonResponse.error("弃审前回调失败，单据推送流水失败！");
		}
		return CommonResponse.success("弃审前回调成功！");
	}

	/**
	 * 弃审后事件回调
	 *
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
