package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.rmat.bean.*;
import com.ejianc.business.rmat.consts.FlowTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.mapper.RmatFlowMapper;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.vo.RmatFlowVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 租赁流水表
 * 
 * @author generator
 * 
 */
@Service("rmatFlowService")
public class RmatFlowServiceImpl extends BaseServiceImpl<RmatFlowMapper, RmatFlowEntity> implements IRmatFlowService {

    @Override
    public Boolean insertFlow(List<RmatFlowVO> vos) {
        List<RmatFlowVO> addList = new ArrayList<>();
        List<Long> delIds = new ArrayList<>();
        for(RmatFlowVO vo : vos){
            vo.setId(vo.getSourceDetailId());// 默认主键为子表主键
            if(!"del".equals(vo.getRowState())){
                addList.add(vo);
            } else {
                delIds.add(vo.getId());
            }
        }
        if(CollectionUtils.isNotEmpty(addList)){
            List<RmatFlowEntity> list = BeanMapper.mapList(addList, RmatFlowEntity.class);
            super.saveOrUpdateBatch(list);
        }
        if(CollectionUtils.isNotEmpty(delIds)){
            super.removeByIds(delIds);
        }
        return true;
    }

    @Override
    public Boolean insertStopFlow(StopEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<StopDetailEntity> detailList = entity.getDetailList();
        for(StopDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStopTime());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.停用.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);// 进场
            vo.setUseStatus(String.valueOf(RmatCommonConsts.NO));// 停用
            vo.setDetailDate(detail.getStopTime());// 明细业务日期
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitId());// 档案单位
            vo.setUnitName(detail.getUnitName());
            vo.setNum(detail.getNum());// 档案数量
            vo.setRealUnitId(detail.getRealUnitId());// 实物单位
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealNum());// 实物数量
            vo.setRealTransScale(detail.getRealTransScale());// 实物转换系数
            vo.setRentUnitId(detail.getRentUnitId());// 计租单位
            vo.setRentUnitName(detail.getRentUnitName());
            vo.setRentNum(detail.getRentNum());// 计租数量
            vo.setRentTransScale(detail.getRentTransScale());// 计租转换系数
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    @Override
    public Boolean insertStartFlow(StartEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<StartDetailEntity> detailList = entity.getStartDetailList();
        for(StartDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getStartTime());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.启用.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);// 进场
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));// 启用
            vo.setDetailDate(detail.getStartTime());// 明细业务日期
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitId());// 档案单位
            vo.setUnitName(detail.getUnitName());
            vo.setNum(detail.getNum());// 档案数量
            vo.setRealUnitId(detail.getRealUnitId());// 实物单位
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealNum());// 实物数量
            vo.setRealTransScale(detail.getRealTransScale());// 实物转换系数
            vo.setRentUnitId(detail.getRentUnitId());// 计租单位
            vo.setRentUnitName(detail.getRentUnitName());
            vo.setRentNum(detail.getRentNum());// 计租数量
            vo.setRentTransScale(detail.getRentTransScale());// 计租转换系数
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    @Override
    public Boolean insertExitFlow(ExitEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<ExitDetailEntity> detailList = entity.getExitDetail();
        for(ExitDetailEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getExitDate());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.遗失.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.OUT);// 进场
//            vo.setUseStatus(detail.getUseStatus());// 停用/启用
            vo.setDetailDate(detail.getStopDate());// 明细业务日期
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitId());// 档案单位
            vo.setUnitName(detail.getUnitName());
            vo.setNum(detail.getNum());// 档案数量
            vo.setRealUnitId(detail.getRealUnitId());// 实物单位
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealNum());// 实物数量
            vo.setRealTransScale(detail.getRealTransScale());// 实物转换系数
            vo.setRentUnitId(detail.getRentUnitId());// 计租单位
            vo.setRentUnitName(detail.getRentUnitName());
            vo.setRentNum(detail.getRentNum());// 计租数量
            vo.setRentTransScale(detail.getRentTransScale());// 计租转换系数
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    @Override
    public Boolean insertRestFlow(RestituteEntity entity, String billTypeCode, Integer effectiveState) {
        List<RmatFlowVO> flowList = new ArrayList<>();
        List<RestituteScrapEntity> detailList = entity.getRestituteDetailList();
        for(RestituteScrapEntity detail : detailList){
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);// 单据类型编码
            vo.setSourceId(entity.getId());// 来源单据主键
            vo.setSourceDetailId(detail.getId());// 来源单据明细主键
            vo.setBillCode(entity.getBillCode());// 单据编号
            vo.setOrgId(entity.getOrgId());// 所属组织
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());// 合同
            vo.setContractCode(entity.getContractCode());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());// 供应商
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(entity.getEmployeeId());// 经办人
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getRestituteDate());// 业务日期
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);// 生效日期默认当前日期
            vo.setEffectiveState(effectiveState);// 审批通过后生效
            /** diff */
            vo.setFlowType(String.valueOf(FlowTypeEnum.退赔.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.OUT);// 进场
            vo.setUseStatus(detail.getUseStatus());// 停用/启用
            vo.setDetailDate(detail.getStopDate());// 明细业务日期
            /** diff */
            vo.setMaterialTypeId(detail.getMaterialTypeId());// 物料分类
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());// 物料
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());// 规格型号
            vo.setUnitId(detail.getUnitId());// 档案单位
            vo.setUnitName(detail.getUnitName());
            vo.setNum(detail.getNum());// 档案数量
            vo.setRealUnitId(detail.getRealUnitId());// 实物单位
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealNum());// 实物数量
            vo.setRealTransScale(detail.getRealTransScale());// 实物转换系数
            vo.setRentUnitId(detail.getRentUnitId());// 计租单位
            vo.setRentUnitName(detail.getRentUnitName());
            vo.setRentNum(detail.getRentNum());// 计租数量
            vo.setRentTransScale(detail.getRentTransScale());// 计租转换系数
 //            vo.setAssistNum(ComputeUtil.safeAdd(detail.getFullNum(), detail.getMaintainNum(), detail.getScrapNum()));// 辅数量
            vo.setRowState(detail.getRowState());// 新增/编辑/删除
            flowList.add(vo);
        }
        return insertFlow(flowList);
    }

    @Override
    public Boolean delFlow(List<Long> sourceIds, String billTypeCode) {
        if(CollectionUtils.isEmpty(sourceIds)){
            return true;
        }
        QueryWrapper ew = new QueryWrapper();
        ew.in("source_id", sourceIds);
        ew.eq("bill_type_code", billTypeCode);
        return super.remove(ew);
    }


}
