package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.bean.StartEntity;
import com.ejianc.business.rmat.bean.StopEntity;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.service.IStartService;
import com.ejianc.business.rmat.service.IStopService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;

@Service("start")
public class StartBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IRmatFlowService rmatFlowService;
	@Autowired
	private IStartService service;
	@Autowired
	private IPriceFlowService priceFlowService;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		StartEntity entity = service.selectById(billId);
		// 推送租赁流水未生效
		if(!rmatFlowService.insertStartFlow(entity, billTypeCode, RmatCommonConsts.NO)){
			return CommonResponse.error("撤回失败，单据推送流水失败！");
		}
		// 删除单价流水
		List<Long> ids = new ArrayList<>();
		ids.add(billId);
		if (!priceFlowService.delFlow(ids, billTypeCode)) {
			return CommonResponse.error("撤回失败，单据推送流水失败！");
		}
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		StartEntity entity = service.selectById(billId);
		// 推送租赁流水生效
		if(!rmatFlowService.insertStartFlow(entity, billTypeCode, RmatCommonConsts.YES)){
			return CommonResponse.error("审批回调失败，单据推送流水失败！");
		}
		// 推送单价流水生效
		if (!priceFlowService.insertStartFlow(entity, billTypeCode)) {
			return CommonResponse.error("审批回调失败，单据推送流水失败！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
