/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.rmat.bean.RestituteEntity;
import com.ejianc.business.rmat.bean.RestituteMaintainEntity;
import com.ejianc.business.rmat.bean.RestituteOtherEntity;
import com.ejianc.business.rmat.bean.RestituteScrapEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IRestituteService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.vo.MaterialVO;
import com.ejianc.business.rmat.vo.RestituteScrapVO;
import com.ejianc.business.rmat.vo.RestituteVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"restitute"})
public class RestituteController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectApi iProjectApi;
    private static final String BILL_CODE = "TPD_RESTITUTE";
    @Autowired
    private IRestituteService service;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IRmatFlowService flowService;
    @Autowired
    private ICmContractInfoApi cmContractInfoApi;
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/assistrmat/restitute/card";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RestituteVO> saveOrUpdate(@RequestBody RestituteVO saveOrUpdateVO) {
        this.materialService.validateContract(saveOrUpdateVO.getContractId(), "\u9000\u8d54\u5355", saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        this.service.validateTime(saveOrUpdateVO, "\u4fdd\u5b58");
        RestituteEntity entity = (RestituteEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RestituteEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List detailList = saveOrUpdateVO.getRestituteDetailList();
        String materialTypeNames = detailList.stream().filter(x -> !"del".equals(x.getRowState()) && StringUtils.isNotEmpty((CharSequence)x.getMaterialTypeName())).map(x -> x.getMaterialTypeName()).distinct().collect(Collectors.joining(","));
        entity.setMaterialTypeNames(materialTypeNames);
        BigDecimal sumMny = new BigDecimal(0);
        for (RestituteMaintainEntity restituteMaintainEntity : entity.getRestituteMaintainList()) {
            sumMny = ComputeUtil.safeAdd((BigDecimal)restituteMaintainEntity.getMaintainMny(), (BigDecimal)sumMny);
        }
        for (RestituteScrapEntity restituteScrapEntity : entity.getRestituteDetailList()) {
            sumMny = ComputeUtil.safeAdd((BigDecimal)restituteScrapEntity.getDamageMny(), (BigDecimal)sumMny);
        }
        for (RestituteOtherEntity restituteOtherEntity : entity.getOtherList()) {
            sumMny = ComputeUtil.safeAdd((BigDecimal)restituteOtherEntity.getCurrentAmount(), (BigDecimal)sumMny);
        }
        entity.setRestituteSumMny(sumMny);
        entity.setOrgId(InvocationInfoProxy.getOrgId());
        ArrayList<Long> projectId = new ArrayList<Long>();
        projectId.add(entity.getProjectId());
        CommonResponse projectRegisterVO = this.iProjectApi.queryProjectByIds(projectId);
        if (projectRegisterVO.getCode() == 0 && projectRegisterVO.getData() != null) {
            entity.setOrgId(((ProjectRegisterVO)((List)projectRegisterVO.getData()).get(0)).getProjectDepartmentId());
            CommonResponse orgVo = this.iOrgApi.detailById(entity.getOrgId());
            entity.setOrgCode(((OrgVO)orgVo.getData()).getCode());
            entity.setOrgName(((OrgVO)orgVo.getData()).getName());
            if (((OrgVO)orgVo.getData()).getParentId() != null) {
                entity.setParentOrgId(((OrgVO)orgVo.getData()).getParentId());
            } else {
                entity.setParentOrgId(entity.getOrgId());
            }
        } else {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u672a\u83b7\u53d6\u5230\u9879\u76ee\u90e8\u4e3b\u952e");
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (!this.flowService.insertRestFlow(entity, BillTypeEnum.\u8d54\u507f\u5355.getCode(), RmatCommonConsts.NO).booleanValue()) {
            return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        RestituteVO vo = (RestituteVO)BeanMapper.map((Object)((Object)entity), RestituteVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryTax"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<CmContractInfoVO>> queryPrice(String contractId) {
        CommonResponse list = this.cmContractInfoApi.queryLeaseContractInfoById(contractId);
        return list;
    }

    private String validateNum(RestituteVO restituteVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter("eq", (Object)restituteVO.getContractId()));
        List<MaterialVO> list = this.materialService.queryCheckList(param, "rest");
        Map map = list.stream().collect(Collectors.toMap(x -> x.getMaterialId() + "||" + x.getUseStatus(), Function.identity()));
        String key = null;
        BigDecimal num = BigDecimal.ZERO;
        for (RestituteScrapVO vo : restituteVO.getRestituteDetailList()) {
            num = ComputeUtil.safeSub((BigDecimal)vo.getRentNum(), (BigDecimal[])new BigDecimal[]{vo.getNum(), vo.getRealNum()});
            key = vo.getMaterialId() + "||" + vo.getUseStatus();
            if (!map.containsKey(key) || num.compareTo(((MaterialVO)map.get(key)).getRefNum()) <= 0) continue;
            throw new BusinessException("\u5b50\u8868\u6570\u91cf\u5927\u4e8e\u53ef\u53c2\u7167\u6570\u91cf");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RestituteVO> queryDetail(Long id) {
        RestituteEntity entity = (RestituteEntity)((Object)this.service.selectById(id));
        RestituteVO vo = (RestituteVO)BeanMapper.map((Object)((Object)entity), RestituteVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RestituteVO> vos) {
        List<Long> ids;
        if (ListUtil.isNotEmpty(vos)) {
            for (RestituteVO restituteVO : vos) {
            }
        }
        if (!this.flowService.delFlow(ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList()), BillTypeEnum.\u8d54\u507f\u5355.getCode()).booleanValue()) {
            return CommonResponse.error((String)"\u5355\u636e\u5220\u9664\u6d41\u6c34\u5931\u8d25\uff01");
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RestituteVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("materialTypeNames");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List restituteVOS = BeanMapper.mapList((Iterable)page.getRecords(), RestituteVO.class);
        restituteVOS.forEach(e -> {
            if (e.getSupplierSignStatus() == 1) {
                e.setSupplierSignStatusName("\u5df2\u7b7e\u5b57");
            } else {
                e.setSupplierSignStatusName("\u672a\u7b7e\u5b57");
            }
        });
        pageData.setRecords(restituteVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
            param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        List list = this.service.queryList(param);
        List restituteVOS = BeanMapper.mapList((Iterable)list, RestituteVO.class);
        restituteVOS.forEach(e -> {
            if (e.getSupplierSignStatus() == 1) {
                e.setSupplierSignStatusName("\u5df2\u7b7e\u5b57");
            } else {
                e.setSupplierSignStatusName("\u672a\u7b7e\u5b57");
            }
            e.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)e.getBillState()).getDescription());
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", restituteVOS);
        ExcelExport.getInstance().export("Restitute-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRestituteData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RestituteVO>> refRestituteData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RestituteVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/validateContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam(value="contractId") Long contractId, @RequestParam(value="billId", required=false) Long billId) {
        String msg = this.service.validateContract(contractId, billId);
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }

    @PostMapping(value={"/supSignSync"})
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = this.service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return CommonResponse.error((String)msg);
        }
        return CommonResponse.success((String)"\u7b7e\u5b57\u72b6\u6001\u56de\u5199\u6210\u529f\uff01");
    }

    @GetMapping(value={"/testPushBill"})
    public CommonResponse<String> testPushBill(Long id) {
        RestituteEntity entity = (RestituteEntity)((Object)this.service.selectById(id));
        this.service.pushBillToSupCenter(entity);
        return CommonResponse.success((String)"\u63a8\u9001\u6210\u529f\uff01");
    }

    @GetMapping(value={"/getBillShareLink"})
    public CommonResponse<JSONObject> getBillShareLink(Long id) {
        RestituteEntity entity = (RestituteEntity)((Object)this.service.selectById(id));
        if (SupplierSignStatusEnum.\u4e59\u65b9\u672a\u7b7e\u5b57.getCode().equals(entity.getSupplierSignStatus()) && entity.getPushFlag() == 0) {
            boolean pushResult = this.service.pushBillToSupCenter(entity);
            if (!pushResult) {
                return CommonResponse.error((String)"\u5355\u636e\u63a8\u9001\u4f9b\u65b9\u5931\u8d25\uff0c\u751f\u6210\u5206\u4eab\u8fde\u63a5\u5931\u8d25\uff01");
            }
            entity.setPushFlag(1);
            this.service.saveOrUpdate((Object)entity, false);
        }
        return this.shareCooperateApi.getShareLink(id, BillTypeEnum.\u8d54\u507f\u5355.getCode(), entity.getSupplierId().toString(), "/ejc-supbusiness-mobile/#/assistrmat/restitute/card", null);
    }
}

