/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.rmat.bean.ExitEntity;
import com.ejianc.business.rmat.bean.ExitSupplierEntity;
import com.ejianc.business.rmat.bean.TransferDetailEntity;
import com.ejianc.business.rmat.bean.TransferEntity;
import com.ejianc.business.rmat.bean.TransferFlowEntity;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.consts.TransFlowTypeEnum;
import com.ejianc.business.rmat.mapper.TransferFlowMapper;
import com.ejianc.business.rmat.service.ITransferFlowService;
import com.ejianc.business.rmat.vo.TransferFlowVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="transferFlowService")
public class TransferFlowServiceImpl
extends BaseServiceImpl<TransferFlowMapper, TransferFlowEntity>
implements ITransferFlowService {
    TransferFlowEntity t;
    List<String> temps;
    List<String> femp;
    int index;
    List<String> femps;
    BigDecimal amount;

    @Override
    public Boolean insertTransferFlow(TransferEntity entity, Integer flowType, Integer effectiveState) {
        if (effectiveState.equals(RmatCommonConsts.TWO)) {
            Boolean flag = this.verify(entity.getId(), TransFlowTypeEnum.\u8c03\u5165.getFlowType());
            if (Boolean.FALSE.equals(flag)) {
                throw new BusinessException("\u64a4\u56de\u5931\u8d25!\u5b50\u8868\u6750\u6599\u5df2\u88ab\u5360\u7528\uff01");
            }
            List flowList = this.list((Wrapper)new QueryWrapper().eq((Object)"source_id", (Object)entity.getId()));
            flowList.forEach(e -> {
                e.setEffectiveDate(null);
                e.setEffectiveState(RmatCommonConsts.NO);
            });
            return this.saveOrUpdateBatch(flowList);
        }
        if (effectiveState.equals(RmatCommonConsts.YES) && flowType.equals(TransFlowTypeEnum.\u8c03\u51fa.getFlowType())) {
            List flowList = this.list((Wrapper)new QueryWrapper().eq((Object)"source_id", (Object)entity.getId()));
            flowList.forEach(e -> {
                e.setEffectiveDate(new Date());
                e.setEffectiveState(RmatCommonConsts.YES);
            });
            return this.saveOrUpdateBatch(flowList);
        }
        return this.insertFlow(this.transfer(entity, flowType, effectiveState), flowType);
    }

    @Override
    public Boolean insertExitFlow(ExitEntity entity, Integer flowType, Integer effectiveState) {
        if (effectiveState.equals(RmatCommonConsts.TWO)) {
            List flowList = this.list((Wrapper)new QueryWrapper().eq((Object)"source_id", (Object)entity.getId()));
            flowList.forEach(e -> {
                e.setEffectiveDate(null);
                e.setEffectiveState(RmatCommonConsts.NO);
            });
            return this.saveOrUpdateBatch(flowList);
        }
        ArrayList<TransferFlowVO> flowList = new ArrayList<TransferFlowVO>();
        List<ExitSupplierEntity> detailList = entity.getExitSupplierList();
        for (ExitSupplierEntity detail : detailList) {
            TransferFlowVO vo = new TransferFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(TransFlowTypeEnum.\u9000\u573a.getBillTypeCode());
            vo.setSourceId(entity.getId());
            vo.setSourceDetailId(detail.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setParentOrgId(entity.getParentOrgId());
            vo.setProjectId(entity.getProjectId());
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setEmployeeId(entity.getEmployeeId());
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getExitDate());
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);
            vo.setEffectiveState(effectiveState);
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());
            vo.setUnitId(detail.getUnitId());
            vo.setUnitName(detail.getUnitName());
            vo.setNum(detail.getNum());
            vo.setRealUnitId(detail.getRealUnitId());
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealNum());
            vo.setRealTransScale(detail.getRealTransScale());
            vo.setRowState(detail.getRowState());
            vo.setRentUnitId(detail.getRentUnitId());
            vo.setRentUnitName(detail.getRentUnitName());
            vo.setRentNum(detail.getRentNum());
            vo.setRentTransScale(detail.getRentTransScale());
            vo.setRealUnitId(detail.getRealUnitId());
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealNum());
            vo.setRealTransScale(detail.getRentTransScale());
            vo.setUnitId(detail.getUnitId());
            vo.setUnitName(detail.getUnitName());
            vo.setNum(detail.getNum());
            vo.setAmount(ComputeUtil.safeDiv((BigDecimal)detail.getRealOutNum(), (BigDecimal)detail.getRealTransScale()));
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSupplierId(detail.getSupplierId());
            vo.setSupplierName(detail.getSupplierName());
            vo.setFlowType(String.valueOf(flowType));
            vo.setInOutFlag(RmatCommonConsts.OUT);
            vo.setQueryId(entity.getProjectId() + "_" + detail.getSupplierId());
            vo.setUseStatus("0");
            flowList.add(vo);
        }
        if (entity.getId() != null) {
            this.queryOcc(entity.getId(), flowType, flowList);
        }
        this.writeBack(flowList, entity.getSupplierId());
        return this.insertFlow(flowList, flowType);
    }

    @Override
    public Boolean delFlow(List<Long> sourceIds, Integer flowType) {
        if (CollectionUtils.isEmpty(sourceIds)) {
            return true;
        }
        QueryWrapper ew = new QueryWrapper();
        ew.in((Object)"source_id", sourceIds);
        ew.eq((Object)"bill_type_code", (Object)TransFlowTypeEnum.getEnumByInOutType((Integer)flowType).getBillTypeCode());
        return super.remove((Wrapper)ew);
    }

    @Override
    public List<TransferFlowVO> getListData(List<TransferFlowVO> flowVo) {
        Map<String, List<TransferFlowVO>> flowMap = flowVo.stream().collect(Collectors.groupingBy(x -> x.getProjectId() + "_" + x.getSupplierId()));
        ArrayList<TransferFlowVO> flowVoS = new ArrayList<TransferFlowVO>();
        int iudex = 0;
        for (Map.Entry<String, List<TransferFlowVO>> entry : flowMap.entrySet()) {
            TransferFlowVO fvo = entry.getValue().get(0);
            TransferFlowVO vo = new TransferFlowVO();
            String[] temp = entry.getKey().split("_");
            vo.setId(Long.valueOf(System.currentTimeMillis() + (long)(++iudex)));
            vo.setProjectId(Long.valueOf(temp[0]));
            vo.setProjectCode(fvo.getProjectCode() != null ? fvo.getProjectCode() : null);
            vo.setSupplierId(Long.valueOf(temp[1]));
            vo.setProjectName(fvo.getProjectName());
            vo.setSupplierName(fvo.getSupplierName());
            vo.setOrgId(fvo.getOrgId());
            vo.setOrgName(fvo.getOrgName());
            vo.setOrgCode(fvo.getOrgCode() != null ? fvo.getOrgCode() : null);
            vo.setParentOrgId(fvo.getParentOrgId());
            vo.setParentOrgCode(fvo.getParentOrgCode() != null ? fvo.getParentOrgCode() : null);
            vo.setParentOrgName(fvo.getParentOrgName() != null ? fvo.getParentOrgName() : null);
            vo.setSumOnHandNums(entry.getValue().stream().filter(x -> RmatCommonConsts.IN.equals(x.getInOutFlag()) && x.getAmount() != null && x.getEffectiveState().equals(RmatCommonConsts.YES)).map(TransferFlowVO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setSumExitNums(entry.getValue().stream().filter(x -> RmatCommonConsts.OUT.equals(x.getInOutFlag()) && x.getAmount() != null).map(TransferFlowVO::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add));
            flowVoS.add(vo);
        }
        return flowVoS;
    }

    @Override
    public TransferFlowVO getFlowData(List<TransferFlowEntity> v) {
        TransferFlowEntity e = v.get(0);
        TransferFlowVO fvo = new TransferFlowVO();
        fvo.setId(e.getId());
        fvo.setMaterialId(e.getMaterialId());
        fvo.setMaterialCode(e.getMaterialCode());
        fvo.setMaterialName(e.getMaterialName());
        fvo.setMaterialTypeId(e.getMaterialTypeId());
        fvo.setMaterialTypeName(e.getMaterialTypeName());
        fvo.setUnitId(e.getUnitId());
        fvo.setUnitName(e.getUnitName());
        fvo.setRealUnitId(e.getRealUnitId());
        fvo.setRealUnitName(e.getRealUnitName());
        fvo.setRealNum(e.getRealNum());
        fvo.setNum(e.getNum());
        fvo.setSpec(e.getSpec());
        fvo.setMaterialSourceId(e.getMaterialSourceId());
        fvo.setRealTransScale(e.getRealTransScale());
        BigDecimal sumOnHandNums = v.stream().filter(x -> RmatCommonConsts.IN.equals(x.getInOutFlag()) && x.getAmount() != null && x.getEffectiveState().equals(RmatCommonConsts.YES)).map(TransferFlowEntity::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        fvo.setSumOnHandNums(sumOnHandNums);
        BigDecimal sumExitNums = v.stream().filter(x -> RmatCommonConsts.OUT.equals(x.getInOutFlag()) && x.getAmount() != null).map(TransferFlowEntity::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        fvo.setSumExitNums(sumExitNums);
        fvo.setRealOnHandNums(ComputeUtil.safeSub((BigDecimal)sumOnHandNums, (BigDecimal)sumExitNums));
        fvo.setSumNums(ComputeUtil.safeMultiply((BigDecimal)fvo.getRealOnHandNums(), (BigDecimal)fvo.getRealTransScale()));
        return fvo;
    }

    @Override
    public Boolean verify(Long id, Integer flowType) {
        List list = this.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"source_id", (Object)id)).eq((Object)"flow_type", (Object)flowType.toString())).eq((Object)"effective_state", (Object)RmatCommonConsts.YES)).isNotNull((Object)"occup_num"));
        return !CollectionUtils.isNotEmpty((Collection)list);
    }

    @Override
    public String delete(List<Long> sourceIds, Integer flowType) {
        if (flowType.equals(TransFlowTypeEnum.\u8c03\u51fa.getFlowType()) || flowType.equals(TransFlowTypeEnum.\u9000\u573a.getFlowType())) {
            for (Long id : sourceIds) {
                Boolean flag;
                if (flowType.equals(TransFlowTypeEnum.\u8c03\u51fa.getFlowType()) && Boolean.FALSE.equals(flag = this.verify(id, TransFlowTypeEnum.\u8c03\u5165.getFlowType()))) {
                    throw new BusinessException("\u5220\u9664\u5931\u8d25!\u5b50\u8868\u6750\u6599\u5df2\u88ab\u5360\u7528\uff01");
                }
                this.backNumAndId(id, flowType);
            }
        } else {
            Boolean flag = this.verify(sourceIds.get(0), flowType);
            if (Boolean.FALSE.equals(flag)) {
                throw new BusinessException("\u5220\u9664\u5931\u8d25!\u5b50\u8868\u6750\u6599\u5df2\u88ab\u5360\u7528\uff01");
            }
        }
        this.delFlow(sourceIds, flowType);
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public Boolean insertFlow(List<TransferFlowVO> vos, Integer flowType) {
        ArrayList<TransferFlowVO> addList = new ArrayList<TransferFlowVO>();
        ArrayList<Long> delIds = new ArrayList<Long>();
        for (TransferFlowVO vo : vos) {
            if (!flowType.equals(TransFlowTypeEnum.\u8c03\u51fa.getFlowType())) {
                vo.setId(vo.getSourceDetailId());
            } else if (vo.getInOutFlag() == 1) {
                vo.setId(vo.getSourceDetailId());
            }
            if (!"del".equals(vo.getRowState())) {
                addList.add(vo);
                continue;
            }
            delIds.add(flowType.equals(TransFlowTypeEnum.\u8c03\u51fa.getFlowType()) ? vo.getSourceDetailId() : vo.getId());
        }
        if (CollectionUtils.isNotEmpty(addList)) {
            List list = BeanMapper.mapList(addList, TransferFlowEntity.class);
            super.saveOrUpdateBatch((Collection)list);
        }
        if (CollectionUtils.isNotEmpty(delIds)) {
            if (!flowType.equals(TransFlowTypeEnum.\u8c03\u51fa.getFlowType())) {
                super.removeByIds(delIds);
            } else {
                LambdaUpdateWrapper query = new LambdaUpdateWrapper();
                query.set(BaseEntity::getDr, (Object)1);
                query.in(TransferFlowEntity::getSourceDetailId, delIds);
                this.update((Wrapper)query);
            }
        }
        return true;
    }

    public List<TransferFlowVO> transfer(TransferEntity entity, Integer flowType, Integer effectiveState) {
        ArrayList<TransferFlowVO> flowList = new ArrayList<TransferFlowVO>();
        ArrayList<TransferFlowVO> inFlowList = new ArrayList<TransferFlowVO>();
        List<TransferDetailEntity> detailList = entity.getDetailList();
        for (TransferDetailEntity detail : detailList) {
            TransferFlowVO vo = new TransferFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(TransFlowTypeEnum.getEnumByInOutType((Integer)flowType).getBillTypeCode());
            vo.setSourceId(entity.getId());
            vo.setSourceDetailId(detail.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setProjectId(entity.getProjectId());
            vo.setProjectCode(entity.getProjectCode());
            vo.setProjectName(entity.getProjectName());
            vo.setParentOrgId(entity.getParentOrgId());
            vo.setParentOrgCode(entity.getParentOrgCode());
            vo.setParentOrgName(entity.getParentOrgName());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgCode(entity.getOrgCode());
            vo.setOrgName(entity.getOrgName());
            vo.setEmployeeId(entity.getEmployeeId());
            vo.setEmployeeName(entity.getEmployeeName());
            vo.setBillDate(entity.getTransferDate());
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);
            vo.setEffectiveState(effectiveState);
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setSpec(detail.getSpec());
            vo.setUnitId(detail.getUnitId());
            vo.setUnitName(detail.getUnitName());
            vo.setNum(detail.getNum() == null ? ComputeUtil.safeMultiply((BigDecimal)detail.getAllotInNum(), (BigDecimal)detail.getRealTransScale()) : detail.getNum());
            vo.setRealUnitId(detail.getRealUnitId());
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealNum() == null ? detail.getAllotInNum() : detail.getRealNum());
            vo.setRealTransScale(detail.getRealTransScale());
            vo.setRowState(detail.getRowState());
            vo.setAmount(detail.getAllotInNum());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            if (TransFlowTypeEnum.getEnumByInOutType((Integer)flowType).equals((Object)TransFlowTypeEnum.\u8c03\u51fa)) {
                TransferFlowVO inVo = (TransferFlowVO)BeanMapper.map((Object)vo, TransferFlowVO.class);
                inVo.setFlowType(String.valueOf(TransFlowTypeEnum.\u8c03\u5165.getFlowType()));
                inVo.setUseStatus("0");
                inVo.setInOutFlag(RmatCommonConsts.IN);
                inVo.setSupplierId(entity.getAllotInId());
                inVo.setSupplierName(entity.getAllotInName());
                inVo.setQueryId(entity.getProjectId() + "_" + entity.getAllotInId());
                inVo.setInOutId(entity.getAllotOutId());
                inVo.setInOutName(entity.getAllotOutName());
                vo.setSupplierId(entity.getAllotOutId());
                vo.setSupplierName(entity.getAllotOutName());
                vo.setInOutId(entity.getAllotInId());
                vo.setInOutName(entity.getAllotInName());
                vo.setQueryId(entity.getProjectId() + "_" + entity.getAllotOutId());
                vo.setFlowType(String.valueOf(TransFlowTypeEnum.\u8c03\u51fa.getFlowType()));
                vo.setInOutFlag(RmatCommonConsts.OUT);
                vo.setUseStatus("0");
                inFlowList.add(inVo);
            } else {
                vo.setSupplierId(entity.getAllotInId());
                vo.setSupplierName(entity.getAllotInName());
                vo.setQueryId(entity.getProjectId() + "_" + entity.getAllotInId());
                vo.setFlowType(String.valueOf(TransFlowTypeEnum.\u8c03\u5165.getFlowType()));
                vo.setUseStatus("0");
                vo.setInOutFlag(RmatCommonConsts.IN);
            }
            flowList.add(vo);
        }
        if (flowType.equals(RmatCommonConsts.FOUR)) {
            this.queryOcc(entity.getId(), flowType, flowList);
            this.writeBack(flowList, entity.getAllotOutId());
            flowList.addAll(inFlowList);
        }
        return flowList;
    }

    private void writeBack(List<TransferFlowVO> flowList, Long supplierId) {
        List ids = flowList.stream().map(TransferFlowVO::getMaterialId).distinct().collect(Collectors.toList());
        List list = this.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"supplier_id", (Object)supplierId)).eq((Object)"in_out_flag", (Object)RmatCommonConsts.IN)).eq((Object)"effective_state", (Object)RmatCommonConsts.YES)).in((Object)"material_id", ids)).orderByAsc((Object)"effective_date"));
        if (list.isEmpty()) {
            return;
        }
        Map<String, TransferFlowEntity> maps = list.stream().collect(Collectors.toMap(x -> String.valueOf(x.getId()), Function.identity()));
        for (TransferFlowVO vo : flowList) {
            if ("add".equals(vo.getRowState())) continue;
            this.backNumAndId(vo, maps);
        }
        Map flowMap = new ArrayList(maps.values()).stream().collect(Collectors.groupingBy(TransferFlowEntity::getMaterialId, LinkedHashMap::new, Collectors.toList()));
        block1: for (TransferFlowVO vo : flowList) {
            if ("del".equals(vo.getRowState())) continue;
            List flows = (List)flowMap.get(vo.getMaterialId());
            BigDecimal count = vo.getAmount();
            for (TransferFlowEntity e : flows) {
                BigDecimal onNum = ComputeUtil.safeSub((BigDecimal)e.getAmount(), (BigDecimal)(StringUtils.isBlank((CharSequence)e.getOccupNum()) ? BigDecimal.ZERO : new BigDecimal(e.getOccupNum())));
                count = ComputeUtil.safeSub((BigDecimal)count, (BigDecimal)onNum);
                vo.setOccupId(StringUtils.isNotBlank((CharSequence)vo.getOccupId()) ? vo.getOccupId() + "," + e.getId() : e.getId().toString());
                e.setOccupId(StringUtils.isNotBlank((CharSequence)e.getOccupId()) ? e.getOccupId() + "," + vo.getSourceDetailId() : vo.getSourceDetailId().toString());
                if (count.compareTo(BigDecimal.ZERO) < 0) {
                    String occNum = ComputeUtil.safeAdd((BigDecimal)onNum, (BigDecimal)count).toString();
                    e.setUseStatus("2");
                    e.setOccupNum(ComputeUtil.safeAdd((BigDecimal)(StringUtils.isBlank((CharSequence)e.getOccupNum()) ? BigDecimal.ZERO : new BigDecimal(e.getOccupNum())), (BigDecimal)new BigDecimal(occNum)).toString());
                    vo.setOccupNum(StringUtils.isNotBlank((CharSequence)vo.getOccupNum()) ? vo.getOccupNum() + "," + occNum : occNum);
                    maps.put(e.getId().toString(), e);
                    continue block1;
                }
                if (count.compareTo(BigDecimal.ZERO) > 0) {
                    e.setUseStatus("1");
                    e.setOccupNum(String.valueOf(e.getAmount()));
                    vo.setOccupNum(StringUtils.isNotBlank((CharSequence)vo.getOccupNum()) ? vo.getOccupNum() + "," + onNum : String.valueOf(onNum));
                    maps.put(e.getId().toString(), e);
                    continue;
                }
                e.setUseStatus("1");
                e.setOccupNum(String.valueOf(e.getAmount()));
                vo.setOccupNum(StringUtils.isNotBlank((CharSequence)vo.getOccupNum()) ? vo.getOccupNum() + "," + onNum : String.valueOf(onNum));
                maps.put(e.getId().toString(), e);
                continue block1;
            }
        }
        ArrayList<TransferFlowEntity> entities = new ArrayList<TransferFlowEntity>(maps.values());
        this.saveOrUpdateBatch(entities);
    }

    public void backNumAndId(Long sourceId, Integer flowType) {
        List list = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"source_id", (Object)sourceId)).eq((Object)"flow_type", (Object)flowType.toString()));
        if (list.isEmpty()) {
            return;
        }
        List<String> sids = list.stream().map(TransferFlowEntity::getOccupId).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList stemp = new ArrayList();
        sids.forEach(e -> {
            if (e.contains(",")) {
                stemp.addAll(new ArrayList<String>(Arrays.asList(e.split(","))));
            } else {
                stemp.add(e);
            }
        });
        List ids = stemp.stream().map(Long::valueOf).collect(Collectors.toList());
        List entityList = this.list((Wrapper)new QueryWrapper().in((Object)"id", ids));
        Map<String, TransferFlowEntity> maps = entityList.stream().collect(Collectors.toMap(x -> String.valueOf(x.getId()), Function.identity()));
        for (TransferFlowVO vo : BeanMapper.mapList((Iterable)list, TransferFlowVO.class)) {
            this.backNumAndId(vo, maps);
        }
        ArrayList entities = new ArrayList(maps.values());
        this.saveOrUpdateBatch(entities);
    }

    public void backNumAndId(TransferFlowVO vo, Map<String, TransferFlowEntity> maps) {
        if (vo.getOccupId().contains(",")) {
            this.temps = new ArrayList<String>(Arrays.asList(vo.getOccupNum().split(",")));
            this.femp = new ArrayList<String>(Arrays.asList(vo.getOccupId().split(",")));
            this.femps = this.femp;
            for (String s : this.femp) {
                this.t = maps.get(s);
                if (this.t.getOccupId().contains(",")) {
                    this.index = vo.getOccupId().indexOf(s);
                    this.t.setOccupNum(String.valueOf(ComputeUtil.safeSub((BigDecimal)new BigDecimal(this.t.getOccupNum()), (BigDecimal)new BigDecimal(this.temps.get(this.index)))));
                    this.t.setUseStatus("2");
                    this.femps.remove(s);
                    this.temps.remove(this.index);
                    vo.setOccupId(String.join((CharSequence)",", this.femps));
                    vo.setOccupNum(String.join((CharSequence)",", this.temps));
                    this.femps = new ArrayList<String>(Arrays.asList(this.t.getOccupId().split(",")));
                    this.femps.remove(vo.getSourceDetailId().toString());
                    this.t.setOccupId(String.join((CharSequence)",", this.femps));
                }
                maps.put(this.t.getId().toString(), this.t);
            }
        } else {
            this.t = maps.get(vo.getOccupId());
            if (this.t.getOccupId().contains(",")) {
                this.femps = new ArrayList<String>(Arrays.asList(vo.getOccupId().split(",")));
                this.femps.remove(vo.getSourceDetailId().toString());
                this.t.setOccupId(String.join((CharSequence)",", this.femps));
                this.amount = ComputeUtil.safeSub((BigDecimal)new BigDecimal(this.t.getOccupNum()), (BigDecimal)new BigDecimal(vo.getOccupNum()));
                this.t.setOccupNum(this.amount.compareTo(BigDecimal.valueOf(0.0)) == 0 ? null : this.amount.toString());
                this.t.setUseStatus("2");
            } else {
                this.t.setOccupNum(null);
                this.t.setOccupId(null);
                this.t.setUseStatus("0");
            }
            vo.setOccupId(null);
            vo.setOccupNum(null);
            maps.put(this.t.getId().toString(), this.t);
        }
    }

    public void queryOcc(Long id, Integer flowType, List<TransferFlowVO> flowList) {
        List list = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"source_id", (Object)id)).eq((Object)"flow_type", (Object)flowType.toString()));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (TransferFlowEntity flowEntity : list) {
                for (TransferFlowVO vo : flowList) {
                    if (!flowEntity.getMaterialId().equals(vo.getMaterialId())) continue;
                    vo.setOccupId(flowEntity.getOccupId());
                    vo.setOccupNum(flowEntity.getOccupNum());
                    vo.setId(flowEntity.getId());
                }
            }
        }
    }
}

