/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.rmat.enums.SupplierSignStatusEnum;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ExceptionUtil;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Component(value="assistPushSupUtil")
public class PushSupUtil<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REFER_CACHE_KEY = "refer_cache_key:";
    private static final String noPower = "\u65e0\u6743\u9650\u8bbf\u95ee\u8be5\u670d\u52a1\uff0c\u8bf7\u5148\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u6388\u6743\uff01";
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushBillToSupCenter(JSONObject entity, String OPERATE, String code, String name, String url) {
        String id = entity.getString("id");
        String supplierId = entity.getString("supplierId");
        CommonResponse resp = this.shareCooperateApi.queryCooperateBybillTypeCode(code);
        if (!resp.isSuccess()) {
            this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)code, (Object)resp.getMsg());
            return false;
        }
        CooperateVO cooperate = (CooperateVO)resp.getData();
        if (new Integer(0).equals(cooperate.getShareFlag())) {
            this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\uff0c\u5355\u636e-{}\u534f\u540c\u914d\u7f6e\u4e0d\u652f\u6301\u534f\u540c\u5206\u4eab", (Object)code, (Object)name);
            return true;
        }
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = code + "::" + id;
        CommonResponse systemCodeResp = this.proSupplierApi.getEjcCloudSystemCode();
        if (!systemCodeResp.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}-id{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", new Object[]{name, id, systemCodeResp.getMsg()});
            return false;
        }
        entity.put("sourceSystemId", systemCodeResp.getData());
        if (entity.containsKey((Object)"tenantId")) {
            entity.remove((Object)"tenantId");
        }
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)OPERATE, (int)600);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transData", JSONObject.toJSONString((Object)entity));
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(Long.valueOf(id), null, null, null);
            if (!fileResp.isSuccess()) {
                this.logger.error("\u83b7\u53d6\u5355\u636e-{}id-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", new Object[]{name, id, fileResp.getMsg()});
                boolean bl = false;
                return bl;
            }
            List fileList = (List)fileResp.getData();
            HashMap<String, String> sourceTypeMap = new HashMap<String, String>();
            ArrayList<Long> fileIds = new ArrayList<Long>();
            for (AttachmentVO attach : fileList) {
                sourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                fileIds.add(attach.getId());
            }
            paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(sourceTypeMap));
            HashMap files = new HashMap();
            if (CollectionUtils.isNotEmpty((Collection)fileList)) {
                Map fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                fileMap.keySet().stream().forEach(fileKey -> {
                    HashMap file = new HashMap(1);
                    file.put((String)fileKey, fileMap.get(fileKey));
                    files.put(fileKey, file);
                });
            }
            this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u5355\u636e-{}\u53c2\u6570-{}", new Object[]{supplierId, name, JSONObject.toJSONString(paramMap)});
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(url, paramMap, supplierId, files);
            if (!syncReqResp.isSuccess()) {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u5355\u636e-{}id-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{name, id, supplierId, syncReqResp.getMsg()});
                boolean bl = false;
                return bl;
            }
            if (noPower.equals(syncReqResp.getData())) {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42URL-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{url, supplierId, syncReqResp.getData()});
                boolean bl = false;
                return bl;
            }
            CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
            if (billPushResp.isSuccess()) {
                syncFlag = true;
            } else {
                this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u5355\u636e-{}id-{}\u5931\u8d25, {}", new Object[]{supplierId, name, id, billPushResp.getMsg()});
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}id-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{name, id, supplierId, e});
        }
        finally {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
            jedis.close();
        }
        return syncFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateBillSupSignSyncInfo(HttpServletRequest request, JSONObject entity, Class<?> mainClass, String OPERATE, String code, String name) {
        if (entity == null) {
            this.logger.error("\u5355\u636eid-{}\u67e5\u8be2\u5931\u8d25\uff0c\u672a\u67e5\u8be2\u5230\u5355\u636e\uff01", (Object)entity.getString("id"));
            return "\u672a\u67e5\u8be2\u5230\u5355\u636e";
        }
        String authority = request.getHeader("authority");
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Long time = Long.valueOf(request.getParameter("supOperateTime"));
        Date supOperateTime = time != null ? new Date(time) : null;
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map map = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        this.logger.info("\u63a5\u6536\u5230\u5355\u636e\u7b7e\u7ae0\u901a\u77e5\uff1aid-{}, supOperatorName-{}, supOperatorPhone-{}, supOperatorUserCode-{}, supOperateTime-{}, nameSourceTypeMapping-{}", new Object[]{billId, supOperatorName, supOperatorPhone, supOperatorUserCode, supOperateTime, nameSourceTypeMapping});
        entity.put("supOperateTime", (Object)supOperateTime);
        entity.put("supOperatorName", (Object)supOperatorName);
        entity.put("supOperatorPhone", (Object)supOperatorPhone);
        entity.put("supOperatorUserCode", (Object)supOperatorUserCode);
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String key = code + "::" + billId;
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)OPERATE, (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)billId);
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            ArrayList attchIdsList = new ArrayList();
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, map, code, authority, billId.toString());
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            entity.put("attachIds", attchIdsList);
            entity.put("supplierSignStatus", (Object)SupplierSignStatusEnum.\u4e59\u65b9\u5df2\u7b7e\u5b57.getCode());
            this.saveOrUpdate(entity, mainClass);
            String[] channel = new String[]{"sys"};
            String createUserCode = entity.getString("createUserCode");
            String createUserId = PushSupUtil.getCreateUserId(createUserCode);
            String employeeId = entity.getString("employeeId");
            Object[] receivers = new String[]{createUserId, employeeId};
            String result = this.sendMsg(channel, (String[])receivers, "notice", "\u4f9b\u65b9\u5df2\u7b7e\u5b57\u63d0\u9192", name + "[" + code + "]\u4f9b\u65b9\u5df2\u7b7e\u5b57\u5b8c\u6210");
            if (null != result) {
                this.logger.error("\u5411\u7528\u6237-{}\u53d1\u9001\u5355\u636eid-{}\u7b7e\u5b57\u63d0\u9192\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", new Object[]{StringUtils.join((Object[])receivers), billId, result});
            }
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)billId, (Object)e);
            String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
            return string;
        }
        finally {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
            jedis.close();
        }
        return msg;
    }

    private void saveOrUpdate(JSONObject entity, Class<?> mainClass) {
        String className = mainClass.getSimpleName();
        className = className.substring(0, 1).toLowerCase() + className.substring(1);
        String serviceName = className.substring(0, className.lastIndexOf("Entity")) + "Service";
        BaseServiceImpl service = (BaseServiceImpl)ContextUtil.getBean((String)serviceName, BaseServiceImpl.class);
        service.saveOrUpdate(BeanMapper.map((Object)entity, mainClass), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delPushBill(JSONObject entity, String OPERATE, String code, String name, String url) {
        String id = entity.getString("id");
        String supplierId = entity.getString("supplierId");
        CommonResponse resp = this.shareCooperateApi.queryCooperateBybillTypeCode(code);
        if (!resp.isSuccess()) {
            this.logger.error("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\u5176\u534f\u540c\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0c{}", (Object)code, (Object)resp.getMsg());
            throw new BusinessException("\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u83b7\u53d6\u5355\u636e\u534f\u540c\u914d\u7f6e\u5931\u8d25\uff01");
        }
        CooperateVO cooperate = (CooperateVO)resp.getData();
        if (cooperate == null || new Integer(0).equals(cooperate.getShareFlag())) {
            this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578b-{}\u67e5\u8be2\uff0c\u5355\u636e-{}\u534f\u540c\u914d\u7f6e\u4e0d\u652f\u6301\u534f\u540c\u5206\u4eab", (Object)code, (Object)name);
            return true;
        }
        boolean locked = false;
        boolean delSuc = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = code + "::" + id;
        CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            this.logger.error("\u63a8\u9001\u5355\u636e-{}id-{}\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25,{}", new Object[]{name, id, ejcCloudSystemCode.getMsg()});
        }
        String sourceSystemId = (String)ejcCloudSystemCode.getData();
        entity.put("sourceSystemId", (Object)sourceSystemId);
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)OPERATE, (int)600);
            if (!locked) {
                boolean bl = delSuc;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("sourceId", id);
            paramMap.put("sourceSystemId", sourceSystemId);
            this.logger.info("\u5355\u636e-{}id-{}\u5f03\u5ba1\uff0c\u901a\u77e5\u4f9b\u65b9-{}\u5355\u636e\u4f5c\u5e9f!", new Object[]{name, id, supplierId});
            CommonResponse syncReqResp = this.systemDataPushService.exchangeDataWithEachLinkSystem(url, RequestMethod.POST, JSONObject.toJSONString(paramMap), supplierId);
            if (!syncReqResp.isSuccess()) {
                this.logger.error("\u53d1\u9001\u8bf7\u6c42\u901a\u77e5\u4f9b\u65b9-{} \u5355\u636eid-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{supplierId, id, syncReqResp.getMsg()});
                boolean bl = delSuc;
                return bl;
            }
            CommonResponse supHandleResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
            if (supHandleResp.isSuccess()) {
                delSuc = true;
            } else {
                this.logger.error("\u4f9b\u65b9-{}\u5904\u7406\u4f5c\u5e9f\u5355\u636e-{}id-{}\u4f5c\u5e9f\u5931\u8d25, {}", new Object[]{supplierId, name, id, supHandleResp.getMsg()});
            }
        }
        catch (Exception e) {
            this.logger.error("\u901a\u77e5\u4f9b\u65b9\u5355\u636eid-{}\u4f5c\u5e9f\u5f02\u5e38\uff0c", (Object)id, (Object)e);
        }
        finally {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
            jedis.close();
        }
        return delSuc;
    }

    public String sendMsg(String[] channel, String[] receivers, String msgType, String subject, String content) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        ArrayList<String> user = new ArrayList<String>(Arrays.asList(receivers));
        Collections.replaceAll(user, "1247777316689256450", "303581417601122400");
        receivers = user.toArray(new String[user.size()]);
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setReceivers(receivers);
        parameter.setContent(content);
        parameter.setSubject(subject);
        parameter.setMsgType(msgType);
        parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
        parameter.setSaveFlag(true);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        parameter.setChannel(channel);
        this.logger.info("\u53d1\u9001\u4fe1\u606f{}", (Object)JSONObject.toJSONString((Object)parameter));
        CommonResponse result = this.pushMessageApi.pushMessage(parameter);
        if (!result.isSuccess()) {
            this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            return result.getMsg();
        }
        this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
        return "\u53d1\u9001\u6210\u529f\uff01";
    }

    public static String getCreateUserId(String userCode) {
        block8: {
            try {
                MetaDataUrlconstants urlconstants = (MetaDataUrlconstants)ContextUtil.getBean(MetaDataUrlconstants.class);
                if (!StringUtils.isNotBlank((CharSequence)userCode) || !StringUtils.isNotBlank((CharSequence)urlconstants.getBaseHost())) break block8;
                String cacheKey = "refer_cache_key:idm-employee:" + userCode;
                RedisTemplate redisTemplate = (RedisTemplate)ContextUtil.getBean((String)"redisTemplate", RedisTemplate.class);
                Object cacheValue = redisTemplate.opsForValue().get((Object)cacheKey);
                JSONObject jsonObject = null;
                if (cacheValue != null) {
                    jsonObject = JSON.parseObject((String)cacheValue.toString());
                } else {
                    String referData = PushSupUtil.getReferRestUrl("idm-employee");
                    JSONObject json = JSON.parseObject((String)referData);
                    String referUrl = json.get((Object)"projectName").toString();
                    Map<String, String> reflist = new HashMap();
                    reflist = (Map)json.get((Object)"refMapList");
                    reflist.put("userCode", userCode);
                    String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getAuditInfo";
                    String jsonbackstr = null;
                    try {
                        jsonbackstr = ReferHttpClientUtils.getAndHeader((String)url, reflist);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (StringUtils.isNotBlank((CharSequence)jsonbackstr)) {
                        jsonObject = JSON.parseObject((String)jsonbackstr);
                        redisTemplate.opsForValue().set((Object)cacheKey, (Object)jsonbackstr, 5L, TimeUnit.DAYS);
                    }
                }
                if (jsonObject != null) {
                    return jsonObject.getString("id");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return userCode;
    }

    private static String getReferRestUrl(String referCode) {
        String data = null;
        MetaDataUrlconstants urlconstants = (MetaDataUrlconstants)ContextUtil.getBean(MetaDataUrlconstants.class);
        String backData = null;
        try {
            backData = ReferHttpClientUtils.getAndHeader((String)(urlconstants.getMetaDataBaseUrl() + referCode), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONObject jsonobject = JSON.parseObject(backData);
        if (jsonobject.getString("code").equals("0")) {
            if (jsonobject.getString("data") != null) {
                data = JSON.parseObject((String)jsonobject.getString("data")).toJSONString();
            }
        } else {
            ExceptionUtil.wrappBusinessException((String)("\u53c2\u7167\u7f16\u7801" + referCode + "\u7684\u5b9e\u4f53\u6ca1\u6709\u53d1\u5e03\u5143\u6570\u636e!"));
        }
        return data;
    }
}

