/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rmat.bean.ArchivesEntity;
import com.ejianc.business.rmat.service.IArchivesService;
import com.ejianc.business.rmat.util.PageUtil;
import com.ejianc.business.rmat.vo.ArchivesVO;
import com.ejianc.business.rmat.vo.ArchivesVOS;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"archives"})
public class ArchivesController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IArchivesService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ArchivesVO>> saveOrUpdate(@RequestBody List<ArchivesVO> saveOrUpdateVO) {
        List<ArchivesVO> vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", vo);
    }

    @RequestMapping(value={"/saveCategory"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ArchivesVO>> saveCategory(@RequestBody List<ArchivesVO> saveOrUpdateVO) {
        List<ArchivesVO> vo = this.service.saveCategory(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ArchivesVO> queryDetail(Long id) {
        ArchivesEntity entity = (ArchivesEntity)((Object)this.service.selectById(id));
        ArchivesVO vo = (ArchivesVO)BeanMapper.map((Object)((Object)entity), ArchivesVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ArchivesVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ArchivesVO archivesVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ArchivesVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        if (param.getParams().size() != 0 && param.getParams().get("categoryId") != null) {
            param.getParams().put("categoryInnerCode", new Parameter("like", ((Parameter)param.getParams().get("categoryId")).getValue()));
            param.getParams().remove("categoryId");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ArchivesVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Archives-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refArchivesData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ArchivesVO>> refArchivesData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("materialTypeName");
        param.setPageSize(1);
        param.setPageIndex(-1);
        param.setSearchText(searchText);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter("eq", (Object)1));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        String materialTypeId = null;
        Long orgId1 = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            Map conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("materialTypeId")) {
                materialTypeId = conditionMap.get("materialTypeId").toString();
            }
            if (null != conditionMap.get("orgId")) {
                orgId1 = Long.valueOf(conditionMap.get("orgId").toString());
            }
        }
        Page page = new Page();
        CommonResponse orgVo = orgId1 != null ? this.iOrgApi.detailById(orgId1) : this.iOrgApi.detailById(InvocationInfoProxy.getOrgId());
        List orgIds = Arrays.stream(((OrgVO)orgVo.getData()).getInnerCode().split("\\|")).map(Long::parseLong).collect(Collectors.toList());
        Collections.reverse(orgIds);
        param.getParams().put("org_id", new Parameter("in", orgIds));
        if (materialTypeId != null) {
            param.getParams().put("material_type_id", new Parameter("eq", (Object)materialTypeId));
        }
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<ArchivesEntity> list = this.service.geMaterialDetail(wrapper);
        ArrayList<Long> materialIds = new ArrayList<Long>();
        List lists = BeanMapper.mapList(list, ArchivesVO.class);
        List<Object> archivesVOList = new ArrayList<ArchivesVO>();
        for (Long orgId : orgIds) {
            for (ArchivesVO vo : lists) {
                if (materialIds.contains(vo.getMaterialId()) || !orgId.equals(vo.getOrgId())) continue;
                archivesVOList.add(vo);
                materialIds.add(vo.getMaterialId());
            }
        }
        page.setCurrent((long)pageNumber.intValue());
        page.setSize((long)pageSize.intValue());
        page.setTotal((long)archivesVOList.size());
        archivesVOList = PageUtil.listToPage(archivesVOList, pageNumber, pageSize);
        page.setRecords(archivesVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/lazyMaterialCategory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialCategoryVO>> lazyMaterialCategory(Long parentId) {
        ArrayList<MaterialCategoryVO> materialCategoryVO;
        block5: {
            materialCategoryVO = new ArrayList<MaterialCategoryVO>();
            ArrayList<Long> list = new ArrayList<Long>();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getDr, (Object)0);
            queryWrapper.eq(ArchivesEntity::getOrgId, (Object)InvocationInfoProxy.getOrgId());
            queryWrapper.like(parentId != null, ArchivesEntity::getCategoryInnerCode, (Object)parentId);
            List archivesEntities = this.service.list((Wrapper)queryWrapper);
            if (!CollectionUtils.isNotEmpty((Collection)archivesEntities)) break block5;
            for (ArchivesEntity archivesEntity : archivesEntities) {
                list.add(archivesEntity.getMaterialTypeId());
            }
            CommonResponse materialCategoryVOS = this.materialApi.queryCategoryListByChildren(list);
            List dateList = (List)materialCategoryVOS.getData();
            if (parentId != null) {
                for (MaterialCategoryVO materialCategoryVO1 : dateList) {
                    if (materialCategoryVO1.getParentId() == null || !materialCategoryVO1.getParentId().equals(parentId)) continue;
                    materialCategoryVO.add(materialCategoryVO1);
                }
            } else {
                for (MaterialCategoryVO materialCategoryVO1 : dateList) {
                    if (materialCategoryVO1.getParentId() != null) continue;
                    materialCategoryVO.add(materialCategoryVO1);
                }
            }
        }
        return CommonResponse.success(materialCategoryVO);
    }

    @RequestMapping(value={"/turnSwitch"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> turnSwitch(@RequestBody Long id) {
        return CommonResponse.success((String)this.service.turnSwitch(id));
    }

    @RequestMapping(value={"/queryArchives"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ArchivesVO> queryArchives(@RequestBody ArchivesVO vo) {
        return CommonResponse.success((Object)this.service.queryArchives(vo));
    }

    @RequestMapping(value={"/queryByIds"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Map<Long, ArchivesVO>> queryByIds(@RequestBody ArchivesVO vo) {
        return CommonResponse.success(this.service.queryByIds(vo.getIds(), vo.getOrgId()));
    }

    @RequestMapping(value={"/queryIds"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<ArchivesVO>> queryIds(@RequestBody ArchivesVOS vos) {
        return CommonResponse.success(this.service.queryIds(vos));
    }
}

