/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.rmat.bean.ArchivesEntity;
import com.ejianc.business.rmat.mapper.ArchivesMapper;
import com.ejianc.business.rmat.service.IArchivesService;
import com.ejianc.business.rmat.vo.ArchivesVO;
import com.ejianc.business.rmat.vo.ArchivesVOS;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="archivesService")
public class ArchivesServiceImpl
extends BaseServiceImpl<ArchivesMapper, ArchivesEntity>
implements IArchivesService {
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;

    @Override
    public List<ArchivesVO> saveOrUpdate(List<ArchivesVO> vos) {
        CommonResponse orgVo = this.iOrgApi.detailById(InvocationInfoProxy.getOrgId());
        HashMap<Long, CommonResponse> map = new HashMap<Long, CommonResponse>();
        ArrayList<Long> categotyIds = new ArrayList<Long>();
        ArrayList<Long> materialIds = new ArrayList<Long>();
        List<Object> archivesVOS = new ArrayList<ArchivesVO>();
        ArrayList<ArchivesEntity> entityList = new ArrayList<ArchivesEntity>();
        List archivesEntityList = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"org_id", (Object)InvocationInfoProxy.getOrgId())).eq((Object)"id", (Object)vos.get(0).getId()));
        if (CollectionUtils.isNotEmpty((Collection)archivesEntityList)) {
            for (ArchivesVO saveOrUpdateVO : vos) {
                ArchivesEntity archivesEntity = (ArchivesEntity)((Object)this.selectById(saveOrUpdateVO.getId()));
                archivesEntity.setRealUnitId(saveOrUpdateVO.getRealUnitId());
                archivesEntity.setRealUnitName(saveOrUpdateVO.getRealUnitName());
                archivesEntity.setTransScale(saveOrUpdateVO.getTransScale());
                archivesEntity.setStatus(saveOrUpdateVO.getStatus());
                super.saveOrUpdate((Object)archivesEntity);
                archivesVOS.add((ArchivesVO)BeanMapper.map((Object)((Object)archivesEntity), ArchivesVO.class));
            }
        } else {
            Iterator<Object> iterator;
            for (ArchivesVO vo : vos) {
                materialIds.add(vo.getId());
                if (categotyIds.contains(vo.getCategoryId())) continue;
                CommonResponse materialCategoryVO = this.materialApi.queryCategoryById(vo.getCategoryId());
                map.put(vo.getCategoryId(), materialCategoryVO);
                categotyIds.add(vo.getCategoryId());
            }
            List list = this.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"material_id", materialIds)).eq((Object)"org_id", (Object)InvocationInfoProxy.getOrgId()));
            if (CollectionUtils.isNotEmpty((Collection)list) && (iterator = list.iterator()).hasNext()) {
                ArchivesEntity entity = (ArchivesEntity)((Object)iterator.next());
                throw new BusinessException("\u7f16\u53f7\u4e3a" + entity.getMaterialCode() + "\u7684\u7269\u8d44\u5df2\u88ab\u5f15\u7528\uff01");
            }
            for (ArchivesVO saveOrUpdateVO : vos) {
                saveOrUpdateVO.setCategoryInnerCode(((MaterialCategoryVO)((CommonResponse)map.get(saveOrUpdateVO.getCategoryId())).getData()).getInnerCode());
                saveOrUpdateVO.setMaterialTypeId(((MaterialCategoryVO)((CommonResponse)map.get(saveOrUpdateVO.getCategoryId())).getData()).getId());
                saveOrUpdateVO.setMaterialTypeName(((MaterialCategoryVO)((CommonResponse)map.get(saveOrUpdateVO.getCategoryId())).getData()).getName());
                saveOrUpdateVO.setOrgId(((OrgVO)orgVo.getData()).getId());
                saveOrUpdateVO.setOrgCode(((OrgVO)orgVo.getData()).getCode());
                saveOrUpdateVO.setOrgName(((OrgVO)orgVo.getData()).getName());
                saveOrUpdateVO.setOrgInnerCode(((OrgVO)orgVo.getData()).getInnerCode());
                saveOrUpdateVO.setMaterialId(saveOrUpdateVO.getId());
                saveOrUpdateVO.setMaterialCode(saveOrUpdateVO.getCode());
                saveOrUpdateVO.setMaterialName(saveOrUpdateVO.getName());
                saveOrUpdateVO.setMaterialSourceId(saveOrUpdateVO.getSourceId());
                saveOrUpdateVO.setUnitId(saveOrUpdateVO.getDef3());
                saveOrUpdateVO.setStatus(Integer.valueOf(1));
                saveOrUpdateVO.setRealUnitId(String.valueOf(IdWorker.getId()));
                saveOrUpdateVO.setRealUnitName(saveOrUpdateVO.getUnitName());
                saveOrUpdateVO.setTransScale(new BigDecimal(1));
                saveOrUpdateVO.setCreateUserName(saveOrUpdateVO.getCreateUserName());
                saveOrUpdateVO.setCreateTime(null);
                saveOrUpdateVO.setId(null);
                ArchivesEntity entity = (ArchivesEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ArchivesEntity.class));
                entityList.add(entity);
            }
        }
        if (CollectionUtils.isNotEmpty(entityList)) {
            super.saveOrUpdateBatch(entityList);
            archivesVOS = BeanMapper.mapList(entityList, ArchivesVO.class);
        }
        return archivesVOS;
    }

    @Override
    public List<ArchivesVO> saveCategory(List<ArchivesVO> saveOrUpdateVO) {
        List archivesVOList = new ArrayList();
        ArrayList<ArchivesVO> archivesVOS = new ArrayList<ArchivesVO>();
        for (ArchivesVO vo : saveOrUpdateVO) {
            String createUserName = vo.getCreateUserName();
            CommonResponse list = this.materialApi.queryMatListByLeafCtyId(vo.getId());
            if (!CollectionUtils.isNotEmpty((Collection)((Collection)list.getData()))) continue;
            archivesVOList = BeanMapper.mapList((Iterable)((Iterable)list.getData()), ArchivesVO.class);
            for (ArchivesVO archivesVO : archivesVOList) {
                archivesVO.setCreateUserName(createUserName);
                archivesVOS.add(archivesVO);
            }
        }
        return this.saveOrUpdate(archivesVOS);
    }

    @Override
    public String turnSwitch(Long id) {
        ArchivesEntity archivesEntity = (ArchivesEntity)((Object)this.selectById(id));
        if (archivesEntity.getStatus() == 0) {
            archivesEntity.setStatus(1);
            super.saveOrUpdate((Object)archivesEntity);
            return "\u542f\u7528\u6210\u529f\uff01";
        }
        archivesEntity.setStatus(0);
        super.saveOrUpdate((Object)archivesEntity);
        return "\u505c\u7528\u6210\u529f\uff01";
    }

    @Override
    public ArchivesVO queryArchives(ArchivesVO vo) {
        ArchivesVO archivesVO = new ArchivesVO();
        CommonResponse orgVo = this.iOrgApi.detailById(vo.getOrgId());
        Object[] orgInnerCode = ((OrgVO)orgVo.getData()).getInnerCode().split("\\|");
        ArrayList list = Lists.newArrayList((Object[])orgInnerCode);
        for (int i = list.size() - 1; i >= 0; --i) {
            Iterator iterator;
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(ArchivesEntity::getOrgId, list.get(i));
            query.eq(ArchivesEntity::getMaterialId, (Object)vo.getMaterialId());
            List archivesEntities = super.list((Wrapper)query);
            if (!CollectionUtils.isNotEmpty((Collection)archivesEntities) || !(iterator = archivesEntities.iterator()).hasNext()) continue;
            ArchivesEntity entity = (ArchivesEntity)((Object)iterator.next());
            archivesVO = (ArchivesVO)BeanMapper.map((Object)((Object)entity), ArchivesVO.class);
        }
        return archivesVO;
    }

    @Override
    public Map<Long, ArchivesVO> queryByIds(List<Long> ids, Long orgId) {
        HashMap<Long, ArchivesVO> voMap = new HashMap<Long, ArchivesVO>();
        CommonResponse orgVo = this.iOrgApi.detailById(orgId);
        List orgIds = Arrays.stream(((OrgVO)orgVo.getData()).getInnerCode().split("\\|")).map(Long::parseLong).collect(Collectors.toList());
        Collections.reverse(orgIds);
        List list = this.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"org_id", orgIds)).in((Object)"material_id", ids)).eq((Object)"status", (Object)1));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        Map map = BeanMapper.mapList((Iterable)list, ArchivesVO.class).stream().collect(Collectors.toMap(x -> x.getOrgId() + "|" + x.getMaterialId(), Function.identity()));
        ArrayList<String> joinIds = new ArrayList<String>();
        for (Long oid : orgIds) {
            for (Long id : ids) {
                String s = oid + "|" + id;
                joinIds.add(s);
            }
        }
        for (String joinId : joinIds) {
            Long key = Long.parseLong(joinId.split("\\|")[1]);
            if (voMap.containsKey(key) || !map.containsKey(joinId)) continue;
            voMap.put(key, (ArchivesVO)map.get(joinId));
        }
        return voMap;
    }

    @Override
    public List<ArchivesVO> queryIds(ArchivesVOS vos) {
        ArrayList<ArchivesVO> archivesVOList = new ArrayList<ArchivesVO>();
        CommonResponse orgVo = this.iOrgApi.detailById(vos.getOrgId());
        List orgIds = Arrays.stream(((OrgVO)orgVo.getData()).getInnerCode().split("\\|")).map(Long::parseLong).collect(Collectors.toList());
        Collections.reverse(orgIds);
        List list = new ArrayList();
        ArrayList<Long> ids = new ArrayList<Long>();
        switch (vos.getType()) {
            case 0: {
                list = this.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"org_id", orgIds)).in((Object)"material_id", (Collection)vos.getMaterialIds())).eq((Object)"status", (Object)1));
                break;
            }
            case 1: {
                list = this.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"org_id", orgIds)).in((Object)"material_type_id", (Collection)vos.getCategoryIds())).eq((Object)"status", (Object)1));
            }
        }
        for (Long orgId : orgIds) {
            for (ArchivesEntity entity : list) {
                if (ids.contains(entity.getMaterialId()) || !entity.getOrgId().equals(orgId)) continue;
                archivesVOList.add((ArchivesVO)BeanMapper.map((Object)((Object)entity), ArchivesVO.class));
                ids.add(entity.getMaterialId());
            }
        }
        return archivesVOList;
    }

    @Override
    public List<ArchivesEntity> geMaterialDetail(QueryWrapper queryWrapper) {
        List<ArchivesEntity> list = ((ArchivesMapper)this.baseMapper).geMaterialDetail(queryWrapper);
        return list;
    }
}

