/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.bean.RmatFlowEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.MaterialStateEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.mapper.MaterialMapper;
import com.ejianc.business.rmat.service.ICalculateService;
import com.ejianc.business.rmat.service.IManageSetService;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.vo.ManageSetVO;
import com.ejianc.business.rmat.vo.MaterialFlowVO;
import com.ejianc.business.rmat.vo.MaterialVO;
import com.ejianc.business.rmat.vo.MaxTimeVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialService")
public class MaterialServiceImpl
extends BaseServiceImpl<MaterialMapper, RmatFlowEntity>
implements IMaterialService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICalculateService rentService;
    @Autowired
    private IRmatFlowService flowService;
    @Autowired
    private IManageSetService manageSetService;

    @Override
    public List<MaterialVO> queryCheckList(QueryParam param, String type) {
        MaterialVO vo;
        int i;
        if ("report".equals(type)) {
            param.getFuzzyFields().add("contractName");
            param.getFuzzyFields().add("supplierName");
            param.getFuzzyFields().add("billCode");
        }
        param.getFuzzyFields().add("materilCode");
        param.getFuzzyFields().add("materilName");
        param.getFuzzyFields().add("spec");
        List flowList = this.flowService.queryList(param, false);
        ArrayList<RmatFlowEntity> checkList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> startList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> stopList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> restList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> loseList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> tempRestList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> tempLoseList = new ArrayList<RmatFlowEntity>();
        for (RmatFlowEntity flow : flowList) {
            if (RmatCommonConsts.YES.equals(flow.getEffectiveState())) {
                if (BillTypeEnum.\u9a8c\u6536\u5355.getCode().equals(flow.getBillTypeCode())) {
                    checkList.add(flow);
                }
                if (BillTypeEnum.\u505c\u7528\u5355.getCode().equals(flow.getBillTypeCode())) {
                    stopList.add(flow);
                }
                if (BillTypeEnum.\u542f\u7528\u5355.getCode().equals(flow.getBillTypeCode())) {
                    startList.add(flow);
                }
                if (BillTypeEnum.\u9000\u573a\u5355.getCode().equals(flow.getBillTypeCode())) {
                    restList.add(flow);
                }
                if (BillTypeEnum.\u8d54\u507f\u5355.getCode().equals(flow.getBillTypeCode())) {
                    loseList.add(flow);
                }
            }
            if (!RmatCommonConsts.NO.equals(flow.getEffectiveState())) continue;
            if (BillTypeEnum.\u9000\u573a\u5355.getCode().equals(flow.getBillTypeCode())) {
                tempRestList.add(flow);
            }
            if (!BillTypeEnum.\u8d54\u507f\u5355.getCode().equals(flow.getBillTypeCode())) continue;
            tempLoseList.add(flow);
        }
        HashMap<String, MaterialVO> map = new HashMap<String, MaterialVO>();
        String key = null;
        for (RmatFlowEntity detail : checkList) {
            for (i = 0; i < 2; ++i) {
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + i + "|" + detail.getRentTransScale();
                vo = new MaterialVO();
                if (!map.containsKey(key)) {
                    vo.setId(key);
                    this.transferVO(detail, vo);
                    vo.setUseStatus(String.valueOf(i));
                } else {
                    vo = (MaterialVO)map.get(key);
                }
                vo.setCheckedNum(ComputeUtil.safeAdd((BigDecimal)vo.getCheckedNum(), (BigDecimal)detail.getNum()));
                vo.setStartedNum(ComputeUtil.safeAdd((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getNum()));
                if (i == 1) {
                    this.collectNum(detail, vo, true);
                }
                map.put(key, vo);
            }
        }
        for (RmatFlowEntity detail : startList) {
            for (i = 0; i < 2; ++i) {
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + i + "|" + detail.getRentTransScale();
                if (!map.containsKey(key)) continue;
                vo = (MaterialVO)map.get(key);
                if (i == 0) {
                    vo.setStopedNum(ComputeUtil.safeSub((BigDecimal)vo.getStopedNum(), (BigDecimal)detail.getNum()));
                    this.collectNum(detail, vo, false);
                    continue;
                }
                vo.setStartedNum(ComputeUtil.safeAdd((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getNum()));
                this.collectNum(detail, vo, true);
            }
        }
        for (RmatFlowEntity detail : stopList) {
            for (i = 0; i < 2; ++i) {
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + i + "|" + detail.getRentTransScale();
                if (!map.containsKey(key)) continue;
                vo = (MaterialVO)map.get(key);
                if (i == 0) {
                    vo.setStopedNum(ComputeUtil.safeAdd((BigDecimal)vo.getStopedNum(), (BigDecimal)detail.getNum()));
                    this.collectNum(detail, vo, true);
                    continue;
                }
                vo.setStartedNum(ComputeUtil.safeSub((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getNum()));
                this.collectNum(detail, vo, false);
            }
        }
        for (RmatFlowEntity detail : restList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getUseStatus() + "|" + detail.getRentTransScale();
            if (!map.containsKey(key)) continue;
            MaterialVO vo2 = (MaterialVO)map.get(key);
            vo2.setRestitutedNum(ComputeUtil.safeAdd((BigDecimal)vo2.getRestitutedNum(), (BigDecimal)detail.getNum()));
            this.collectNum(detail, vo2, false);
        }
        for (RmatFlowEntity detail : loseList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getUseStatus() + "|" + detail.getRentTransScale();
            if (!map.containsKey(key)) continue;
            MaterialVO vo3 = (MaterialVO)map.get(key);
            vo3.setLosedNum(ComputeUtil.safeAdd((BigDecimal)vo3.getLosedNum(), (BigDecimal)detail.getNum()));
            this.collectNum(detail, vo3, false);
        }
        for (RmatFlowEntity detail : tempRestList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getUseStatus() + "|" + detail.getRentTransScale();
            if (!map.containsKey(key)) continue;
            MaterialVO vo4 = (MaterialVO)map.get(key);
            vo4.setTempRestNum(ComputeUtil.safeAdd((BigDecimal)vo4.getTempRestNum(), (BigDecimal)detail.getNum()));
            if (!"lose".equals(type)) continue;
            this.collectNum(detail, vo4, false);
        }
        for (RmatFlowEntity detail : tempLoseList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getUseStatus() + "|" + detail.getRentTransScale();
            if (!map.containsKey(key)) continue;
            MaterialVO vo5 = (MaterialVO)map.get(key);
            vo5.setTempLoseNum(ComputeUtil.safeAdd((BigDecimal)vo5.getTempLoseNum(), (BigDecimal)detail.getNum()));
            if (!"rest".equals(type)) continue;
            this.collectNum(detail, vo5, false);
        }
        Iterator it = map.values().iterator();
        block27: while (it.hasNext()) {
            MaterialVO vo6 = (MaterialVO)it.next();
            switch (type) {
                case "start": {
                    if ("1".equals(vo6.getUseStatus())) {
                        it.remove();
                        continue block27;
                    }
                    vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStopedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum()}));
                    break;
                }
                case "stop": {
                    if ("0".equals(vo6.getUseStatus())) {
                        it.remove();
                        continue block27;
                    }
                    vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStartedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum()}));
                    break;
                }
                case "rest": {
                    if ("0".equals(vo6.getUseStatus())) {
                        vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStopedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum(), vo6.getTempLoseNum()}));
                    }
                    if (!"1".equals(vo6.getUseStatus())) break;
                    vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStartedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum(), vo6.getTempLoseNum()}));
                    break;
                }
                case "lose": {
                    if ("0".equals(vo6.getUseStatus())) {
                        vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStopedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum(), vo6.getTempRestNum()}));
                    }
                    if (!"1".equals(vo6.getUseStatus())) break;
                    vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStartedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum(), vo6.getTempRestNum()}));
                    break;
                }
                case "report": {
                    if ("0".equals(vo6.getUseStatus())) {
                        vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStopedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum()}));
                    }
                    if (!"1".equals(vo6.getUseStatus())) break;
                    vo6.setRefNum(ComputeUtil.safeSub((BigDecimal)vo6.getStartedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum()}));
                    break;
                }
                case "restNoUse": {
                    BigDecimal refNum;
                    if ("0".equals(vo6.getUseStatus())) {
                        refNum = ComputeUtil.safeSub((BigDecimal)vo6.getStopedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum(), vo6.getTempLoseNum()});
                        key = vo6.getContractId() + "|" + vo6.getMaterialId() + "|" + 1 + "|" + vo6.getRentTransScale();
                        if (map.containsKey(key)) {
                            MaterialVO data = (MaterialVO)map.get(key);
                            data.setRefNum(ComputeUtil.safeAdd((BigDecimal)data.getRefNum(), (BigDecimal)refNum));
                        }
                        it.remove();
                        continue block27;
                    }
                    if (!"1".equals(vo6.getUseStatus())) break;
                    refNum = ComputeUtil.safeSub((BigDecimal)vo6.getStartedNum(), (BigDecimal[])new BigDecimal[]{vo6.getRestitutedNum(), vo6.getLosedNum(), vo6.getTempLoseNum()});
                    vo6.setRefNum(ComputeUtil.safeAdd((BigDecimal)vo6.getRefNum(), (BigDecimal)refNum));
                    vo6.setUseStatus(null);
                    break;
                }
            }
            vo6.setNumM(vo6.getRefNum());
            if (!"report".equals(type)) {
                vo6.setRefNum(vo6.getRentNum());
            }
            if (vo6.getRefNum() != null && vo6.getRefNum().compareTo(BigDecimal.ZERO) > 0) continue;
            it.remove();
        }
        return new ArrayList<MaterialVO>(map.values());
    }

    @Override
    public List<MaterialVO> queryRmatList(QueryParam param) {
        MaterialVO vo;
        int i;
        param.getFuzzyFields().add("materilCode");
        param.getFuzzyFields().add("materilName");
        param.getFuzzyFields().add("spec");
        List flowList = this.flowService.queryList(param, false);
        ArrayList<RmatFlowEntity> checkList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> startList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> stopList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> restList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> loseList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> tempLoseList = new ArrayList<RmatFlowEntity>();
        for (RmatFlowEntity flow : flowList) {
            if (RmatCommonConsts.YES.equals(flow.getEffectiveState())) {
                if (BillTypeEnum.\u9a8c\u6536\u5355.getCode().equals(flow.getBillTypeCode())) {
                    checkList.add(flow);
                }
                if (BillTypeEnum.\u505c\u7528\u5355.getCode().equals(flow.getBillTypeCode())) {
                    stopList.add(flow);
                }
                if (BillTypeEnum.\u542f\u7528\u5355.getCode().equals(flow.getBillTypeCode())) {
                    startList.add(flow);
                }
                if (BillTypeEnum.\u9000\u573a\u5355.getCode().equals(flow.getBillTypeCode())) {
                    restList.add(flow);
                }
                if (BillTypeEnum.\u8d54\u507f\u5355.getCode().equals(flow.getBillTypeCode())) {
                    loseList.add(flow);
                }
            }
            if (!RmatCommonConsts.NO.equals(flow.getEffectiveState()) || !BillTypeEnum.\u8d54\u507f\u5355.getCode().equals(flow.getBillTypeCode())) continue;
            tempLoseList.add(flow);
        }
        HashMap<String, MaterialVO> map = new HashMap<String, MaterialVO>();
        String key = null;
        for (RmatFlowEntity detail : checkList) {
            for (i = 0; i < 2; ++i) {
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + i + "|" + detail.getRentTransScale();
                vo = new MaterialVO();
                if (!map.containsKey(key)) {
                    vo.setId(key);
                    this.transferVO(detail, vo);
                    vo.setUseStatus(String.valueOf(i));
                } else {
                    vo = (MaterialVO)map.get(key);
                }
                vo.setCheckedNum(ComputeUtil.safeAdd((BigDecimal)vo.getCheckedNum(), (BigDecimal)detail.getNum()));
                vo.setStartedNum(ComputeUtil.safeAdd((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getNum()));
                if (i == 1) {
                    this.collectNum(detail, vo, true);
                }
                map.put(key, vo);
            }
        }
        for (RmatFlowEntity detail : startList) {
            for (i = 0; i < 2; ++i) {
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + i + "|" + detail.getRentTransScale();
                if (!map.containsKey(key)) continue;
                vo = (MaterialVO)map.get(key);
                if (i == 0) {
                    vo.setStopedNum(ComputeUtil.safeSub((BigDecimal)vo.getStopedNum(), (BigDecimal)detail.getNum()));
                    this.collectNum(detail, vo, false);
                    continue;
                }
                vo.setStartedNum(ComputeUtil.safeAdd((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getNum()));
                this.collectNum(detail, vo, true);
            }
        }
        for (RmatFlowEntity detail : stopList) {
            for (i = 0; i < 2; ++i) {
                key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + i + "|" + detail.getRentTransScale();
                if (!map.containsKey(key)) continue;
                vo = (MaterialVO)map.get(key);
                if (i == 0) {
                    vo.setStopedNum(ComputeUtil.safeAdd((BigDecimal)vo.getStopedNum(), (BigDecimal)detail.getNum()));
                    this.collectNum(detail, vo, true);
                    continue;
                }
                vo.setStartedNum(ComputeUtil.safeSub((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getNum()));
                this.collectNum(detail, vo, false);
            }
        }
        for (RmatFlowEntity detail : restList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getUseStatus() + "|" + detail.getRentTransScale();
            MaterialVO vo2 = new MaterialVO();
            if (!map.containsKey(key)) {
                vo2.setId(key);
                this.transferVO(detail, vo2);
                vo2.setUseStatus(detail.getUseStatus());
                vo2.setSignRowType(RmatCommonConsts.ONE);
                vo2.setExitAdd(Boolean.valueOf(true));
            } else {
                vo2 = (MaterialVO)map.get(key);
            }
            vo2.setRestitutedNum(ComputeUtil.safeAdd((BigDecimal)vo2.getRestitutedNum(), (BigDecimal)detail.getNum()));
            this.collectNum(detail, vo2, false);
            map.put(key, vo2);
        }
        for (RmatFlowEntity detail : loseList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getUseStatus() + "|" + detail.getRentTransScale();
            if (!map.containsKey(key)) continue;
            MaterialVO vo3 = (MaterialVO)map.get(key);
            vo3.setLosedNum(ComputeUtil.safeAdd((BigDecimal)vo3.getLosedNum(), (BigDecimal)detail.getNum()));
            this.collectNum(detail, vo3, false);
        }
        for (RmatFlowEntity detail : tempLoseList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getUseStatus() + "|" + detail.getRentTransScale();
            if (!map.containsKey(key)) continue;
            MaterialVO vo4 = (MaterialVO)map.get(key);
            vo4.setTempLoseNum(ComputeUtil.safeAdd((BigDecimal)vo4.getTempLoseNum(), (BigDecimal)detail.getNum()));
            this.collectNum(detail, vo4, false);
        }
        Iterator it = map.values().iterator();
        while (it.hasNext()) {
            MaterialVO vo5 = (MaterialVO)it.next();
            if ("0".equals(vo5.getUseStatus())) {
                vo5.setRefNum(ComputeUtil.safeSub((BigDecimal)vo5.getStopedNum(), (BigDecimal[])new BigDecimal[]{vo5.getRestitutedNum(), vo5.getLosedNum(), vo5.getTempLoseNum()}));
            }
            if ("1".equals(vo5.getUseStatus())) {
                vo5.setRefNum(ComputeUtil.safeSub((BigDecimal)vo5.getStartedNum(), (BigDecimal[])new BigDecimal[]{vo5.getRestitutedNum(), vo5.getLosedNum(), vo5.getTempLoseNum()}));
            }
            vo5.setNumM(vo5.getRefNum());
            vo5.setRefNum(vo5.getRentNum());
            if (vo5.getExitAdd().booleanValue() || vo5.getRefNum() != null && vo5.getRefNum().compareTo(BigDecimal.ZERO) > 0) continue;
            it.remove();
        }
        List<MaterialVO> refList = new ArrayList<MaterialVO>(map.values());
        refList = this.getResultList(refList);
        return refList;
    }

    private List<MaterialVO> getResultList(List<MaterialVO> refList) {
        List<ManageSetVO> vos = new ArrayList<ManageSetVO>();
        for (MaterialVO ref : refList) {
            ManageSetVO vo = new ManageSetVO();
            vo.setOrgId(ref.getOrgId());
            vo.setMaterialTypeId(ref.getMaterialTypeId());
            vos.add(vo);
        }
        if (CollectionUtils.isNotEmpty(vos)) {
            vos = this.manageSetService.queryManageSet(vos);
        }
        Set materialTypeIds = vos.stream().map(ManageSetVO::getMaterialTypeId).collect(Collectors.toSet());
        HashMap<String, MaterialVO> result = new HashMap<String, MaterialVO>();
        for (MaterialVO vo : refList) {
            String parentId = vo.getContractId() + "|" + vo.getMaterialTypeId() + "|" + vo.getRentUnitId();
            if (RmatCommonConsts.ONE.equals(vo.getSignRowType()) && materialTypeIds.contains(vo.getMaterialTypeId())) {
                MaterialVO parent = new MaterialVO();
                List<MaterialVO> children = new ArrayList();
                List flowList = new ArrayList();
                if (result.containsKey(parentId)) {
                    parent = (MaterialVO)result.get(parentId);
                    children = parent.getChildren();
                    flowList = parent.getFlowList();
                } else {
                    parent.setId(parentId);
                    parent.setMaterialTypeId(vo.getMaterialTypeId());
                    parent.setMaterialTypeName(vo.getMaterialTypeName());
                    parent.setRentUnitId(vo.getRentUnitId());
                    parent.setRentUnitName(vo.getRentUnitName());
                    parent.setRentTransScale(vo.getRentTransScale());
                    parent.setRealUnitId(vo.getRealUnitId());
                    parent.setRealUnitName(vo.getRealUnitName());
                    parent.setRealTransScale(vo.getRealTransScale());
                    parent.setUnitId(vo.getUnitId());
                    parent.setUnitName(vo.getUnitName());
                    parent.setInfoId(vo.getInfoId());
                }
                parent.setRefNum(ComputeUtil.safeAdd((BigDecimal)parent.getRefNum(), (BigDecimal)vo.getRefNum()));
                parent.setNumM(ComputeUtil.safeAdd((BigDecimal)parent.getNumM(), (BigDecimal)vo.getNumM()));
                parent.setNum(ComputeUtil.safeAdd((BigDecimal)parent.getNum(), (BigDecimal)vo.getNum()));
                parent.setRealNum(ComputeUtil.safeAdd((BigDecimal)parent.getRealNum(), (BigDecimal)vo.getRealNum()));
                parent.setRentNum(ComputeUtil.safeAdd((BigDecimal)parent.getRentNum(), (BigDecimal)vo.getRentNum()));
                vo.setParentId(parentId);
                children.add(vo);
                parent.setChildren(children);
                if (CollectionUtils.isNotEmpty((Collection)vo.getFlowList())) {
                    flowList.addAll(vo.getFlowList());
                }
                parent.setFlowList(flowList);
                result.put(parentId, parent);
                continue;
            }
            result.put(vo.getId(), vo);
        }
        return new ArrayList<MaterialVO>(result.values());
    }

    private void collectNum(RmatFlowEntity detail, MaterialVO vo, Boolean add) {
        if (add.booleanValue()) {
            vo.setNum(ComputeUtil.safeAdd((BigDecimal)vo.getNum(), (BigDecimal)detail.getNum()));
            vo.setRealNum(ComputeUtil.safeAdd((BigDecimal)vo.getRealNum(), (BigDecimal)detail.getRealNum()));
            vo.setRentNum(ComputeUtil.safeAdd((BigDecimal)vo.getRentNum(), (BigDecimal)detail.getRentNum()));
        } else {
            vo.setNum(ComputeUtil.safeSub((BigDecimal)vo.getNum(), (BigDecimal)detail.getNum()));
            vo.setRealNum(ComputeUtil.safeSub((BigDecimal)vo.getRealNum(), (BigDecimal)detail.getRealNum()));
            vo.setRentNum(ComputeUtil.safeSub((BigDecimal)vo.getRentNum(), (BigDecimal)detail.getRentNum()));
        }
    }

    @Override
    public List<MaterialVO> queryCalculateList(String contractId, Date startDate, Date endDate) {
        Date date;
        MaterialVO vo;
        ExecutorService threadPool = Executors.newFixedThreadPool(7);
        QueryParam param = new QueryParam();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getOrderMap().put("createTime", "asc");
        Parameter parameter = new Parameter("le", (Object)DateUtil.formatSeconds(endDate));
        param.getParams().put("billDate", parameter);
        List rmatFlowList = this.flowService.queryList(param, false);
        ArrayList<RmatFlowEntity> checkList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> startList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> stopList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> restList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> loseList = new ArrayList<RmatFlowEntity>();
        for (RmatFlowEntity flow : rmatFlowList) {
            if (!RmatCommonConsts.YES.equals(flow.getEffectiveState())) continue;
            if (BillTypeEnum.\u9a8c\u6536\u5355.getCode().equals(flow.getBillTypeCode())) {
                checkList.add(flow);
            }
            if (BillTypeEnum.\u505c\u7528\u5355.getCode().equals(flow.getBillTypeCode())) {
                stopList.add(flow);
            }
            if (BillTypeEnum.\u542f\u7528\u5355.getCode().equals(flow.getBillTypeCode())) {
                startList.add(flow);
            }
            if (BillTypeEnum.\u9000\u573a\u5355.getCode().equals(flow.getBillTypeCode())) {
                restList.add(flow);
            }
            if (!BillTypeEnum.\u8d54\u507f\u5355.getCode().equals(flow.getBillTypeCode())) continue;
            loseList.add(flow);
        }
        HashMap<String, MaterialVO> map = new HashMap<String, MaterialVO>();
        String key = null;
        HashMap<Date, List<Date>> dateMap = new HashMap<Date, List<Date>>();
        HashMap<Date, List<Date>> cdateMap = new HashMap<Date, List<Date>>();
        for (RmatFlowEntity detail : checkList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentTransScale();
            vo = new MaterialVO();
            if (!map.containsKey(key)) {
                vo.setId(key);
                this.transferVO(detail, vo);
            } else {
                vo = (MaterialVO)map.get(key);
            }
            vo.setUseStatus("1");
            date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if (startDate != null && DateUtil.compareDate(startDate, date) > 0) {
                vo.setCheckedNum(ComputeUtil.safeAdd((BigDecimal)vo.getCheckedNum(), (BigDecimal)detail.getRentNum()));
                vo.setStartedNum(ComputeUtil.safeAdd((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getRentNum()));
            } else {
                this.addFlowVO(vo, MaterialStateEnum.\u542f\u7528, date, detail.getId(), detail.getRentNum());
            }
            map.put(key, vo);
        }
        for (RmatFlowEntity detail : startList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentTransScale();
            vo = new MaterialVO();
            if (!map.containsKey(key)) {
                vo.setId(key);
                this.transferVO(detail, vo);
            } else {
                vo = (MaterialVO)map.get(key);
            }
            vo.setUseStatus("1");
            date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if (startDate != null && DateUtil.compareDate(startDate, date) > 0) {
                vo.setStopedNum(ComputeUtil.safeSub((BigDecimal)vo.getStopedNum(), (BigDecimal)detail.getRentNum()));
                vo.setStartedNum(ComputeUtil.safeAdd((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getRentNum()));
            } else {
                this.addFlowVO(vo, MaterialStateEnum.\u542f\u7528, date, detail.getId(), detail.getRentNum());
            }
            map.put(key, vo);
        }
        for (RmatFlowEntity detail : stopList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentTransScale();
            vo = new MaterialVO();
            if (!map.containsKey(key)) {
                vo.setId(key);
                this.transferVO(detail, vo);
            } else {
                vo = (MaterialVO)map.get(key);
            }
            vo.setUseStatus("0");
            date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if (startDate != null && DateUtil.compareDate(startDate, date) > 0) {
                vo.setStopedNum(ComputeUtil.safeAdd((BigDecimal)vo.getStopedNum(), (BigDecimal)detail.getRentNum()));
                vo.setStartedNum(ComputeUtil.safeSub((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getRentNum()));
            } else {
                this.addFlowVO(vo, MaterialStateEnum.\u505c\u7528, date, detail.getId(), detail.getRentNum());
            }
            map.put(key, vo);
        }
        for (RmatFlowEntity detail : restList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentTransScale();
            vo = new MaterialVO();
            if (!map.containsKey(key)) {
                vo.setId(key);
                this.transferVO(detail, vo);
                vo.setUseStatus(detail.getUseStatus());
                vo.setSignRowType(RmatCommonConsts.ONE);
                vo.setExitAdd(Boolean.valueOf(true));
            } else {
                vo = (MaterialVO)map.get(key);
            }
            vo.setUseStatus(detail.getUseStatus());
            date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if (startDate != null && DateUtil.compareDate(startDate, date) > 0) {
                vo.setRestitutedNum(ComputeUtil.safeAdd((BigDecimal)vo.getRestitutedNum(), (BigDecimal)detail.getRentNum()));
                if ("0".equals(vo.getUseStatus())) {
                    vo.setStopedNum(ComputeUtil.safeSub((BigDecimal)vo.getStopedNum(), (BigDecimal)detail.getRentNum()));
                }
                if ("1".equals(vo.getUseStatus())) {
                    vo.setStartedNum(ComputeUtil.safeSub((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getRentNum()));
                }
            } else {
                this.addFlowVO(vo, MaterialStateEnum.\u9000\u573a, date, detail.getId(), detail.getRentNum());
            }
            map.put(key, vo);
        }
        for (RmatFlowEntity detail : loseList) {
            key = detail.getContractId() + "|" + detail.getMaterialId() + "|" + detail.getRentTransScale();
            if (!map.containsKey(key)) continue;
            vo = (MaterialVO)map.get(key);
            vo.setUseStatus(detail.getUseStatus());
            date = this.getMaxDate(dateMap, cdateMap, detail.getDetailDate(), detail.getCreateTime());
            if (startDate != null && DateUtil.compareDate(startDate, date) > 0) {
                vo.setLosedNum(ComputeUtil.safeAdd((BigDecimal)vo.getLosedNum(), (BigDecimal)detail.getRentNum()));
                if ("0".equals(vo.getUseStatus())) {
                    vo.setStopedNum(ComputeUtil.safeSub((BigDecimal)vo.getStopedNum(), (BigDecimal)detail.getRentNum()));
                }
                if (!"1".equals(vo.getUseStatus())) continue;
                vo.setStartedNum(ComputeUtil.safeSub((BigDecimal)vo.getStartedNum(), (BigDecimal)detail.getRentNum()));
                continue;
            }
            this.addFlowVO(vo, MaterialStateEnum.\u9000\u573a, date, detail.getId(), detail.getRentNum());
        }
        for (String keys : map.keySet()) {
            List flowList;
            vo = (MaterialVO)map.get(keys);
            if ("0".equals(vo.getUseStatus())) {
                vo.setRefNum(vo.getStopedNum());
            }
            if ("1".equals(vo.getUseStatus())) {
                vo.setRefNum(vo.getStartedNum());
            }
            if (ComputeUtil.isGreaterThan((BigDecimal)vo.getStopedNum(), (BigDecimal)BigDecimal.ZERO)) {
                vo.setUseStatus("0");
                this.addBeginVO(vo, MaterialStateEnum.\u505c\u7528, startDate, IdWorker.getId(), vo.getStopedNum());
            }
            if (ComputeUtil.isGreaterThan((BigDecimal)vo.getStartedNum(), (BigDecimal)BigDecimal.ZERO)) {
                vo.setUseStatus("1");
                this.addBeginVO(vo, MaterialStateEnum.\u542f\u7528, startDate, IdWorker.getId(), vo.getStartedNum());
            }
            if (CollectionUtils.isNotEmpty((Collection)(flowList = vo.getFlowList()))) {
                flowList.sort(Comparator.comparing(MaterialFlowVO::getOperationDate));
            }
            vo.setFlowList(flowList);
        }
        List<MaterialVO> refList = new ArrayList<MaterialVO>(map.values());
        refList = this.getResultList(refList);
        return refList;
    }

    private Date getMaxDate(Map<Date, List<Date>> dateMap, Map<Date, List<Date>> cdateMap, Date billDate, Date createTime) {
        Date date = DateUtil.concatDate(billDate, createTime);
        List<Object> list = new ArrayList<Date>();
        List<Object> clist = new ArrayList<Date>();
        Date day = DateUtil.parseDate(DateUtil.formatSeconds(date).substring(0, 10));
        if (dateMap.containsKey(day)) {
            list = dateMap.get(day);
            Date maxDate = list.stream().max(Comparator.comparing(x -> x)).orElse(null);
            clist = cdateMap.get(day);
            Date cmaxDate = clist.stream().max(Comparator.comparing(x -> x)).orElse(null);
            if (DateUtil.compareDate(date, maxDate) < 0 && DateUtil.compareDate(createTime, cmaxDate) > 0 && DateUtil.compareDate(date = DateUtil.addSeconds(maxDate, 1), DateUtil.endOfDate(date)) > 0) {
                date = DateUtil.endOfDate(date);
            }
        }
        list.add(date);
        dateMap.put(day, list);
        clist.add(createTime);
        cdateMap.put(day, clist);
        return date;
    }

    private void addFlowVO(MaterialVO vo, MaterialStateEnum stateEnum, Date date, Long id, BigDecimal num) {
        MaterialFlowVO flowVO = new MaterialFlowVO();
        flowVO.setParameterId(vo.getId());
        flowVO.setMaterialState(stateEnum.getCode());
        flowVO.setOperationDate(date);
        flowVO.setSourceId(id);
        flowVO.setSourceType(stateEnum.getDescription());
        flowVO.setNum(num);
        flowVO.setUseStatus(vo.getUseStatus());
        flowVO.setStopedNum(vo.getStopedNum());
        flowVO.setStartedNum(vo.getStartedNum());
        flowVO.setId(id);
        List flowList = vo.getFlowList() != null ? vo.getFlowList() : new ArrayList();
        flowList.add(flowVO);
        vo.setFlowList(flowList);
    }

    private void addBeginVO(MaterialVO vo, MaterialStateEnum stateEnum, Date date, Long id, BigDecimal num) {
        MaterialFlowVO flowVO = new MaterialFlowVO();
        flowVO.setParameterId(vo.getId());
        flowVO.setMaterialState(stateEnum.getCode());
        flowVO.setOperationDate(date);
        flowVO.setSourceId(id);
        flowVO.setSourceType(stateEnum.getDescription());
        flowVO.setNum(num);
        flowVO.setUseStatus(vo.getUseStatus());
        flowVO.setId(id);
        flowVO.setStopedNum(vo.getStopedNum());
        flowVO.setStartedNum(vo.getStartedNum());
        List beginList = vo.getBeginList() != null ? vo.getBeginList() : new ArrayList();
        beginList.add(flowVO);
        vo.setBeginList(beginList);
    }

    private void transferVO(RmatFlowEntity detail, MaterialVO vo) {
        vo.setContractId(detail.getContractId());
        vo.setContractCode(detail.getContractCode());
        vo.setContractName(detail.getContractName());
        vo.setOrgId(detail.getOrgId());
        vo.setOrgName(detail.getOrgName());
        vo.setSupplierId(detail.getSupplierId());
        vo.setSupplierName(detail.getSupplierName());
        vo.setInfoId(detail.getInfoId());
        vo.setMaterialTypeId(detail.getMaterialTypeId());
        vo.setMaterialTypeName(detail.getMaterialTypeName());
        vo.setMaterialId(detail.getMaterialId());
        vo.setMaterialCode(detail.getMaterialCode());
        vo.setMaterialName(detail.getMaterialName());
        vo.setMaterialSourceId(detail.getMaterialSourceId());
        vo.setSpec(detail.getSpec());
        vo.setUnitId(detail.getUnitId());
        vo.setUnitName(detail.getUnitName());
        vo.setRealUnitId(detail.getRealUnitId());
        vo.setRealUnitName(detail.getRealUnitName());
        vo.setRealTransScale(detail.getRealTransScale());
        vo.setRentUnitId(detail.getRentUnitId());
        vo.setRentUnitName(detail.getRentUnitName());
        vo.setRentTransScale(detail.getRentTransScale());
        vo.setSignRowType(detail.getSignRowType());
        vo.setExitAdd(Boolean.valueOf(false));
    }

    @Override
    public String validateContract(String contractId, String billType, Long billId, String type) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        if ("\u79df\u91d1\u8ba1\u7b97\u5355".equals(billType) && billId != null) {
            param.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        List rentList = this.rentService.queryList(param, false);
        QueryParam param2 = new QueryParam();
        param2.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param2.getParams().put("effectiveState", new Parameter("eq", (Object)RmatCommonConsts.NO));
        if (!"\u79df\u91d1\u8ba1\u7b97\u5355".equals(billType) && billId != null) {
            param.getParams().put("sourceId", new Parameter("ne", (Object)billId));
        }
        List flowList = this.flowService.queryList(param2, false);
        ArrayList<RmatFlowEntity> checkList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> startList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> stopList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> restList = new ArrayList<RmatFlowEntity>();
        ArrayList<RmatFlowEntity> loseList = new ArrayList<RmatFlowEntity>();
        for (RmatFlowEntity flow : flowList) {
            if (!RmatCommonConsts.YES.equals(flow.getEffectiveState())) continue;
            if (BillTypeEnum.\u9a8c\u6536\u5355.getCode().equals(flow.getBillTypeCode())) {
                checkList.add(flow);
            }
            if (BillTypeEnum.\u505c\u7528\u5355.getCode().equals(flow.getBillTypeCode())) {
                stopList.add(flow);
            }
            if (BillTypeEnum.\u542f\u7528\u5355.getCode().equals(flow.getBillTypeCode())) {
                startList.add(flow);
            }
            if (BillTypeEnum.\u9000\u573a\u5355.getCode().equals(flow.getBillTypeCode())) {
                restList.add(flow);
            }
            if (!BillTypeEnum.\u8d54\u507f\u5355.getCode().equals(flow.getBillTypeCode())) continue;
            loseList.add(flow);
        }
        if (CollectionUtils.isNotEmpty(checkList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u9a8c\u6536\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(startList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u518d\u542f\u79df\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(stopList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u505c\u7528\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(restList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u9000\u573a\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(loseList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u8d54\u507f\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty((Collection)rentList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u79df\u91d1\u8ba1\u7b97\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public Date getLastDate(Map<String, Object> params) {
        return ((MaterialMapper)this.baseMapper).getLastDate(params);
    }

    @Override
    public Map<Date, Date> getMaxTime(Map<String, Object> params) {
        List<MaxTimeVO> list = ((MaterialMapper)this.baseMapper).getMaxTime(params);
        list.removeAll(Collections.singleton(null));
        if (CollectionUtils.isEmpty(list)) {
            return new HashMap<Date, Date>();
        }
        return list.stream().filter(x -> x.getTime() != null).collect(Collectors.toMap(MaxTimeVO::getDate, MaxTimeVO::getTime));
    }

    @Override
    public List<MaterialVO> proMaterialList(QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        String type = "report";
        Parameter useStatusParameter = (Parameter)param.getParams().get("useStatus");
        List<Object> useStatusList = new ArrayList();
        if (useStatusParameter != null && useStatusParameter.getValue() != null) {
            String useStatus = (String)useStatusParameter.getValue();
            String[] split = useStatus.split(",");
            useStatusList = Arrays.asList(split);
            param.getParams().remove("useStatus");
        }
        List<MaterialVO> list = this.queryCheckList(param, type);
        ArrayList<MaterialVO> resList = new ArrayList<MaterialVO>();
        for (MaterialVO vo2 : list) {
            boolean flag = false;
            if (useStatusList.size() > 0 && !useStatusList.contains(vo2.getUseStatus())) {
                flag = true;
            }
            if (flag) continue;
            resList.add(vo2);
        }
        resList.forEach(vo -> {
            if (null != vo.getUseStatus()) {
                if ("0".equals(vo.getUseStatus())) {
                    vo.setUseStatusName("\u505c\u7528");
                } else if ("1".equals(vo.getUseStatus())) {
                    vo.setUseStatusName("\u542f\u7528");
                }
            } else {
                vo.setUseStatusName("");
            }
        });
        return resList;
    }
}

