package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.rmat.vo.ArchivesVO;
import com.ejianc.business.rmat.vo.ArchivesVOS;
import com.ejianc.business.rmat.vo.ExitApplyDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rmat.mapper.ArchivesMapper;
import com.ejianc.business.rmat.bean.ArchivesEntity;
import com.ejianc.business.rmat.service.IArchivesService;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 周转材档案实体
 *
 * @author generator
 *
 */
@Service("archivesService")
public class ArchivesServiceImpl extends BaseServiceImpl<ArchivesMapper, ArchivesEntity> implements IArchivesService{

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;

    @Override
    public List<ArchivesVO> saveOrUpdate(List<ArchivesVO> vos) {
        CommonResponse<OrgVO> orgVo = iOrgApi.detailById(InvocationInfoProxy.getOrgId());
        Map<Long, CommonResponse<MaterialCategoryVO>> map = new HashMap<>();
        List<Long> categotyIds = new ArrayList<>();
        List<Long> materialIds = new ArrayList<>();
        List<ArchivesVO> archivesVOS = new ArrayList<>();
        List<ArchivesEntity> entityList = new ArrayList<>();
        List<ArchivesEntity> archivesEntityList = this.list(new QueryWrapper<ArchivesEntity>().eq("org_id",InvocationInfoProxy.getOrgId()).eq("id",vos.get(0).getId()));

        if (CollectionUtils.isNotEmpty(archivesEntityList)) {
            for (ArchivesVO saveOrUpdateVO : vos){
                // 修改
                ArchivesEntity archivesEntity =  selectById(saveOrUpdateVO.getId());
                archivesEntity.setRealUnitId(saveOrUpdateVO.getRealUnitId());
                archivesEntity.setRealUnitName(saveOrUpdateVO.getRealUnitName());
                archivesEntity.setTransScale(saveOrUpdateVO.getTransScale());
                archivesEntity.setStatus(saveOrUpdateVO.getStatus());
                super.saveOrUpdate(archivesEntity);
                archivesVOS.add(BeanMapper.map(archivesEntity, ArchivesVO.class));
            }
        } else {
            for (ArchivesVO vo : vos) {
                materialIds.add(vo.getId());
                if (!categotyIds.contains(vo.getCategoryId())) {
                    CommonResponse<MaterialCategoryVO> materialCategoryVO = materialApi.queryCategoryById(vo.getCategoryId());
                    map.put(Long.valueOf(vo.getCategoryId()), materialCategoryVO);
                    categotyIds.add(vo.getCategoryId());
                }
            }
            List<ArchivesEntity> list = this.list(new QueryWrapper<ArchivesEntity>().in("material_id", materialIds).eq("org_id", InvocationInfoProxy.getOrgId()));
            if (CollectionUtils.isNotEmpty(list)) {
                for (ArchivesEntity entity : list) {
                    throw new BusinessException("编号为" + entity.getMaterialCode() + "的物资已被引用！");
                }
            }
            for (ArchivesVO saveOrUpdateVO : vos) {
                // 新增
                saveOrUpdateVO.setCategoryInnerCode(map.get(saveOrUpdateVO.getCategoryId()).getData().getInnerCode());
                saveOrUpdateVO.setMaterialTypeId(map.get(saveOrUpdateVO.getCategoryId()).getData().getId());
                saveOrUpdateVO.setMaterialTypeName(map.get(saveOrUpdateVO.getCategoryId()).getData().getName());

                saveOrUpdateVO.setOrgId(orgVo.getData().getId());
                saveOrUpdateVO.setOrgCode(orgVo.getData().getCode());
                saveOrUpdateVO.setOrgName(orgVo.getData().getName());
                saveOrUpdateVO.setOrgInnerCode(orgVo.getData().getInnerCode());

                saveOrUpdateVO.setMaterialId(saveOrUpdateVO.getId());
                saveOrUpdateVO.setMaterialCode(saveOrUpdateVO.getCode());
                saveOrUpdateVO.setMaterialName(saveOrUpdateVO.getName());
                saveOrUpdateVO.setMaterialSourceId(saveOrUpdateVO.getSourceId());
                saveOrUpdateVO.setUnitId(saveOrUpdateVO.getDef3()); // 档案单位主键为自定义字段3
                saveOrUpdateVO.setStatus(1); //状态默认启用
                saveOrUpdateVO.setRealUnitId(String.valueOf(IdWorker.getId())); // 实物单位主键生成
                saveOrUpdateVO.setRealUnitName(saveOrUpdateVO.getUnitName());
                saveOrUpdateVO.setTransScale(new BigDecimal(1));
                saveOrUpdateVO.setCreateUserName(saveOrUpdateVO.getCreateUserName());
                saveOrUpdateVO.setCreateTime(null);
                saveOrUpdateVO.setId(null);
                ArchivesEntity entity = BeanMapper.map(saveOrUpdateVO, ArchivesEntity.class);
                entityList.add(entity);
            }

        }
        if (CollectionUtils.isNotEmpty(entityList)) {
            super.saveOrUpdateBatch(entityList);
            archivesVOS = BeanMapper.mapList(entityList, ArchivesVO.class);
        }
        return archivesVOS;
    }

    @Override
    public List<ArchivesVO> saveCategory(List<ArchivesVO> saveOrUpdateVO) {
        List<ArchivesVO> archivesVOList = new ArrayList<>();
        List<ArchivesVO> archivesVOS = new ArrayList<>();
        for (ArchivesVO vo : saveOrUpdateVO) {
            String createUserName = vo.getCreateUserName();
            CommonResponse<List<MaterialVO>> list = materialApi.queryMatListByLeafCtyId(vo.getId());
            if (CollectionUtils.isNotEmpty(list.getData())) {
                archivesVOList = BeanMapper.mapList(list.getData(), ArchivesVO.class);
                for (ArchivesVO archivesVO : archivesVOList) {
                    archivesVO.setCreateUserName(createUserName);
                    archivesVOS.add(archivesVO);
                }
            }
        }
        return saveOrUpdate(archivesVOS);
    }

    @Override
    public String turnSwitch(Long id) {
        ArchivesEntity archivesEntity = selectById(id);
        if (archivesEntity.getStatus() == 0){
            archivesEntity.setStatus(1);
            super.saveOrUpdate(archivesEntity);
            return "启用成功！";
        }else {
            archivesEntity.setStatus(0);
            super.saveOrUpdate(archivesEntity);
            return "停用成功！";
        }
    }

    @Override
    public ArchivesVO queryArchives(ArchivesVO vo) {
        ArchivesVO archivesVO = new ArchivesVO();
        CommonResponse<OrgVO> orgVo = iOrgApi.detailById(vo.getOrgId());
        String[] orgInnerCode = (orgVo.getData().getInnerCode()).split("\\|");
        List<String> list = Lists.newArrayList(orgInnerCode);
        for (int i=list.size()-1;i>=0;i--) {
            LambdaQueryWrapper<ArchivesEntity> query = new LambdaQueryWrapper<>();
            query.eq(ArchivesEntity::getOrgId, list.get(i));
            query.eq(ArchivesEntity::getMaterialId, vo.getMaterialId());
            List<ArchivesEntity> archivesEntities = super.list(query);
            if (CollectionUtils.isNotEmpty(archivesEntities)) {
                for (ArchivesEntity entity : archivesEntities) {
                    archivesVO = BeanMapper.map(entity, ArchivesVO.class);
                    break;
                }
            }
        }
        return archivesVO;
    }

    @Override
    public Map<Long, ArchivesVO> queryByIds(List<Long> ids, Long orgId) {
        Map<Long, ArchivesVO> voMap = new HashMap<>();
        CommonResponse<OrgVO> orgVo = iOrgApi.detailById(orgId);
        List<Long> orgIds = Arrays.stream(orgVo.getData().getInnerCode().split("\\|")).map(Long::parseLong).collect(Collectors.toList());
        Collections.reverse(orgIds);
        List<ArchivesEntity> list = this.list(new QueryWrapper<ArchivesEntity>().in("org_id",orgIds).in("material_id",ids).eq("status",1));
        if (CollectionUtils.isEmpty(list)){
            return Collections.emptyMap();
        }
        //同一组织下，每条物料只有一条数据
        Map<String, ArchivesVO> map = BeanMapper.mapList(list,ArchivesVO.class).stream().collect(Collectors.toMap(x->(x.getOrgId()+"|"+x.getMaterialId()), Function.identity()));
        //Map<String,List<ArchivesVO>> map = BeanMapper.mapList(list,ArchivesVO.class).stream().collect(Collectors.groupingBy(x -> x.getOrgId()+"|"+x.getMaterialId(),LinkedHashMap::new, Collectors.toList()));
        List<String> joinIds = new ArrayList<>();
        String s;
        for (Long oid : orgIds) {
            for (Long id : ids) {
                s = oid + "|" + id;
                joinIds.add(s);
            }
        }
        Long key;
        for (String joinId : joinIds) {
            key = Long.parseLong(joinId.split("\\|")[1]);
            if (voMap.containsKey(key)){
                continue;
            }
            if (map.containsKey(joinId)) {
                voMap.put(key,map.get(joinId));
            }
        }
        return voMap;
    }

    @Override
    public List<ArchivesVO> queryIds(ArchivesVOS vos) {
        List<ArchivesVO> archivesVOList = new ArrayList<>();
        CommonResponse<OrgVO> orgVo = iOrgApi.detailById(vos.getOrgId());
        List<Long> orgIds = Arrays.stream(orgVo.getData().getInnerCode().split("\\|")).map(Long::parseLong).collect(Collectors.toList());
        Collections.reverse(orgIds);
        List<ArchivesEntity> list = new ArrayList<>();
        List ids = new ArrayList();
        switch (vos.getType()) {
            case 0:
                list = this.list(new QueryWrapper<ArchivesEntity>().in("org_id",orgIds).in("material_id",vos.getMaterialIds()).eq("status",1));
                break;
            case 1:
                list = this.list(new QueryWrapper<ArchivesEntity>().in("org_id",orgIds).in("material_type_id",vos.getCategoryIds()).eq("status",1));
                break;
        }
        for (Long orgId : orgIds) {
            for (ArchivesEntity entity : list) {
                if (!ids.contains(entity.getMaterialId())) {
                    if (entity.getOrgId().equals(orgId)) {
                        archivesVOList.add(BeanMapper.map(entity,ArchivesVO.class));
                        ids.add(entity.getMaterialId());
                    }
                }
            }
        }
        return archivesVOList;
    }

    @Override
    public List<ArchivesEntity> geMaterialDetail(QueryWrapper queryWrapper) {
        List<ArchivesEntity> list = baseMapper.geMaterialDetail(queryWrapper);
        return list;
    }
}
