package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.rmat.bean.CalculateEntity;
import com.ejianc.business.rmat.bean.CalculateScrapEntity;
import com.ejianc.business.rmat.bean.RestituteEntity;
import com.ejianc.business.rmat.service.ICalculateService;
import com.ejianc.business.rmat.service.IRestituteService;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service("calculate") 
public class CalculateBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ICalculateService service;

	@Autowired
	private IRestituteService restituteService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		CalculateEntity entity = service.selectById(billId);
		// 回写退赔单、结算单 结算状态
		this.writeSettleFlag(entity, 1);
		return CommonResponse.success();
	}

	private void writeSettleFlag(CalculateEntity entity, Integer settleFlag) {
		List<CalculateScrapEntity> scrapList = entity.getScrapList();
		List<Long> ids = scrapList.stream().map(CalculateScrapEntity::getSourceId).collect(Collectors.toList());
		if (ListUtil.isNotEmpty(ids)) {
			LambdaUpdateWrapper<RestituteEntity> ew = new LambdaUpdateWrapper<>();
			ew.set(RestituteEntity::getSettleFlag, settleFlag);
			ew.in(RestituteEntity::getId, ids);
			restituteService.update(ew);
		}
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		CalculateEntity entity = service.selectById(billId);
		// 回写退赔单、结算单 结算状态
		this.writeSettleFlag(entity, 0);
		return CommonResponse.success();
	}

}
