package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.rmat.vo.ManageSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rmat.mapper.ManageSetMapper;
import com.ejianc.business.rmat.bean.ManageSetEntity;
import com.ejianc.business.rmat.service.IManageSetService;

import java.util.ArrayList;
import java.util.List;

/**
 * 周转材管理设置
 *
 * @author generator
 *
 */
@Service("manageSetService")
public class ManageSetServiceImpl extends BaseServiceImpl<ManageSetMapper, ManageSetEntity> implements IManageSetService{

    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IOrgApi iOrgApi;


    @Override
    public List<ManageSetVO> saveOrUpdate(List<ManageSetVO> saveOrUpdateVO) {
        List<ManageSetVO> manageSetVOList = new ArrayList<>();
        for (ManageSetVO manageSetVOS : saveOrUpdateVO){
            CommonResponse<MaterialCategoryVO> materialCategoryVOS = materialApi.queryCategoryById(manageSetVOS.getId());
            ManageSetEntity manageSetEntity = new ManageSetEntity();
            manageSetEntity.setMaterialTypeId(materialCategoryVOS.getData().getId());
            manageSetEntity.setMaterialTypeCode(materialCategoryVOS.getData().getCode());
            manageSetEntity.setMaterialTypeName(materialCategoryVOS.getData().getName());
            manageSetEntity.setCategoryInnerCode(materialCategoryVOS.getData().getInnerCode());
            manageSetEntity.setStatus(0);
            CommonResponse<OrgVO> orgVo = iOrgApi.detailById(InvocationInfoProxy.getOrgId());
            manageSetEntity.setOrgId(orgVo.getData().getId());
            manageSetEntity.setOrgName(orgVo.getData().getName());
            manageSetEntity.setOrgCode(orgVo.getData().getCode());
            manageSetEntity.setOrgInnerCode(orgVo.getData().getInnerCode());
            manageSetEntity.setCreateUserName(manageSetVOS.getCreateUserName());
            super.saveOrUpdate(manageSetEntity);
            manageSetVOList.add(BeanMapper.map(manageSetEntity, ManageSetVO.class));
        }

        return manageSetVOList;
    }

    @Override
    public List<ManageSetVO> queryManageSet(List<ManageSetVO> vos) {
        List<ManageSetVO> voList = new ArrayList<>();
        for (ManageSetVO vo : vos) {
            CommonResponse<OrgVO> orgVO = iOrgApi.detailById(vo.getOrgId());
            String[] orgInnerCode = orgVO.getData().getInnerCode().split("\\|");
            for (int i = orgInnerCode.length-1; i >= 0; i--) {
                LambdaQueryWrapper<ManageSetEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(ManageSetEntity::getStatus, 0);
                queryWrapper.eq(vo.getMaterialId() != null, ManageSetEntity::getMaterialId, vo.getMaterialId());
                queryWrapper.eq(vo.getMaterialTypeId() != null, ManageSetEntity::getMaterialTypeId, vo.getMaterialTypeId());
                queryWrapper.eq(ManageSetEntity::getOrgId, orgInnerCode[i]);
                ManageSetEntity manageSetEntity = super.getOne(queryWrapper);
                if (manageSetEntity != null) {
                    voList.add(BeanMapper.map(manageSetEntity, ManageSetVO.class));
                    break;
                }
            }
        }
        return voList;
    }

    @Override
    public String changeStatus(Long id, Integer status) {
        ManageSetEntity manageSetEntity = super.selectById(id);
        manageSetEntity.setStatus(status);
        super.saveOrUpdate(manageSetEntity);
        if (manageSetEntity.getStatus() == 0) {
            return "启用成功";
        }
        return "停用成功";
    }
}
