/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.controller.api;

import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.vo.RmatFlowApiVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/rmatFlow/"})
@Api(value="\u6750\u6599\u6d41\u6c34API\u63a5\u53e3", tags={"\u6750\u6599\u6d41\u6c34API\u63a5\u53e3"})
public class RmatFlowApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRmatFlowService service;
    @Autowired
    private IMaterialService materialService;

    @ApiOperation(value="\u63d2\u5165\u6d41\u6c34\u64cd\u4f5c")
    @RequestMapping(value={"/insertFlow"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<Boolean> insertFlow(@RequestBody RmatFlowApiVO vo) {
        return CommonResponse.success((String)"\u63d2\u5165\u6d41\u6c34\u6570\u636e\u6210\u529f\uff01", (Object)this.service.insertFlow(vo.getFlowList()));
    }

    @ApiOperation(value="\u5220\u9664\u6d41\u6c34\u64cd\u4f5c")
    @RequestMapping(value={"/delFlow"}, method={RequestMethod.POST})
    @ResponseBody
    CommonResponse<Boolean> delFlow(@RequestBody RmatFlowApiVO vo) {
        return CommonResponse.success((String)"\u5220\u9664\u6d41\u6c34\u6570\u636e\u6210\u529f\uff01", (Object)this.service.delFlow(vo.getSourceIds(), vo.getBillTypeCode()));
    }

    @RequestMapping(value={"/validateContract"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> validateContract(@RequestParam(value="contractId") String contractId, @RequestParam(value="billType", required=false) String billType, @RequestParam(value="billId", required=false) Long billId) {
        String msg = this.materialService.validateContract(contractId, billType, billId, "\u4fdd\u5b58");
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)msg);
    }

    @RequestMapping(value={"/getLastDate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Date> getLastDate(@RequestParam(required=false) Map<String, Object> params) {
        Date date = this.materialService.getLastDate(params);
        return CommonResponse.success((String)"\u6821\u9a8c\u6210\u529f\uff01", (Object)date);
    }
}

