/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.rmat.bean.CalculateDailyEntity;
import com.ejianc.business.rmat.bean.CalculateEntity;
import com.ejianc.business.rmat.bean.PriceFlowEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.MaterialStateEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.mapper.CalculateMapper;
import com.ejianc.business.rmat.service.ICalculateService;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.service.IRestituteService;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.util.ValidateUtil;
import com.ejianc.business.rmat.vo.CalculateDailyVO;
import com.ejianc.business.rmat.vo.CalculateVO;
import com.ejianc.business.rmat.vo.MaterialFlowVO;
import com.ejianc.business.rmat.vo.MaterialVO;
import com.ejianc.business.rmat.vo.RestituteVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="calculateService")
public class CalculateServiceImpl
extends BaseServiceImpl<CalculateMapper, CalculateEntity>
implements ICalculateService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialService materialService;
    @Autowired
    private IRestituteService restituteService;
    @Autowired
    private IPriceFlowService priceService;
    private static final String BILL_CODE = "CSCEC_RMAT_CALCULATE";
    private static final String BILL_NAME = BillTypeEnum.\u79df\u91d1\u8ba1\u7b97\u5355.getName();

    @Override
    public CalculateVO saveOrUpdate(CalculateVO saveOrUpdateVO) {
        this.materialService.validateContract(saveOrUpdateVO.getContractId(), BILL_NAME, saveOrUpdateVO.getId(), "\u4fdd\u5b58");
        this.validateTime(saveOrUpdateVO, "\u4fdd\u5b58");
        CalculateEntity entity = (CalculateEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CalculateEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        return (CalculateVO)BeanMapper.map((Object)((Object)entity), CalculateVO.class);
    }

    @Override
    public String validateTime(CalculateVO vo, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", vo.getContractId());
        if (vo.getId() != null) {
            params.put("billType", BILL_NAME);
            params.put("billId", vo.getId());
        }
        Date lastDate = this.materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.materialService.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate(vo.getRentDate(), lastDate, maxTimeMap, vo.getCreateTime())) {
            throw new BusinessException(DateUtil.formatDate(vo.getRentDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate(lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public CalculateVO autoCalculate(CalculateVO vo) {
        List checkList;
        if (vo == null || vo.getContractId() == null) {
            throw new BusinessException("\u5408\u540c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (vo.getRentDate() == null) {
            throw new BusinessException("\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String contractId = vo.getContractId();
        Date endDate = DateUtil.concatDate(vo.getRentDate(), new Date());
        this.logger.info("\u5f00\u59cb\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\uff0c\u5408\u540cid\uff1a{}\uff0c\u79df\u91d1\u8ba1\u7b97\u65e5\u671f\uff1a{}\u3002>>>>>>>>>>>>>>>>>>>>>>>>>>", (Object)contractId, (Object)endDate);
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("billState", new Parameter("not_in", (Object)"1,3"));
        if (null != vo.getId()) {
            param.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)(checkList = super.queryList(param, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u672a\u751f\u6548\u7684\u79df\u91d1\u8ba1\u7b97\u5355");
        }
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getOrderMap().put("rentDate", "desc");
        List lastList = super.queryList(param, false);
        Date startDate = null;
        if (CollectionUtils.isNotEmpty((Collection)lastList)) {
            CalculateEntity last = (CalculateEntity)((Object)lastList.get(0));
            startDate = DateUtil.concatDate(DateUtil.dayAddOne(last.getRentDate()), last.getCreateTime());
        }
        this.logger.info(">>>>\u67e5\u8be2\u5df2\u5165\u573a\u7269\u6599\u4fe1\u606fstart");
        List<MaterialVO> reportList = this.materialService.queryCalculateList(contractId, startDate, endDate);
        if (CollectionUtils.isEmpty(reportList)) {
            throw new BusinessException("\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5408\u540c\u4e0b\u7269\u6599\u5165\u573a\u4fe1\u606f");
        }
        this.logger.info("<<<<\u67e5\u8be2\u5df2\u5165\u573a\u53f0\u8d26\u4fe1\u606fend\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(reportList));
        this.logger.info(">>>>\u5bf9\u67e5\u8be2\u6570\u636e\u8fdb\u884c\u64cd\u4f5c");
        CalculateEntity entity = new CalculateEntity();
        ArrayList<CalculateDailyEntity> dailyList = new ArrayList<CalculateDailyEntity>();
        ArrayList<CalculateDailyVO> dailyVOList = new ArrayList<CalculateDailyVO>();
        for (MaterialVO materialVO : reportList) {
            this.packParameterDetail(dailyVOList, startDate, endDate, materialVO);
        }
        this.setRentalDayDetailValue(dailyVOList, dailyList, contractId);
        entity.setDailyList(dailyList);
        this.setRentalValue(entity);
        this.logger.info(">>>>\u79df\u91d1\u81ea\u52a8\u8ba1\u7b97\u7ed3\u675f\uff0c\u8f93\u51fa\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
        return (CalculateVO)BeanMapper.map((Object)((Object)entity), CalculateVO.class);
    }

    private void setRentalDayDetailValue(List<CalculateDailyVO> resultList, List<CalculateDailyEntity> dailyList, String contractId) {
        if (CollectionUtils.isEmpty(resultList)) {
            return;
        }
        List<String> materialIds = resultList.stream().filter(x -> x.getMaterialId() != null).map(x -> String.valueOf(x.getMaterialId())).collect(Collectors.toList());
        List<PriceFlowEntity> mateList = this.getPriceFlowList(contractId, "materialId", materialIds);
        Map<String, PriceFlowEntity> mateStartMap = this.getPriceFlowMap(String.valueOf(RmatCommonConsts.YES), false, mateList);
        Map<String, PriceFlowEntity> mateStopMap = this.getPriceFlowMap(String.valueOf(RmatCommonConsts.NO), false, mateList);
        Set infoIds = resultList.stream().filter(x -> x.getMaterialId() == null).map(CalculateDailyVO::getInfoId).collect(Collectors.toSet());
        List<PriceFlowEntity> infoList = this.getPriceFlowList(contractId, "infoId", new ArrayList<String>(infoIds));
        Map<String, PriceFlowEntity> infoStartMap = this.getPriceFlowMap(String.valueOf(RmatCommonConsts.YES), true, infoList);
        Map<String, PriceFlowEntity> infoStopMap = this.getPriceFlowMap(String.valueOf(RmatCommonConsts.NO), true, infoList);
        for (CalculateDailyVO vo : resultList) {
            CalculateDailyEntity entity = new CalculateDailyEntity();
            entity.setInfoId(vo.getInfoId());
            entity.setMaterialTypeId(vo.getMaterialTypeId());
            entity.setMaterialTypeName(vo.getMaterialTypeName());
            entity.setMaterialId(vo.getMaterialId());
            entity.setMaterialCode(vo.getMaterialCode());
            entity.setMaterialName(vo.getMaterialName());
            entity.setMaterialSourceId(vo.getMaterialSourceId());
            entity.setSpec(vo.getSpec());
            entity.setUnitId(vo.getUnitId());
            entity.setUnitName(vo.getUnitName());
            entity.setRealUnitId(vo.getRealUnitId());
            entity.setRealUnitName(vo.getRealUnitName());
            entity.setRealTransScale(vo.getRealTransScale());
            entity.setRentUnitId(vo.getRentUnitId());
            entity.setRentUnitName(vo.getRentUnitName());
            entity.setRentTransScale(vo.getRentTransScale());
            if (vo.getMaterialId() == null) {
                String infoId = vo.getInfoId();
                if (infoStartMap.containsKey(infoId)) {
                    entity.setUnitTaxPrice(infoStartMap.get(infoId).getTaxPrice());
                    entity.setUnitPrice(infoStartMap.get(infoId).getPrice());
                    entity.setTaxRate(infoStartMap.get(infoId).getTaxRate());
                }
                if (infoStopMap.containsKey(infoId)) {
                    entity.setStopUnitTaxPrice(infoStopMap.get(infoId).getTaxPrice());
                    entity.setStopUnitPrice(infoStopMap.get(infoId).getPrice());
                    entity.setTaxRate(infoStopMap.get(infoId).getTaxRate());
                }
            } else {
                String mmaterialId = String.valueOf(vo.getMaterialId());
                if (mateStartMap.containsKey(mmaterialId)) {
                    entity.setUnitTaxPrice(mateStartMap.get(mmaterialId).getTaxPrice());
                    entity.setUnitPrice(mateStartMap.get(mmaterialId).getPrice());
                    entity.setTaxRate(mateStartMap.get(mmaterialId).getTaxRate());
                }
                if (mateStopMap.containsKey(mmaterialId)) {
                    entity.setStopUnitTaxPrice(mateStopMap.get(mmaterialId).getTaxPrice());
                    entity.setStopUnitPrice(mateStopMap.get(mmaterialId).getPrice());
                    entity.setTaxRate(mateStopMap.get(mmaterialId).getTaxRate());
                }
            }
            entity.setStartDate(vo.getStartDate());
            entity.setEndDate(vo.getEndDate());
            entity.setNum(vo.getNum());
            entity.setUseStatus(String.valueOf(vo.getMaterialState() - 2));
            entity.setRentDayDate(DateUtil.getSubDay(vo.getEndDate(), vo.getStartDate()));
            if (MaterialStateEnum.\u542f\u7528.getCode().equals(vo.getMaterialState())) {
                entity.setDailyRentMny(this.getMny(entity.getUnitPrice(), entity.getRentDayDate(), entity.getNum()));
                entity.setDailyRentTaxMny(this.getMny(entity.getUnitTaxPrice(), entity.getRentDayDate(), entity.getNum()));
            } else if (MaterialStateEnum.\u505c\u7528.getCode().equals(vo.getMaterialState())) {
                entity.setDailyRentMny(this.getMny(entity.getStopUnitPrice(), entity.getRentDayDate(), entity.getNum()));
                entity.setDailyRentTaxMny(this.getMny(entity.getStopUnitTaxPrice(), entity.getRentDayDate(), entity.getNum()));
            }
            entity.setDailyTax(ComputeUtil.safeSub((BigDecimal)entity.getDailyRentTaxMny(), (BigDecimal)entity.getDailyRentMny()));
            entity.setRentNum(vo.getNum());
            entity.setNum(null);
            entity.setId(IdWorker.getId());
            entity.setRowState("add");
            dailyList.add(entity);
        }
        if (CollectionUtils.isNotEmpty(dailyList)) {
            dailyList.sort(Comparator.comparing(CalculateDailyEntity::getMaterialTypeId).thenComparing(CalculateDailyEntity::getMaterialId, Comparator.nullsFirst(Long::compareTo)).thenComparing(CalculateDailyEntity::getStartDate));
        }
    }

    private Map<String, PriceFlowEntity> getPriceFlowMap(String useStatus, boolean isInfo, List<PriceFlowEntity> list) {
        Map<String, PriceFlowEntity> map = list.parallelStream().filter(x -> useStatus.equals(x.getUseStatus())).collect(Collectors.groupingBy(x -> isInfo ? x.getInfoId() : String.valueOf(x.getMaterialId()), Collectors.collectingAndThen(Collectors.reducing((c1, c2) -> DateUtil.compareDate(c1.getCreateTime(), c2.getCreateTime()) > 0 ? c1 : c2), Optional::get)));
        return map;
    }

    private List<PriceFlowEntity> getPriceFlowList(String contractId, String fieldName, List<String> ids) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getOrderMap().put("createTime", "desc");
        List<PriceFlowEntity> list = new ArrayList<PriceFlowEntity>();
        if (CollectionUtils.isNotEmpty(ids)) {
            param.getParams().put(fieldName, new Parameter("in", ids));
            list = this.priceService.queryList(param);
        }
        return list;
    }

    private void setRentalValue(CalculateEntity entity) {
        BigDecimal rentMny = BigDecimal.ZERO;
        BigDecimal rentTaxMny = BigDecimal.ZERO;
        BigDecimal rentTax = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(entity.getDailyList())) {
            for (CalculateDailyEntity detail : entity.getDailyList()) {
                rentMny = ComputeUtil.safeAdd((BigDecimal)rentMny, (BigDecimal)detail.getDailyRentMny());
                rentTaxMny = ComputeUtil.safeAdd((BigDecimal)rentTaxMny, (BigDecimal)detail.getDailyRentTaxMny());
                rentTax = ComputeUtil.safeAdd((BigDecimal)rentTax, (BigDecimal)detail.getDailyTax());
            }
        }
        entity.setDailyMny(rentMny);
        entity.setDailyTaxMny(rentTaxMny);
        entity.setDailyTax(rentTax);
        entity.setRentMny(rentMny);
        entity.setRentTaxMny(rentTaxMny);
        entity.setRentTax(rentTax);
    }

    private void packParameterDetail(List<CalculateDailyVO> resultList, Date lastDate, Date rentDate, MaterialVO materialVO) {
        List flowList = materialVO.getFlowList();
        ArrayList<CalculateDailyVO> result = new ArrayList<CalculateDailyVO>();
        ArrayList<MaterialFlowVO> beginList = materialVO.getBeginList();
        if (CollectionUtils.isEmpty((Collection)beginList) && CollectionUtils.isNotEmpty((Collection)flowList)) {
            MaterialFlowVO start = (MaterialFlowVO)BeanMapper.map(flowList.get(0), MaterialFlowVO.class);
            start.setNum(BigDecimal.ZERO);
            start.setStartedNum(BigDecimal.ZERO);
            start.setStopedNum(((MaterialFlowVO)flowList.get(0)).getNum());
            beginList = new ArrayList<MaterialFlowVO>(Arrays.asList(start));
            MaterialFlowVO stop = (MaterialFlowVO)BeanMapper.map((Object)start, MaterialFlowVO.class);
            stop.setMaterialState(MaterialStateEnum.\u505c\u7528.getCode());
            stop.setUseStatus("0");
            beginList.add(stop);
        }
        if (CollectionUtils.isNotEmpty((Collection)beginList)) {
            for (MaterialFlowVO begin : beginList) {
                this.dealFlowList(materialVO, lastDate, rentDate, begin, CollectionUtils.isNotEmpty((Collection)flowList) ? (MaterialFlowVO)flowList.get(0) : null, result, null);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)flowList)) {
            flowList.sort(Comparator.comparing(MaterialFlowVO::getOperationDate));
            for (MaterialFlowVO begin : beginList) {
                for (int i = 0; i < flowList.size(); ++i) {
                    MaterialFlowVO detailVO = (MaterialFlowVO)flowList.get(i);
                    MaterialFlowVO detailVO1 = i == flowList.size() - 1 ? null : (MaterialFlowVO)flowList.get(i + 1);
                    this.dealFlowList(materialVO, lastDate, rentDate, detailVO, detailVO1, result, "1".equals(begin.getUseStatus()));
                }
            }
        }
        result.sort(Comparator.comparing(CalculateDailyVO::getStartDate));
        resultList.addAll(result);
        this.logger.info("\u7ec4\u88c5\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(resultList));
    }

    private void dealFlowList(MaterialVO materialVO, Date lastDate, Date rentDate, MaterialFlowVO detailVO, MaterialFlowVO detailVO1, List<CalculateDailyVO> result, Boolean beginFlag) {
        Date startDate;
        if (detailVO1 != null) {
            this.setBeginNum(detailVO, detailVO1);
        }
        CalculateDailyVO vo = this.transferCacheVO(materialVO, detailVO, beginFlag);
        Date date = startDate = MaterialStateEnum.\u9000\u573a.getCode().equals(detailVO.getMaterialState()) ? DateUtil.beginOfDate(DateUtil.dayAddOne(detailVO.getOperationDate())) : detailVO.getOperationDate();
        if (detailVO1 == null) {
            if (lastDate == null) {
                this.setValue(detailVO.getOperationDate(), rentDate, vo, result);
            } else if (DateUtil.compareDate(detailVO.getOperationDate(), lastDate) > 0) {
                if (DateUtil.compareDate(detailVO.getOperationDate(), rentDate) > 0) {
                    return;
                }
                this.setValue(startDate, rentDate, vo, result);
            } else {
                this.setValue(lastDate, rentDate, vo, result);
            }
        } else {
            Date endDate;
            Date date2 = endDate = MaterialStateEnum.\u9000\u573a.getCode().equals(detailVO1.getMaterialState()) ? detailVO1.getOperationDate() : DateUtil.daySubOne(detailVO1.getOperationDate());
            if (lastDate == null) {
                if (DateUtil.compareDate(detailVO.getOperationDate(), rentDate) > 0) {
                    return;
                }
                if (DateUtil.compareDate(detailVO1.getOperationDate(), rentDate) > 0) {
                    this.setValue(startDate, rentDate, vo, result);
                } else {
                    this.setValue(startDate, endDate, vo, result);
                }
            } else if (DateUtil.compareDate(detailVO.getOperationDate(), lastDate) > 0) {
                if (DateUtil.compareDate(detailVO.getOperationDate(), rentDate) > 0) {
                    return;
                }
                if (DateUtil.compareDate(detailVO1.getOperationDate(), rentDate) > 0) {
                    this.setValue(startDate, rentDate, vo, result);
                } else {
                    this.setValue(startDate, endDate, vo, result);
                }
            } else if (DateUtil.compareDate(detailVO1.getOperationDate(), rentDate) > 0) {
                this.setValue(lastDate, rentDate, vo, result);
            } else {
                this.setValue(lastDate, endDate, vo, result);
            }
        }
    }

    private void setBeginNum(MaterialFlowVO detailVO, MaterialFlowVO detailVO1) {
        if (MaterialStateEnum.\u9000\u573a.getCode().equals(detailVO1.getMaterialState())) {
            if ("1".equals(detailVO1.getUseStatus())) {
                detailVO1.setStartedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStartedNum(), (BigDecimal)detailVO1.getNum()));
                detailVO1.setStopedNum(detailVO.getStopedNum());
            } else {
                detailVO1.setStartedNum(detailVO.getStartedNum());
                detailVO1.setStopedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStopedNum(), (BigDecimal)detailVO1.getNum()));
            }
        } else if ("1".equals(detailVO1.getUseStatus())) {
            detailVO1.setStartedNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getStartedNum(), (BigDecimal)detailVO1.getNum()));
            detailVO1.setStopedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStopedNum(), (BigDecimal)detailVO1.getNum()));
        } else {
            detailVO1.setStartedNum(ComputeUtil.safeSub((BigDecimal)detailVO.getStartedNum(), (BigDecimal)detailVO1.getNum()));
            detailVO1.setStopedNum(ComputeUtil.safeAdd((BigDecimal)detailVO.getStopedNum(), (BigDecimal)detailVO1.getNum()));
        }
    }

    private void setValue(Date startDate, Date endDate, CalculateDailyVO vo, List<CalculateDailyVO> result) {
        if (DateUtil.compareDate(startDate, endDate) > 0) {
            return;
        }
        vo.setStartDate(startDate);
        vo.setEndDate(endDate);
        if (ComputeUtil.isLessOrEqual((BigDecimal)vo.getNum(), (BigDecimal)BigDecimal.ZERO)) {
            return;
        }
        result.add(vo);
    }

    private CalculateDailyVO transferCacheVO(MaterialVO materialVO, MaterialFlowVO detailVO, Boolean flag) {
        CalculateDailyVO vo = new CalculateDailyVO();
        vo.setMaterialId(materialVO.getMaterialId());
        vo.setMaterialCode(materialVO.getMaterialCode());
        vo.setMaterialName(materialVO.getMaterialName());
        vo.setMaterialSourceId(materialVO.getMaterialSourceId());
        vo.setInfoId(materialVO.getInfoId());
        vo.setMaterialTypeId(materialVO.getMaterialTypeId());
        vo.setMaterialTypeName(materialVO.getMaterialTypeName());
        vo.setSpec(materialVO.getSpec());
        vo.setUnitId(materialVO.getUnitId());
        vo.setUnitName(materialVO.getUnitName());
        vo.setRealUnitId(materialVO.getRealUnitId());
        vo.setRealUnitName(materialVO.getRealUnitName());
        vo.setRealTransScale(materialVO.getRealTransScale());
        vo.setRentUnitId(materialVO.getRentUnitId());
        vo.setRentUnitName(materialVO.getRentUnitName());
        vo.setRentTransScale(materialVO.getRentTransScale());
        vo.setParameterId(materialVO.getId());
        if (flag == null) {
            vo.setNum(detailVO.getNum());
            vo.setMaterialState(detailVO.getMaterialState());
        } else if (flag.booleanValue()) {
            vo.setNum(detailVO.getStartedNum());
            vo.setMaterialState(MaterialStateEnum.\u542f\u7528.getCode());
        } else {
            vo.setNum(detailVO.getStopedNum());
            vo.setMaterialState(MaterialStateEnum.\u505c\u7528.getCode());
        }
        return vo;
    }

    private BigDecimal getMny(BigDecimal price, Integer days, BigDecimal num) {
        return ComputeUtil.safeMultiply((BigDecimal)price, (BigDecimal[])new BigDecimal[]{new BigDecimal(days), num});
    }

    @Override
    public List<RestituteVO> queryRestituteData(QueryParam param, String contractId, String lastRentDate, String rentDate) {
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("settleFlag", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("createTime", "desc");
        if (StringUtils.isBlank((CharSequence)lastRentDate)) {
            param.getParams().put("restituteDate", new Parameter("le", (Object)rentDate));
        } else {
            param.getParams().put("restituteDate", new Parameter("between", (Object)(lastRentDate + "," + rentDate)));
        }
        List list = this.restituteService.queryList(param);
        if (ListUtil.isEmpty((List)list)) {
            return new ArrayList<RestituteVO>();
        }
        return BeanMapper.mapList((Iterable)list, RestituteVO.class);
    }

    @Override
    public Date getLastRentDate(String contractId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getOrderMap().put("rentDate", "desc");
        List lastList = super.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)lastList)) {
            return ((CalculateEntity)((Object)lastList.get(0))).getRentDate();
        }
        return null;
    }
}

