/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.rmat.bean.CalculateDailyEntity;
import com.ejianc.business.rmat.bean.CalculateOtherEntity;
import com.ejianc.business.rmat.bean.CalculateScrapEntity;
import com.ejianc.business.rmat.bean.ExitEntity;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.consts.TransFlowTypeEnum;
import com.ejianc.business.rmat.service.CommonSupportService;
import com.ejianc.business.rmat.service.ICalculateDailyService;
import com.ejianc.business.rmat.service.ICalculateOtherService;
import com.ejianc.business.rmat.service.ICalculateScrapService;
import com.ejianc.business.rmat.service.ICoordinationSetService;
import com.ejianc.business.rmat.service.IExitService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.service.ITransferFlowService;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="exit")
public class ExitBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IExitService service;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CommonSupportService commonSupportService;
    @Autowired
    private ITransferFlowService transferFlowService;
    @Autowired
    private ICoordinationSetService coordinationSetService;
    @Autowired
    private ICalculateDailyService calculateDailyService;
    @Autowired
    private ICalculateOtherService calculateOtherService;
    @Autowired
    private ICalculateScrapService calculateScrapService;
    @Autowired
    private IRmatFlowService flowService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ExitEntity exitEntity = (ExitEntity)((Object)this.service.selectById(billId));
        if (CollectionUtils.isEmpty(exitEntity.getExitDetail())) {
            throw new BusinessException("\u660e\u7ec6\u6570\u636e\u4e3a\u7a7a\u4e0d\u5141\u8bb8\u63d0\u4ea4\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ExitEntity exitEntity = (ExitEntity)((Object)this.service.selectById(billId));
        if (2 == exitEntity.getConfirmFlag()) {
            exitEntity.setConfirmFlag(0);
        }
        exitEntity.setCommitId(InvocationInfoProxy.getUserid());
        this.service.saveOrUpdate((Object)exitEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ExitEntity exitEntity = (ExitEntity)((Object)this.service.selectById(billId));
        if (CollectionUtils.isNotEmpty(exitEntity.getExitSupplierList()) && !this.transferFlowService.insertExitFlow((ExitEntity)((Object)this.service.selectById(billId)), TransFlowTypeEnum.\u9000\u573a.getFlowType(), RmatCommonConsts.YES).booleanValue()) {
            throw new BusinessException("\u5355\u636e\u63a8\u9001\u53f0\u8d26\u6d41\u6c34\u5931\u8d25\uff01");
        }
        if (!this.flowService.insertExitFlow(exitEntity, billTypeCode, RmatCommonConsts.YES).booleanValue()) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        Boolean falg = this.coordinationSetService.querySupplyByOrgId(exitEntity.getOrgId());
        if (!falg.booleanValue()) return CommonResponse.success();
        HashMap<String, String> headers = new HashMap<String, String>();
        CommonResponse<String> tokenres = this.commonSupportService.getAccessToken(headers);
        if (!tokenres.isSuccess()) return tokenres;
        this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
        CommonResponse<String> pushres = this.service.pushConfirmEntity(headers, exitEntity);
        this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
        if (!pushres.isSuccess()) return pushres;
        if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state) {
            if (2 == exitEntity.getConfirmFlag()) {
                exitEntity.setConfirmFlag(0);
            }
            exitEntity.setCommitId(InvocationInfoProxy.getUserid());
        }
        this.service.saveOrUpdate((Object)exitEntity, false);
        return CommonResponse.success();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ExitEntity exitEntity = (ExitEntity)((Object)this.service.selectById(billId));
        Boolean falg = this.coordinationSetService.querySupplyByOrgId(exitEntity.getOrgId());
        if (falg.booleanValue()) {
            if (exitEntity.getConfirmFlag() == 1) {
                return CommonResponse.error((String)"\u9000\u573a\u5355\u4f9b\u65b9\u5df2\u786e\u8ba4\u4e0d\u652f\u6301\u64a4\u56de!");
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            CommonResponse<String> tokenres = this.commonSupportService.getAccessToken(headers);
            if (!tokenres.isSuccess()) return tokenres;
            this.logger.info("\u83b7\u53d6\u4f9b\u65b9token--" + headers);
            CommonResponse<String> pushres = this.service.pushDelete(headers, exitEntity);
            this.logger.info("\u83b7\u53d6\u63a8\u9001\u4f9b\u65b9\u7ed3\u679c--" + pushres);
            if (!pushres.isSuccess()) {
                return pushres;
            }
        } else {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(CalculateDailyEntity::getSourceId, (Object)exitEntity.getId());
            List calculateDailyEntityList = this.calculateDailyService.list((Wrapper)lambda);
            if (CollectionUtils.isNotEmpty((Collection)calculateDailyEntityList)) {
                return CommonResponse.error((String)"\u9000\u573a\u5355\u5df2\u88ab\u79df\u91d1\u8ba1\u7b97\u5355\u5f15\u7528\u4e0d\u652f\u6301\u64a4\u56de!");
            }
            LambdaQueryWrapper lambdao = Wrappers.lambdaQuery();
            lambdao.eq(CalculateOtherEntity::getSourceId, (Object)exitEntity.getId());
            List calculateOtherEntityList = this.calculateOtherService.list((Wrapper)lambdao);
            if (CollectionUtils.isNotEmpty((Collection)calculateOtherEntityList)) {
                return CommonResponse.error((String)"\u9000\u573a\u5355\u5df2\u88ab\u79df\u91d1\u8ba1\u7b97\u5355\u5f15\u7528\u4e0d\u652f\u6301\u64a4\u56de!");
            }
            LambdaQueryWrapper lambdsad = Wrappers.lambdaQuery();
            lambdsad.eq(CalculateScrapEntity::getSourceId, (Object)exitEntity.getId());
            List calculateScrapEntityList = this.calculateScrapService.list((Wrapper)lambdsad);
            if (CollectionUtils.isNotEmpty((Collection)calculateScrapEntityList)) {
                return CommonResponse.error((String)"\u9000\u573a\u5355\u5df2\u88ab\u79df\u91d1\u8ba1\u7b97\u5355\u5f15\u7528\u4e0d\u652f\u6301\u64a4\u56de!");
            }
        }
        if (this.flowService.insertExitFlow(exitEntity, billTypeCode, RmatCommonConsts.NO).booleanValue()) return CommonResponse.success();
        return CommonResponse.error((String)"\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

