/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.bean.PriceFlowEntity;
import com.ejianc.business.rmat.bean.StartDetailEntity;
import com.ejianc.business.rmat.bean.StartEntity;
import com.ejianc.business.rmat.bean.StopDetailEntity;
import com.ejianc.business.rmat.bean.StopEntity;
import com.ejianc.business.rmat.consts.FlowTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.mapper.PriceFlowMapper;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.vo.PriceFlowVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="priceFlowService")
public class PriceFlowServiceImpl
extends BaseServiceImpl<PriceFlowMapper, PriceFlowEntity>
implements IPriceFlowService {
    @Override
    public Boolean insertFlow(List<PriceFlowVO> vos) {
        ArrayList<PriceFlowVO> addList = new ArrayList<PriceFlowVO>();
        ArrayList<Long> delIds = new ArrayList<Long>();
        for (PriceFlowVO vo : vos) {
            vo.setId(vo.getSourceDetailId());
            if (!"del".equals(vo.getRowState())) {
                addList.add(vo);
                continue;
            }
            delIds.add(vo.getId());
        }
        if (CollectionUtils.isNotEmpty(addList)) {
            List list = BeanMapper.mapList(addList, PriceFlowEntity.class);
            super.saveOrUpdateBatch((Collection)list);
        }
        if (CollectionUtils.isNotEmpty(delIds)) {
            ((PriceFlowMapper)this.baseMapper).deleteByIds(delIds);
        }
        return true;
    }

    @Override
    public Boolean insertStopFlow(StopEntity entity, String billTypeCode) {
        ArrayList<PriceFlowVO> flowList = new ArrayList<PriceFlowVO>();
        List<StopDetailEntity> detailList = entity.getDetailList();
        for (StopDetailEntity detail : detailList) {
            PriceFlowVO vo = new PriceFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);
            vo.setSourceId(entity.getId());
            vo.setSourceDetailId(detail.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setProjectId(entity.getProjectId());
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());
            vo.setContractName(entity.getContractName());
            vo.setBillDate(entity.getStopTime());
            vo.setEffectiveDate(new Date());
            vo.setFlowType(String.valueOf(FlowTypeEnum.\u505c\u7528.getFlowType()));
            vo.setUseStatus(String.valueOf(RmatCommonConsts.NO));
            vo.setDetailDate(detail.getStopTime());
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());
            vo.setPrice(detail.getStopPrice());
            vo.setTaxPrice(detail.getTaxPrice());
            vo.setTaxRate(detail.getTaxRate());
            vo.setRowState(detail.getRowState());
            flowList.add(vo);
        }
        return this.insertFlow(flowList);
    }

    @Override
    public Boolean insertStartFlow(StartEntity entity, String billTypeCode) {
        ArrayList<PriceFlowVO> flowList = new ArrayList<PriceFlowVO>();
        List<StartDetailEntity> detailList = entity.getDetailList();
        for (StartDetailEntity detail : detailList) {
            PriceFlowVO vo = new PriceFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);
            vo.setSourceId(entity.getId());
            vo.setSourceDetailId(detail.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setProjectId(entity.getProjectId());
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());
            vo.setContractName(entity.getContractName());
            vo.setBillDate(entity.getStartTime());
            vo.setEffectiveDate(new Date());
            vo.setFlowType(String.valueOf(FlowTypeEnum.\u542f\u7528.getFlowType()));
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));
            vo.setDetailDate(detail.getStartTime());
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());
            vo.setPrice(detail.getStartPrice());
            vo.setTaxPrice(detail.getTaxPrice());
            vo.setTaxRate(detail.getTaxRate());
            vo.setRowState(detail.getRowState());
            flowList.add(vo);
        }
        return this.insertFlow(flowList);
    }

    @Override
    public Boolean delFlow(List<Long> sourceIds, String billTypeCode) {
        if (CollectionUtils.isEmpty(sourceIds)) {
            return true;
        }
        ((PriceFlowMapper)this.baseMapper).deleteBySourceIds(sourceIds, billTypeCode);
        return true;
    }
}

