package com.ejianc.business.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rmat.bean.CalculateEntity;
import com.ejianc.business.rmat.service.ICalculateService;
import com.ejianc.business.rmat.util.PageUtil;
import com.ejianc.business.rmat.vo.CalculateVO;
import com.ejianc.business.rmat.vo.RestituteVO;
import com.ejianc.business.sync.api.ICalculateSyncApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 租金计算单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("calculate")
public class CalculateController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ICalculateService service;

    @Autowired
    private ICalculateSyncApi calculateSyncApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CalculateVO> saveOrUpdate(@RequestBody CalculateVO saveOrUpdateVO) {
    	CalculateVO vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CalculateVO> queryDetail(Long id) {
    	CalculateEntity entity = service.selectById(id);
    	CalculateVO vo = BeanMapper.map(entity, CalculateVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CalculateVO> vos) {
        service.removeByIds(vos.stream().map(CalculateVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CalculateVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("parentOrgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(!param.getParams().containsKey("orgId")){// 非移动端默认项目，走PC端
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        IPage<CalculateEntity> page = service.queryPage(param,false);
        IPage<CalculateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CalculateVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("billCode");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("parentOrgName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        if(!param.getParams().containsKey("orgId")){// 非移动端默认项目，走PC端
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        List<CalculateEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<CalculateVO> voList = BeanMapper.mapList(list, CalculateVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("calculate-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
//     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refCalculateData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CalculateVO>> refCalculateData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<CalculateEntity> page = service.queryPage(param,false);
        IPage<CalculateVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CalculateVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 租金自动计算
     *
     * @param vo 参数 contractId、rentDate
     * @return 计算结果
     */
    @RequestMapping(value = "/autoCalculate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CalculateVO> autoCalculate(@RequestBody CalculateVO vo) {
        return CommonResponse.success("租金自动计算成功！", service.autoCalculate(vo));
    }

    /**
     * 查询退赔单
     * @param contractId
     * @param rentDate
     * @return
     */
    @RequestMapping(value = "/queryRestituteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<RestituteVO>> queryRestituteData(@RequestParam("contractId") String contractId,
            @RequestParam(value = "lastRentDate", required = false) String lastRentDate,
            @RequestParam(value = "rentDate", required = false) String rentDate) {
        return CommonResponse.success("查询退赔单成功！", service.queryRestituteData(new QueryParam(), contractId, lastRentDate, rentDate));
    }

    /**
     * @Description 退赔参照
     * @Return void
     */
    @RequestMapping(value = "/refRestituteData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RestituteVO>> refMaterialData(@RequestParam Integer pageNumber,
            @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("supplierName");
        String contractId = null;
        String lastRentDate = null;
        String rentDate = null;
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject json = JSONObject.parseObject(condition);
            if(condition.contains("contractId")){
                contractId = json.getString("contractId");
            }
            if(condition.contains("lastRentDate")){
                lastRentDate = json.getString("lastRentDate");
            }
            if(condition.contains("rentDate")){
                rentDate = json.getString("rentDate");
            }
        }
        List<RestituteVO> list = service.queryRestituteData(param, contractId, lastRentDate, rentDate);
        List<RestituteVO> records = PageUtil.listToPage(list, pageNumber, pageSize);
        IPage<RestituteVO> page = new Page<>();
        page.setRecords(records);
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        page.setTotal(list.size());
        return CommonResponse.success("查询参照数据成功！", page);
    }

    /**
     * @Description getLastDate 获取最大单据日期
     * @param contractId
     */
    @RequestMapping(value = "/getLastRentDate", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Date> getLastRentDate(@RequestParam("contractId") String contractId) {
        Date date = service.getLastRentDate(contractId);
        return CommonResponse.success("查询成功！", date);
    }


    @RequestMapping(path = "/syncSettleFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> syncSettleFlag(HttpServletRequest request) {
        logger.info("----------------------------------");
        logger.info("结算标识同步开始》》》》》》》》》》》》");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -1);
        String ts = df.format(calendar.getTime()) + " 00:00:00";

        // 手动调用时传的时间参数（正式的调度中心可忽略）
        if (request.getParameter("ts") != null) {
            ts = request.getParameter("ts");
            logger.info("ts------->" + ts);
        }

        CommonResponse<List<com.ejianc.business.sync.vo.CalculateVO>> listCommonResponse = calculateSyncApi.settleFlagSync(ts);
        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty(listCommonResponse.getData())) {
            Set<String> isSettleSet = new HashSet<>();
            Set<String> noSettleSet = new HashSet<>();
            for(com.ejianc.business.sync.vo.CalculateVO calculateVO : listCommonResponse.getData()){
                String pkId = calculateVO.getPkId().split("@")[0];
                if (1 == calculateVO.getNflag()) {
                    isSettleSet.add(pkId);
                }else if(!isSettleSet.contains(pkId) && 0 == calculateVO.getNflag()){
                    noSettleSet.add(pkId);
                }
            }
            LambdaUpdateWrapper<CalculateEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(CalculateEntity::getId, isSettleSet);
            updateWrapper.set(CalculateEntity::getNcSettleFlag, 1);
            service.update(updateWrapper);
            updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.in(CalculateEntity::getId, noSettleSet);
            updateWrapper.set(CalculateEntity::getNcSettleFlag, 0);
            service.update(updateWrapper);
        }
        logger.info("《《《《《《《《《《《《《结算标识同步结束");
        return CommonResponse.success("执行成功");
    }
}
