package com.ejianc.business.rmat.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.rmat.bean.ExitApplyEntity;
import com.ejianc.business.rmat.bean.ExitEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.TransFlowTypeEnum;
import com.ejianc.business.rmat.service.IExitApplyService;
import com.ejianc.business.rmat.service.IExitService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.service.ITransferFlowService;
import com.ejianc.business.rmat.vo.ExitReportVO;
import com.ejianc.business.rmat.vo.ExitSupplierVO;
import com.ejianc.business.rmat.vo.ExitVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 退场单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("exit")
public class ExitController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IExitService service;

    @Autowired
    private IExitApplyService exitApplyService;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private ITransferFlowService transferFlowService;

    @Autowired
    private IRmatFlowService flowService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitVO> saveOrUpdate(@RequestBody ExitVO saveorUpdateVO) {
        // 保存态
        saveorUpdateVO.setSaveState(1);
        return CommonResponse.success("保存或修改单据成功！",service.saveOrUpdate(saveorUpdateVO));
    }

    /**
     * @Description saveOrUpdateTemp 暂存或者修改
     */
    @RequestMapping(value = "/saveOrUpdateTemp", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitVO> saveOrUpdateTemp(@RequestBody ExitVO saveorUpdateVO) {
        // 暂存态
        saveorUpdateVO.setSaveState(0);
        return CommonResponse.success("保存或修改单据成功！",service.saveOrUpdate(saveorUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExitVO> queryDetail(Long id) {
        return CommonResponse.success("查询详情数据成功！",service.queryDetail(id));
    }

    /**
     * @Description queryDetail 根据项目+登录人获取 最近一次联系人，联系电话，地址等信息
     * @param
     */
    @RequestMapping(value = "/queryLinkDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExitVO> queryLinkDetail(Long projectId) {
        List<ExitEntity> details = null;
        LambdaQueryWrapper<ExitEntity> lambda = Wrappers.<ExitEntity>lambdaQuery();
        lambda.eq(ExitEntity::getTenantId,InvocationInfoProxy.getTenantid());
        lambda.eq(ExitEntity::getProjectId,projectId);
        lambda.eq(ExitEntity::getEmployeeId,InvocationInfoProxy.getEmployeeId());
        lambda.orderByDesc(ExitEntity::getCreateTime);
        details = service.list(lambda);
        if(CollectionUtils.isNotEmpty(details)){
            return CommonResponse.success("查询详情数据成功！", BeanMapper.map(details.get(0),ExitVO.class));
        }else{
            return CommonResponse.success("查询详情数据成功！", null);
        }
    }

    /**
     * @Description queryDetail 查询复制申请单详情
     * @param id
     */
    @RequestMapping(value = "/queryCopyDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ExitVO> queryCopyDetail(Long id) {
        ExitApplyEntity applyEntity = exitApplyService.selectById(id);
        ExitVO vo = BeanMapper.map(applyEntity, ExitVO.class);
        vo.setApplyId(applyEntity.getId());
        vo.setId(null);
        vo.setEmployeeId(null);
        vo.setEmployeeName(null);
        vo.setLinkId(null);
        vo.setLinkName(null);
        vo.setLinkTelephone(null);
        vo.setCreateTime(null);
        vo.setCreateUserCode(null);
        vo.setUpdateTime(null);
        vo.setUpdateUserCode(null);
        vo.setConfirmFlag(0);
        vo.setConfirmDate(null);
        vo.setConfirmerId(null);
        vo.setConfirmerName(null);
        vo.setConfirmNote(null);
        vo.setExitDate(null);
        vo.setBillState(0);
        vo.setBillCode(null);
        vo.setDef1(null);
        vo.setDef2(null);
        vo.setDef3(null);
        vo.setDef4(null);
        vo.setDef5(null);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ExitVO> vos) {
        //推送台账流水
        List<Long> ids = vos.stream().map(ExitVO::getId).collect(Collectors.toList());
        transferFlowService.delete(ids, TransFlowTypeEnum.退场.getFlowType());
        // 删除流水
        if(!flowService.delFlow(ids, BillTypeEnum.退场单.getCode())){
            return CommonResponse.error("单据删除流水失败！");
        }
        service.removeByIds(ids,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExitVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
      //  param.getParams().put("saveState", new Parameter(QueryParam.NE, 1));
        Long orgId = InvocationInfoProxy.getOrgId();
        boolean mobile = param.getParams().containsKey("projectId");
        if(!mobile){
     /*       List<Long> commonOrgIds = new ArrayList<>();
            CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
            if(!orgListResp.isSuccess()) {
                throw new BusinessException("列表查询失败, 查询组织信息失败！");
            }
            commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
            }*/
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        IPage<ExitEntity> page = service.queryPage(param,false);
        IPage<ExitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExitVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description querySupplier 查询劳务
     * @param
     */
    @RequestMapping(value = "/querySupplier", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<ExitSupplierVO>> querySupplier(@RequestParam(value = "exitId") Long exitId, @RequestParam(value = "exitDetailId", required = false) Long exitDetailId) {
        return CommonResponse.success("查询领料成功！", service.querySupplier(exitId, exitDetailId));
    }


    /**
     * @Description queryList 查询暂存列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryTempList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ExitVO>> queryTempList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStateList.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));
        IPage<ExitEntity> page = service.queryPage(param,false);
        IPage<ExitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExitVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        param.setPageIndex(1);
        param.setPageSize(10000);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("saveState", new Parameter(QueryParam.NE, 0));
        /*List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = orgApi.findChildrenByParentId(orgId);
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }*/
        /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
        if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
        } else {
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, orgApi.findChildrenByParentIdWithoutProjectDept(
                    InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        IPage<ExitEntity> page = service.queryPage(param,false);
        IPage<ExitVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ExitVO.class));
        List<ExitVO> listExport = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(pageData.getRecords())){
            pageData.getRecords().forEach(vo->{
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                if(null!=vo.getConfirmFlag()&&0==vo.getConfirmFlag()){
                    vo.setConfirmFlagName("待确认");
                }else if(null!=vo.getConfirmFlag()&&1==vo.getConfirmFlag()){
                    vo.setConfirmFlagName("已确认");
                }else if(null!=vo.getConfirmFlag()&&2==vo.getConfirmFlag()){
                    vo.setConfirmFlagName("已拒绝");
                }
            });
            listExport = pageData.getRecords();
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("exitExport.xlsx", beans, response);
    }


    /**
     * @Description  更新确认状态
     */
    @RequestMapping(value = "/updateConfirmFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ExitVO> updateConfirmFlag(@RequestBody ExitVO exitVO) {
        return service.updateConfirmFlag(exitVO);
    }


    /**
     * @Description 周转材进出场台账
     * @param queryParam
     * @Return
     */
    @RequestMapping(value = "/queryExitReports", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ExitReportVO>> queryExitReports(@RequestBody QueryParam queryParam) {
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("exitDate","asc");
        Page<ExitReportVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<ExitReportVO> list = service.queryExitReport(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(vo->{
                if(0==vo.getType()){
                    vo.setTypeName("进场");
                }else{
                    vo.setTypeName("退场");
                }
            });
        }
//        IPage<ExitReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！",list);
    }

    @RequestMapping(value = "/ExitReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void ExitReportExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getOrderMap().put("exitDate","asc");
        Page<ExitReportVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<ExitReportVO> list = service.queryExitReport(wrapper);
//        IPage<ExitReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        pageData.setRecords(list);
        if(CollectionUtils.isNotEmpty(list)){
            list.forEach(vo->{
                if(0==vo.getType()){
                    vo.setTypeName("进场");
                }else{
                    vo.setTypeName("退场");
                }
            });
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("exitReportExport.xlsx", beans, response);
    }

    /**
     * @Description 周转材租赁台账
     * @param queryParam
     * @Return
     */
    @RequestMapping(value = "/queryZlReports", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ExitReportVO>> queryZlReports(@RequestBody QueryParam queryParam) {
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Page<ExitReportVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        String projectId  =queryParam.getParams().get("projectId").getValue().toString();
        String supplierId = "0";
        if (queryParam.getParams().get("supplierId")!=null){
            supplierId =queryParam.getParams().get("supplierId").getValue().toString();
        }
        queryParam.getParams().remove("projectId");
        queryParam.getParams().remove("supplierId");
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<ExitReportVO> list = service.queryZlReports(wrapper,Long.valueOf(projectId),Long.valueOf(supplierId));
//        IPage<ExitReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！",list);
    }

    @RequestMapping(value = "/zlReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void zlReportExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Page<ExitReportVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        String projectId  =queryParam.getParams().get("projectId").getValue().toString();
        String supplierId = "0";
        if (queryParam.getParams().get("supplierId")!=null){
            supplierId =queryParam.getParams().get("supplierId").getValue().toString();
        }
        queryParam.getParams().remove("projectId");
        queryParam.getParams().remove("supplierId");
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<ExitReportVO> list = service.queryZlReports(wrapper,Long.valueOf(projectId),Long.valueOf(supplierId));
//        IPage<ExitReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        pageData.setRecords(list);
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("zlReportExport.xlsx", beans, response);
    }
    /**
     * @Description 项目采购台账
     * @param queryParam
     * @Return
     */
    @RequestMapping(value = "/queryCgReports", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ExitReportVO>> queryCgReports(@RequestBody QueryParam queryParam) {
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Page<ExitReportVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        String projectId  =queryParam.getParams().get("projectId").getValue().toString();
        queryParam.getParams().remove("projectId");
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<ExitReportVO> list = service.queryCgReports(wrapper,Long.valueOf(projectId));
//        IPage<ExitReportVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
//        pageData.setRecords(list);
        return CommonResponse.success("查询列表数据成功！",list);
    }

    @RequestMapping(value = "/cgReportExport", method = RequestMethod.POST)
    @ResponseBody
    public void cgReportExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        queryParam.setPageIndex(1);
        queryParam.setPageSize(10000);
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Page<ExitReportVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        String projectId  =queryParam.getParams().get("projectId").getValue().toString();
        queryParam.getParams().remove("projectId");
        QueryWrapper wrapper = changeToQueryWrapper(queryParam);
        List<ExitReportVO> list = service.queryCgReports(wrapper,Long.valueOf(projectId));
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("cgReportExport.xlsx", beans, response);
    }

}
