package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.rmat.bean.*;
import com.ejianc.business.rmat.service.ICalculateService;
import com.ejianc.business.rmat.service.IRestituteService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.sync.api.ICalculateSyncApi;
import com.ejianc.business.sync.vo.CalculateDetailVO;
import com.ejianc.business.sync.vo.CalculateSettleVO;
import com.ejianc.business.sync.vo.CalculateVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("calculate")
public class CalculateBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ICalculateService service;

	@Autowired
	private IRestituteService restituteService;

	@Autowired
	private ICalculateSyncApi calculateSyncApi;

	@Autowired
	private ICmContractInfoApi cmContractInfoApi;

	@Autowired
	private IMaterialApi materialApi;

	@Autowired
	private IRmatFlowService rmatFlowService;

	@Value("${common.env.base-host}")
	private String BASE_HOST;//运行环境域名


	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		CalculateEntity entity = service.selectById(billId);

		writeForNc(entity);

		// 回写退赔单、结算单 结算状态
		this.writeSettleFlag(entity, 1);

		return CommonResponse.success();
	}

	private void writeForNc(CalculateEntity entity){
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		//查询合同下的清单分录
		CommonResponse<List<CmContractInfoVO>> commonResponse = cmContractInfoApi.queryLeaseContractInfoById(entity.getContractId());
		Map<String, CmContractInfoVO> contInfoMap = new HashMap<>();
		Map<String, BigDecimal> rateMap = new HashMap<>();
		if(commonResponse.isSuccess() && CollectionUtils.isNotEmpty(commonResponse.getData())){
			for(CmContractInfoVO infoVO : commonResponse.getData()){
				contInfoMap.put(infoVO.getPkContractinfo(), infoVO);
				rateMap.put(infoVO.getPkAmountlist(), infoVO.getSl());
			}
		}

		Map<String, CalculateVO> calcVOMap = new HashMap<>();
		if (CollectionUtils.isNotEmpty(entity.getDailyList())) {
			for(CalculateDailyEntity dailyEntity : entity.getDailyList()){
				String fl = contInfoMap.get(dailyEntity.getInfoId()).getPkAmountlist();
				CalculateVO calculateVO = null;
				List<CalculateDetailVO> detailVOS = new ArrayList<>();
				if (!calcVOMap.containsKey(fl)) {
					calculateVO = new CalculateVO();
					calculateVO.setPkId(entity.getId() + "@" + fl);
					calculateVO.setDbegindate(sdf.format(entity.getRentDate()));
					calculateVO.setHtflh(fl);
					calculateVO.setNflag(0);
					calculateVO.setPkContract(entity.getContractId());
					calculateVO.setVurl(getWebSite(entity.getId()));
					calculateVO.setTs(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
				}else{
					calculateVO = calcVOMap.get(fl);
					detailVOS = calculateVO.getDetailList();
				}
				CalculateDetailVO detailVO = new CalculateDetailVO();
				detailVO.setPkId(entity.getId() + "@" + fl);
				detailVO.setPkSettleId(String.valueOf(dailyEntity.getId()));
				detailVO.setHtflh(fl);
				detailVO.setNstopnum("1".equals(dailyEntity.getUseStatus()) ? dailyEntity.getRentNum() : null);
				detailVO.setNhireworknum(dailyEntity.getRentNum());
				detailVO.setNhiredays(BigDecimal.valueOf(dailyEntity.getRentDayDate()));
				detailVO.setDbegindate(sdf.format(dailyEntity.getStartDate()));
				detailVO.setDenddate(sdf.format(dailyEntity.getEndDate()));
				detailVO.setPkInvcl(materialApi.queryCategoryById(dailyEntity.getMaterialTypeId()).getData().getSourceId());
				detailVO.setNsettlenum(dailyEntity.getRentNum());
				detailVO.setNinnum(dailyEntity.getRentNum());
				detailVO.setNoriginhireprice(dailyEntity.getUnitPrice());
				detailVO.setNoriginhiremny(dailyEntity.getDailyRentMny());
				detailVO.setNwastenum(null);
				detailVO.setNoutnum(null);
				detailVO.setPkContract(entity.getContractId());
				detailVO.setPkContractB(dailyEntity.getInfoId());
				detailVO.setPkInvbasdoc(null == dailyEntity.getMaterialId() ? getLastInMatByCty(dailyEntity.getMaterialTypeId(), entity.getProjectId(), entity.getContractId()) : dailyEntity.getMaterialSourceId());
				detailVO.setPkMeasdoc(dailyEntity.getUnitId());
				detailVO.setPkMeasdoc1(dailyEntity.getRealUnitId());
				detailVO.setNflag(0);
				detailVO.setTs(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
				detailVOS.add(detailVO);
				calculateVO.setDetailList(detailVOS);
				calcVOMap.put(fl, calculateVO);
			}
		}

		CalculateVO calculateVO = calcVOMap.entrySet().stream().findFirst().get().getValue();
		CalculateSettleVO settleVO = null;
		if (CollectionUtils.isNotEmpty(entity.getScrapList())) {
			settleVO = new CalculateSettleVO();
			settleVO.setPkId(calculateVO.getPkId());
			settleVO.setPkSettleId(settleVO.getPkId());
			settleVO.setNflag(0);
			settleVO.setPkContract(entity.getContractId());
			settleVO.setHtflh(calculateVO.getHtflh());
			settleVO.setSl(rateMap.get(calculateVO.getHtflh()));
			settleVO.setTs(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
			for (CalculateScrapEntity scrapEntity : entity.getScrapList()) {
				RestituteEntity restituteEntity = restituteService.selectById(scrapEntity.getSourceId());
				if(CollectionUtils.isNotEmpty(restituteEntity.getRestituteDetailList())){
					for(RestituteScrapEntity restituteScrapEntity : restituteEntity.getRestituteDetailList()){
						settleVO.setNoriginwastemny(ComputeUtil.safeAdd(settleVO.getNoriginwastemny(), restituteScrapEntity.getDamageMny()));
					}
				}
				if(CollectionUtils.isNotEmpty(restituteEntity.getRestituteMaintainList())){
					for(RestituteMaintainEntity maintainEntity : restituteEntity.getRestituteMaintainList()){
						settleVO.setNoriginrepairapmny(ComputeUtil.safeAdd(settleVO.getNoriginrepairapmny(), maintainEntity.getMaintainMny()));
						settleVO.setNoriginrepairiamny(ComputeUtil.safeAdd(settleVO.getNoriginotheriamny(), maintainEntity.getMaintainMny()));
					}
				}
				if(CollectionUtils.isNotEmpty(restituteEntity.getOtherList())){
					for(RestituteOtherEntity otherEntity : restituteEntity.getOtherList()){
						settleVO.setNoriginotheriamny(ComputeUtil.safeAdd(settleVO.getNoriginotheriamny(), otherEntity.getCurrentAmount()));
					}
				}
			}
		}

		if (CollectionUtils.isNotEmpty(entity.getOtherList())) {
			if (null == settleVO) {
				settleVO = new CalculateSettleVO();
				settleVO.setPkId(calculateVO.getPkId());
				settleVO.setPkSettleId(settleVO.getPkId());
				settleVO.setNflag(0);
				settleVO.setPkContract(entity.getContractId());
				settleVO.setHtflh(calculateVO.getHtflh());
				settleVO.setSl(rateMap.get(calculateVO.getHtflh()));
				settleVO.setTs(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
			}
			if(CollectionUtils.isNotEmpty(entity.getOtherList())){
				for(CalculateOtherEntity otherEntity : entity.getOtherList()){
					settleVO.setNoriginotheriamny(ComputeUtil.safeAdd(settleVO.getNoriginotheriamny(), otherEntity.getMny()));
				}
			}
		}

		if (null != settleVO) {
			calculateVO.setSettleList(Arrays.asList(settleVO));
			calcVOMap.put(calculateVO.getHtflh(), calculateVO);
		}

		logger.error(JSONObject.toJSONString(new ArrayList<>(calcVOMap.values())));
		CommonResponse<String> response = calculateSyncApi.sync(new ArrayList<>(calcVOMap.values()));
		if(!response.isSuccess()){
			logger.error(response.getMsg());
			throw new BusinessException("推送NC中间表失败");
		}
	}

	/**
	 * 生成跳转地址
	 * @param id
	 * @return
	 */
	private String getWebSite(Long id) {
		Long userid = InvocationInfoProxy.getUserid();
		String targeturl = BASE_HOST + "cscec5b-rmat-frontend/#/calculate/autoCard?id=" + id;// 目标路径
		logger.info("--->> targeturl: " + targeturl);
		try {
			targeturl = URLEncoder.encode(targeturl,"utf-8");
		} catch (UnsupportedEncodingException e) {
			logger.error(e.getMessage());
		}
		String webSite = BASE_HOST + "portal/sso/index?userid=" + userid + "&targeturl=" + targeturl;
		logger.info("--->> 生成租金计算单跳转地址: " + webSite);
		return webSite;
	}

	private String getLastInMatByCty(Long categoryId, Long projectId, String pkContract){
		LambdaQueryWrapper<RmatFlowEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(RmatFlowEntity::getEffectiveState, 1);
		queryWrapper.eq(RmatFlowEntity::getFlowType, 1);
		queryWrapper.eq(RmatFlowEntity::getProjectId, projectId);
		queryWrapper.eq(RmatFlowEntity::getContractId, pkContract);
		queryWrapper.eq(RmatFlowEntity::getMaterialTypeId, categoryId);
		queryWrapper.orderByDesc(RmatFlowEntity::getEffectiveDate);
		List<RmatFlowEntity> list = rmatFlowService.list(queryWrapper);
		return CollectionUtils.isNotEmpty(list) ? list.get(0).getMaterialSourceId() : null;
	}

	private void writeSettleFlag(CalculateEntity entity, Integer settleFlag) {
		List<CalculateScrapEntity> scrapList = entity.getScrapList();
		List<Long> ids = scrapList.stream().map(CalculateScrapEntity::getSourceId).collect(Collectors.toList());
		if (ListUtil.isNotEmpty(ids)) {
			LambdaUpdateWrapper<RestituteEntity> ew = new LambdaUpdateWrapper<>();
			ew.set(RestituteEntity::getSettleFlag, settleFlag);
			ew.in(RestituteEntity::getId, ids);
			restituteService.update(ew);
		}
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		CalculateEntity entity = service.selectById(billId);

		CommonResponse<String> response = calculateSyncApi.delSync(billId);
		if (!response.isSuccess()) {
			logger.error(response.getMsg());
			throw new BusinessException("删除NC中间表失败," + response.getMsg());
		}

		// 回写退赔单、结算单 结算状态
		this.writeSettleFlag(entity, 0);

		return CommonResponse.success();
	}

}
