package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.dataexchange.api.ICmContractInfoApi;
import com.ejianc.business.dataexchange.vo.CmContractInfoVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.rmat.bean.*;
import com.ejianc.business.rmat.service.ICalculateService;
import com.ejianc.business.rmat.service.IReportDailyService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.vo.DailyVO;
import com.ejianc.business.rmat.vo.ReportDailyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rmat.mapper.DailyMapper;
import com.ejianc.business.rmat.service.IDailyService;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 日租金
 *
 * @author generator
 *
 */
@Service("dailyService")
public class DailyServiceImpl extends BaseServiceImpl<DailyMapper, DailyEntity> implements IDailyService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String RMAT_DAILY = "RMAT_DAILY";

    @Autowired
    private IRmatFlowService rmatFlowService;
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ICmContractInfoApi cmContractInfoApi;
    @Autowired
    private ICalculateService calculateService;
    @Autowired
    private IReportDailyService reportDailyService;
    @Override
    public DailyVO saveOrUpdate(DailyVO dailyVO) {
        DailyEntity entity = BeanMapper.map(dailyVO, DailyEntity.class);
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RMAT_DAILY, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        saveOrUpdate(entity, false);
        return BeanMapper.map(entity, DailyVO.class);
    }

    @Override
    public CommonResponse<String> generation(HttpServletRequest request) {
        logger.info("生成日租金报表开始》》》》》》》》》》》》");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.DATE, -1);
        String beginTime = df.format(calendar.getTime()) + " 00:00:00";
        String endTime = df.format(calendar.getTime()) + " 23:59:59";

        // 手动调用时传的时间参数（正式的调度中心可忽略）
        if (request.getParameter("beginTime") != null) {
            beginTime = request.getParameter("beginTime");
        }
        if (request.getParameter("endTime") != null) {
            endTime = request.getParameter("endTime");
        }
        logger.info("beginTime------->" + beginTime);
        logger.info("endTime------->" + endTime);

        Map<Long, DailyEntity> map = new HashMap<>();
        Map<String, CmContractInfoVO> infoMap = new HashMap<>();
        LambdaQueryWrapper<RmatFlowEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(RmatFlowEntity::getEffectiveState, 1);
        queryWrapper.eq(RmatFlowEntity::getFlowType, 1);
        queryWrapper.between(RmatFlowEntity::getDetailDate, beginTime, endTime);
        List<RmatFlowEntity> list = rmatFlowService.list(queryWrapper);
        Map<String, RmatFlowEntity> newMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(list)) {
            for(RmatFlowEntity flowEntity : list){
                RmatFlowEntity mapFlowEntity = null;
                String key = flowEntity.getInfoId() + "@" + flowEntity.getMaterialId();
                if (newMap.containsKey(key)) {
                    mapFlowEntity = newMap.get(key);
                    mapFlowEntity.setRentNum(ComputeUtil.safeAdd(mapFlowEntity.getRentNum(), flowEntity.getRentNum()));
                }else{
                    mapFlowEntity = flowEntity;
                }
                newMap.put(key, mapFlowEntity);
            }
        }

        list = new ArrayList<>(newMap.values());

        for(RmatFlowEntity flowEntity : list){
            DailyEntity dailyEntity = null;
            if(!map.containsKey(flowEntity.getProjectId())){
                dailyEntity = BeanMapper.map(flowEntity, DailyEntity.class);
                dailyEntity.setId(IdWorker.getId());
                dailyEntity.setRentDate(calendar.getTime());
                dailyEntity.setCreateTime(null);
                dailyEntity.setCreateUserCode(null);
                dailyEntity.setUpdateTime(null);
                dailyEntity.setUpdateUserCode(null);
                dailyEntity.setVersion(1);
                dailyEntity.setMemo(null);

                CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(RMAT_DAILY, InvocationInfoProxy.getTenantid());
                if (billCode.isSuccess()) {
                    dailyEntity.setBillCode(billCode.getData());
                } else {
                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                }

                dailyEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
                CommonResponse<List<ProjectRegisterVO>> commonResponse = projectApi.queryProjectByIds(Arrays.asList(new Long[]{flowEntity.getProjectId()}));
                if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty(commonResponse.getData())) {
                    ProjectRegisterVO projectRegisterVO = commonResponse.getData().get(0);
                    dailyEntity.setProjectCode(projectRegisterVO.getCode());
                    dailyEntity.setProjectSourceId(projectRegisterVO.getSourceId());
                    dailyEntity.setRealCorpId(projectRegisterVO.getRealCorpId());
                    dailyEntity.setRealNcCorp(projectRegisterVO.getRealNcCorp());
                    dailyEntity.setRealCorpName(projectRegisterVO.getRealCorpName());

                    CommonResponse<OrgVO> response = orgApi.getOneById(projectRegisterVO.getOrgId());
                    if (response.isSuccess() && response.getData() != null) {
                        OrgVO orgVO = response.getData();
                        dailyEntity.setParentOrgId(orgVO.getId());
                        dailyEntity.setParentOrgCode(orgVO.getCode());
                        dailyEntity.setParentOrgName(orgVO.getName());
                    }
                }
            }else {
                dailyEntity = map.get(flowEntity.getProjectId());
            }

            DailyDetailEntity detailEntity = BeanMapper.map(flowEntity, DailyDetailEntity.class);
            detailEntity.setId(IdWorker.getId());
            detailEntity.setDailyId(dailyEntity.getId());
            detailEntity.setCreateTime(null);
            detailEntity.setCreateUserCode(null);
            detailEntity.setUpdateTime(null);
            detailEntity.setUpdateUserCode(null);
            detailEntity.setVersion(1);
            detailEntity.setMemo(null);

            if(!infoMap.containsKey(flowEntity.getInfoId())){
                CommonResponse<List<CmContractInfoVO>> response = cmContractInfoApi.queryLeaseContractInfoById(flowEntity.getContractId());
                if (response.isSuccess() && CollectionUtils.isNotEmpty(response.getData())) {
                    for (CmContractInfoVO infoVO : response.getData()) {
                        infoMap.put(infoVO.getPkContractinfo(), infoVO);
                    }
                }
            }
            CmContractInfoVO infoVO = infoMap.get(detailEntity.getInfoId());
            detailEntity.setRentPrice(BigDecimal.valueOf(infoVO.getHireprice()));
            detailEntity.setRentTaxPrice(BigDecimal.valueOf(infoVO.getTaxhireprice()));
            detailEntity.setRentMny(ComputeUtil.safeMultiply(detailEntity.getRentNum(), detailEntity.getRentPrice()));
            detailEntity.setRentTaxMny(ComputeUtil.safeMultiply(detailEntity.getRentNum(), detailEntity.getRentTaxPrice()));
            detailEntity.setRentTax(ComputeUtil.safeSub(detailEntity.getRentTaxMny(), detailEntity.getRentMny()));

            List<DailyDetailEntity> detailList = null != dailyEntity.getDetailList() ? dailyEntity.getDetailList() : new ArrayList<>();
            detailList.add(detailEntity);
            dailyEntity.setDetailList(detailList);

            map.put(dailyEntity.getProjectId(), dailyEntity);
        }

        if (CollectionUtils.isNotEmpty(map.values())) {
            for (Long projectId : map.keySet()) {
                DailyEntity dailyEntity = map.get(projectId);
                LambdaQueryWrapper<CalculateEntity> query = new LambdaQueryWrapper<>();
                query.eq(CalculateEntity::getProjectId, dailyEntity.getProjectId());
                query.eq(CalculateEntity::getRentDate, dailyEntity.getRentDate());
                query.eq(CalculateEntity::getBillState, "1,3");
                List<CalculateEntity> calculateEntities = calculateService.list(query);
                for (CalculateEntity calculateEntity : calculateEntities) {
                    dailyEntity.setCalcMny(ComputeUtil.safeAdd(dailyEntity.getCalcMny(), calculateEntity.getRentMny()));
                    dailyEntity.setCalcTaxMny(ComputeUtil.safeAdd(dailyEntity.getCalcTaxMny(), calculateEntity.getRentTaxMny()));
                    dailyEntity.setCalcTax(ComputeUtil.safeAdd(dailyEntity.getCalcTax(), calculateEntity.getRentTax()));
                }

                for(DailyDetailEntity detailEntity : dailyEntity.getDetailList()){
                    dailyEntity.setRentMny(ComputeUtil.safeAdd(dailyEntity.getRentMny(), detailEntity.getRentMny()));
                    dailyEntity.setRentTaxMny(ComputeUtil.safeAdd(dailyEntity.getRentTaxMny(), detailEntity.getRentTaxMny()));
                    dailyEntity.setRentTax(ComputeUtil.safeAdd(dailyEntity.getRentTax(), detailEntity.getRentTax()));
                }
                saveOrUpdate(dailyEntity, false);
            }
        }

        reportDailyService.makeReportDailyData(new ArrayList<>(map.values()));

        return CommonResponse.success("执行成功");
    }
}
