package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.rmat.bean.*;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.consts.TransFlowTypeEnum;
import com.ejianc.business.rmat.service.*;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("exit") 
public class ExitBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IExitService service;

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private CommonSupportService commonSupportService;

	@Autowired
	private ITransferFlowService transferFlowService;

	@Autowired
	private ICoordinationSetService coordinationSetService;

	@Autowired
	private ICalculateDailyService calculateDailyService;

	@Autowired
	private ICalculateOtherService calculateOtherService;

	@Autowired
	private ICalculateScrapService calculateScrapService;

	@Autowired
	private IRmatFlowService flowService;


	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("提交前回调------------------------------------------------");
		ExitEntity exitEntity = service.selectById(billId);
		if(CollectionUtils.isEmpty(exitEntity.getExitDetail())){
			throw new BusinessException("明细数据为空不允许提交！");
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		ExitEntity exitEntity = service.selectById(billId);
		logger.info("提交完回调------------------------------------------------");

		//已拒绝,重新提交需要改为未确认状态
		if (2 == exitEntity.getConfirmFlag()) {
			exitEntity.setConfirmFlag(0);
		}
		exitEntity.setCommitId(InvocationInfoProxy.getUserid());
		service.saveOrUpdate(exitEntity,false);
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {

		ExitEntity exitEntity = service.selectById(billId);
		List<ExitSupplierEntity> entityList = exitEntity.getExitSupplierList();
		for(ExitDetailEntity exitDetailEntity : exitEntity.getExitDetail()){
			entityList.addAll(exitDetailEntity.getExitSupplierList());
		}
		if(CollectionUtils.isNotEmpty(exitEntity.getExitSupplierList())){
			//推送台账流水
			if(!transferFlowService.insertExitFlow(exitEntity, TransFlowTypeEnum.退场.getFlowType(), RmatCommonConsts.YES)){
				throw new BusinessException("单据推送台账流水失败！");
			}
		}
		// 推送流水生效
		if(!flowService.insertExitFlow(exitEntity, billTypeCode, RmatCommonConsts.YES)){
			return CommonResponse.error("审批回调失败，单据推送流水失败！");
		}
		//查询协同设置
		Boolean falg = coordinationSetService.querySupplyByOrgId(exitEntity.getOrgId());
		if(falg) {
			//推送供方
			Map<String, String> headers = new HashMap<>();
			CommonResponse<String> tokenres = commonSupportService.getAccessToken(headers);
			if (tokenres.isSuccess()) {
				logger.info("获取供方token--" + headers);
				CommonResponse<String> pushres = service.pushConfirmEntity(headers, exitEntity);
				logger.info("获取推送供方结果--" + pushres);
				if (pushres.isSuccess()) {
					//推送成功后处理逻辑
					if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state) {
						//已拒绝,重新提交需要改为未确认状态
						if (2 == exitEntity.getConfirmFlag()) {
							exitEntity.setConfirmFlag(0);
						}
						exitEntity.setCommitId(InvocationInfoProxy.getUserid());
					}
					service.saveOrUpdate(exitEntity, false);
				} else {
					return pushres;
				}
			} else {
				return tokenres;
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		ExitEntity exitEntity = service.selectById(billId);
		//查询协同设置
		Boolean falg = coordinationSetService.querySupplyByOrgId(exitEntity.getOrgId());
		if(falg) {
			if(exitEntity.getConfirmFlag() == 1){
				return CommonResponse.error("退场单供方已确认不支持撤回!");
			}else{
				//推送供方
				Map<String, String> headers = new HashMap<>();
				CommonResponse<String> tokenres = commonSupportService.getAccessToken(headers);
				if (tokenres.isSuccess()) {
					logger.info("获取供方token--" + headers);
					CommonResponse<String> pushres = service.pushDelete(headers, exitEntity);
					logger.info("获取推送供方结果--" + pushres);
					if (pushres.isSuccess()) {
						/*//推送成功后处理逻辑
						if (BillStateEnum.COMMITED_STATE.getBillStateCode() == state) {
							//已拒绝,重新提交需要改为未确认状态
							if (2 == exitEntity.getConfirmFlag()) {
								exitEntity.setConfirmFlag(0);
							}
							exitEntity.setCommitId(InvocationInfoProxy.getUserid());
						}
						service.saveOrUpdate(exitEntity, false);*/
					} else {
						return pushres;
					}
				} else {
					return tokenres;
				}
			}
		}else{
			//看租金计算单是否引用
			//退场单如果未引用支持撤回
			LambdaQueryWrapper<CalculateDailyEntity> lambda = Wrappers.<CalculateDailyEntity>lambdaQuery();
			lambda.eq(CalculateDailyEntity::getSourceId,exitEntity.getId());
			List<CalculateDailyEntity> calculateDailyEntityList = calculateDailyService.list(lambda);
			if(CollectionUtils.isNotEmpty(calculateDailyEntityList)){
				return CommonResponse.error("退场单已被租金计算单引用不支持撤回!");
			}
			LambdaQueryWrapper<CalculateOtherEntity> lambdao = Wrappers.<CalculateOtherEntity>lambdaQuery();
			lambdao.eq(CalculateOtherEntity::getSourceId,exitEntity.getId());
			List<CalculateOtherEntity> calculateOtherEntityList = calculateOtherService.list(lambdao);
			if(CollectionUtils.isNotEmpty(calculateOtherEntityList)){
				return CommonResponse.error("退场单已被租金计算单引用不支持撤回!");
			}
			LambdaQueryWrapper<CalculateScrapEntity> lambdsad = Wrappers.<CalculateScrapEntity>lambdaQuery();
			lambdsad.eq(CalculateScrapEntity::getSourceId,exitEntity.getId());
			List<CalculateScrapEntity> calculateScrapEntityList = calculateScrapService.list(lambdsad);
			if(CollectionUtils.isNotEmpty(calculateScrapEntityList)){
				return CommonResponse.error("退场单已被租金计算单引用不支持撤回!");
			}


		}
		// 推送流水生效
		if(!flowService.insertExitFlow(exitEntity, billTypeCode, RmatCommonConsts.NO)){
			return CommonResponse.error("审批回调失败，单据推送流水失败！");
		}
		List<ExitSupplierEntity> entityList = exitEntity.getExitSupplierList();
		for(ExitDetailEntity exitDetailEntity : exitEntity.getExitDetail()){
			entityList.addAll(exitDetailEntity.getExitSupplierList());
		}
		if(CollectionUtils.isNotEmpty(exitEntity.getExitSupplierList())){
			//弃审推送台账流水
			if(!transferFlowService.insertExitFlow(exitEntity, TransFlowTypeEnum.退场.getFlowType(), RmatCommonConsts.TWO)){
				throw new BusinessException("单据推送台账流水失败！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
