package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.rmat.bean.DailyEntity;
import com.ejianc.business.rmat.vo.ReportDailyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.rmat.mapper.ReportDailyMapper;
import com.ejianc.business.rmat.bean.ReportDailyEntity;
import com.ejianc.business.rmat.service.IReportDailyService;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 日租金报表
 *
 * @author generator
 *
 */
@Service("reportDailyService")
public class ReportDailyServiceImpl extends BaseServiceImpl<ReportDailyMapper, ReportDailyEntity> implements IReportDailyService{

    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IBillCodeApi billCodeApi;

    private static final String REPORT_RMAT_DAILY = "REPORT_RMAT_DAILY";

    @Override
    public ReportDailyVO saveOrUpdate(ReportDailyVO reportDailyVO) {
        ReportDailyEntity entity = BeanMapper.map(reportDailyVO, ReportDailyEntity.class);
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(REPORT_RMAT_DAILY, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ReportDailyVO.class);
    }

    @Override
    public void makeReportDailyData(List<DailyEntity> dailyList) {
        List<ReportDailyEntity> reportList = list();
        Map<Long, ReportDailyEntity> reportMap = reportList.stream().collect(Collectors.toMap(ReportDailyEntity::getProjectId, Function.identity(), (key1, key2) -> key1));
        List<ReportDailyVO> caclMny = baseMapper.getCaclMny();
        List<ReportDailyVO> restitueMny = baseMapper.getRestitueMny();
        List<ReportDailyVO> repairMny = baseMapper.getRepairMny();
        List<ReportDailyVO> pcOtherMny = baseMapper.getPcOtherMny();
        List<ReportDailyVO> calcOtherMny = baseMapper.getCalcOtherMny();

        Map<Long, ReportDailyVO> newReportMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(dailyList)) {
            for (DailyEntity dailyEntity : dailyList) {
                ReportDailyVO reportVO =  new ReportDailyVO();
                reportVO.setProjectId(dailyEntity.getProjectId());
                newReportMap.put(dailyEntity.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(caclMny)) {
            for (ReportDailyVO reportDailyVO : caclMny) {
                ReportDailyVO reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? newReportMap.get(reportDailyVO.getProjectId()) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumRentTaxMny(ComputeUtil.safeAdd(reportVO.getSumRentTaxMny(), reportDailyVO.getSumRentTaxMny()));
                reportVO.setSumRentMny(ComputeUtil.safeAdd(reportVO.getSumRentMny(), reportDailyVO.getSumRentMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(restitueMny)) {
            for (ReportDailyVO reportDailyVO : restitueMny) {
                ReportDailyVO reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? newReportMap.get(reportDailyVO.getProjectId()) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumScrapTaxMny(ComputeUtil.safeAdd(reportVO.getSumScrapTaxMny(), reportDailyVO.getSumScrapTaxMny()));
                reportVO.setSumScrapMny(ComputeUtil.safeAdd(reportVO.getSumScrapMny(), reportDailyVO.getSumScrapMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(repairMny)) {
            for (ReportDailyVO reportDailyVO : repairMny) {
                ReportDailyVO reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? newReportMap.get(reportDailyVO.getProjectId()) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumRepairTaxMny(ComputeUtil.safeAdd(reportVO.getSumRepairTaxMny(), reportDailyVO.getSumRepairTaxMny()));
                reportVO.setSumRepairMny(ComputeUtil.safeAdd(reportVO.getSumRepairMny(), reportDailyVO.getSumRepairMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(pcOtherMny)) {
            for (ReportDailyVO reportDailyVO : pcOtherMny) {
                ReportDailyVO reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? newReportMap.get(reportDailyVO.getProjectId()) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumOtherTaxMny(ComputeUtil.safeAdd(reportVO.getSumOtherTaxMny(), reportDailyVO.getSumOtherTaxMny()));
                reportVO.setSumOtherMny(ComputeUtil.safeAdd(reportVO.getSumOtherMny(), reportDailyVO.getSumOtherMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(calcOtherMny)) {
            for (ReportDailyVO reportDailyVO : calcOtherMny) {
                ReportDailyVO reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? newReportMap.get(reportDailyVO.getProjectId()) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumOtherTaxMny(ComputeUtil.safeAdd(reportVO.getSumOtherTaxMny(), reportDailyVO.getSumOtherTaxMny()));
                reportVO.setSumOtherMny(ComputeUtil.safeAdd(reportVO.getSumOtherMny(), reportDailyVO.getSumOtherMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        List<ReportDailyEntity> reportSaveList = new ArrayList<>();
        for (Long key : newReportMap.keySet()) {
            ReportDailyVO reportDailyVO = newReportMap.get(key);
            ReportDailyEntity reportDailyEntity = null;
            if (reportMap.containsKey(key)) {
                reportDailyEntity = reportMap.get(key);
            }else{
                reportDailyEntity = new ReportDailyEntity();
                reportDailyEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
                reportDailyEntity.setProjectId(reportDailyVO.getProjectId());
                if(StringUtils.isEmpty(reportDailyEntity.getBillCode())){
                    CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(REPORT_RMAT_DAILY, InvocationInfoProxy.getTenantid());
                    if(billCode.isSuccess()) {
                        reportDailyEntity.setBillCode(billCode.getData());
                    }else{
                        throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                    }
                }
                CommonResponse<List<ProjectRegisterVO>> commonResponse = projectApi.queryProjectByIds(Arrays.asList(new Long[]{reportDailyVO.getProjectId()}));
                if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty(commonResponse.getData())) {
                    ProjectRegisterVO projectRegisterVO = commonResponse.getData().get(0);
                    reportDailyEntity.setProjectCode(projectRegisterVO.getCode());
                    reportDailyEntity.setProjectName(projectRegisterVO.getName());
                    reportDailyEntity.setProjectSourceId(projectRegisterVO.getSourceId());
                    reportDailyEntity.setOrgId(projectRegisterVO.getProjectDepartmentId());
                    reportDailyEntity.setOrgName(projectRegisterVO.getName());
                    reportDailyEntity.setRealCorpId(projectRegisterVO.getRealCorpId());
                    reportDailyEntity.setRealNcCorp(projectRegisterVO.getRealNcCorp());
                    reportDailyEntity.setRealCorpName(projectRegisterVO.getRealCorpName());

                    CommonResponse<OrgVO> response = orgApi.getOneById(projectRegisterVO.getOrgId());
                    if (response.isSuccess() && response.getData() != null) {
                        OrgVO orgVO = response.getData();
                        reportDailyEntity.setParentOrgId(orgVO.getId());
                        reportDailyEntity.setParentOrgCode(orgVO.getCode());
                        reportDailyEntity.setParentOrgName(orgVO.getName());
                    }
                }
            }
            reportDailyEntity.setSumRentTaxMny(reportDailyVO.getSumRentTaxMny());
            reportDailyEntity.setSumRentMny(reportDailyVO.getSumRentMny());
            reportDailyEntity.setSumScrapTaxMny(reportDailyVO.getSumScrapTaxMny());
            reportDailyEntity.setSumScrapMny(reportDailyVO.getSumScrapMny());
            reportDailyEntity.setSumRepairTaxMny(reportDailyVO.getSumRepairTaxMny());
            reportDailyEntity.setSumRepairMny(reportDailyVO.getSumRepairMny());
            reportDailyEntity.setSumOtherTaxMny(reportDailyVO.getSumOtherTaxMny());
            reportDailyEntity.setSumOtherMny(reportDailyVO.getSumOtherMny());
            reportSaveList.add(reportDailyEntity);
        }
        if (CollectionUtils.isNotEmpty(reportSaveList)) {
            saveOrUpdateBatch(reportSaveList, reportSaveList.size());
        }
    }
}
