/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.rmat.bean.CoordinationSetEntity;
import com.ejianc.business.rmat.mapper.CoordinationSetMapper;
import com.ejianc.business.rmat.service.ICoordinationSetService;
import com.ejianc.business.rmat.vo.CoordinationSetVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="coordinationSetService")
public class CoordinationSetServiceImpl
extends BaseServiceImpl<CoordinationSetMapper, CoordinationSetEntity>
implements ICoordinationSetService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public CoordinationSetVO saveOrUpdate(CoordinationSetVO saveOrUpdateVO) {
        CoordinationSetVO coordinationSetVO = new CoordinationSetVO();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CoordinationSetEntity::getOrgId, (Object)saveOrUpdateVO.getOrgId());
        List entities = super.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(saveOrUpdateVO.getSupplyStatus() != null, CoordinationSetEntity::getSupplyStatus, (Object)saveOrUpdateVO.getSupplyStatus());
            updateWrapper.set(saveOrUpdateVO.getMandatoryStatus() != null, CoordinationSetEntity::getMandatoryStatus, (Object)saveOrUpdateVO.getMandatoryStatus());
            updateWrapper.eq(CoordinationSetEntity::getOrgId, (Object)saveOrUpdateVO.getOrgId());
            super.update((Wrapper)updateWrapper);
            for (CoordinationSetEntity coordinationSetEntity : entities) {
                coordinationSetVO = (CoordinationSetVO)BeanMapper.map((Object)((Object)coordinationSetEntity), CoordinationSetVO.class);
            }
        } else {
            CoordinationSetEntity coordinationSetEntity = (CoordinationSetEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CoordinationSetEntity.class));
            coordinationSetEntity.setOrgInnerCode(((OrgVO)this.iOrgApi.detailById(InvocationInfoProxy.getOrgId()).getData()).getInnerCode());
            super.saveOrUpdate((Object)coordinationSetEntity);
            coordinationSetVO = (CoordinationSetVO)BeanMapper.map((Object)((Object)coordinationSetEntity), CoordinationSetVO.class);
        }
        return coordinationSetVO;
    }

    @Override
    public Boolean querySupplyByOrgId(Long orgId) {
        Object[] orgInnerCode;
        List list;
        CommonResponse orgVO = this.iOrgApi.detailById(orgId);
        if (orgVO != null && CollectionUtils.isNotEmpty((Collection)(list = this.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"org_id", orgInnerCode = ((OrgVO)orgVO.getData()).getInnerCode().split("\\|"))).eq((Object)"supply_status", (Object)0))))) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean queryMandatoryByOrgId(Long orgId) {
        Object[] orgInnerCode;
        List list;
        this.logger.info("orgId------" + JSONObject.toJSONString((Object)orgId));
        CommonResponse orgVO = this.iOrgApi.detailById(orgId);
        this.logger.info("orgVO------" + JSONObject.toJSONString((Object)orgVO));
        if (orgVO != null && CollectionUtils.isNotEmpty((Collection)(list = this.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"org_id", orgInnerCode = ((OrgVO)orgVO.getData()).getInnerCode().split("\\|"))).eq((Object)"mandatory_status", (Object)0))))) {
            return true;
        }
        return false;
    }
}

