/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.dataexchange.api.ICmContractApi;
import com.ejianc.business.dataexchange.vo.CmContract;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.rmat.bean.TransferFlowEntity;
import com.ejianc.business.rmat.consts.TransFlowTypeEnum;
import com.ejianc.business.rmat.service.ITransferFlowService;
import com.ejianc.business.rmat.util.PageUtil;
import com.ejianc.business.rmat.vo.TransferFlowVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"transferFlow"})
public class TransferFlowController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ITransferFlowService service;
    @Autowired
    private ICmContractApi cmContractApi;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private IProjectApi projectApi;

    @PostMapping(value={"/insertFlow"})
    public CommonResponse<Boolean> insertFlow(@RequestBody List<TransferFlowVO> vos) {
        Boolean flag = this.service.insertFlow(vos, TransFlowTypeEnum.\u9a8c\u6536.getFlowType());
        if (Boolean.FALSE.equals(flag)) {
            return CommonResponse.error((String)"\u63d2\u5165\u6d41\u6c34\u6570\u636e\u5931\u8d25\uff01");
        }
        return CommonResponse.success((String)"\u63d2\u5165\u6d41\u6c34\u6570\u636e\u6210\u529f\uff01");
    }

    @GetMapping(value={"/queryDetail"})
    public CommonResponse<TransferFlowVO> queryDetail(@RequestParam String id) {
        List list = this.service.list((Wrapper)new QueryWrapper().eq((Object)"query_id", (Object)id));
        TransferFlowVO vo = new TransferFlowVO();
        TransferFlowEntity entity = (TransferFlowEntity)((Object)list.get(0));
        vo.setProjectId(entity.getProjectId());
        vo.setSupplierId(entity.getSupplierId());
        vo.setProjectName(entity.getProjectName());
        vo.setProjectCode(entity.getProjectCode() != null ? entity.getProjectCode() : null);
        vo.setSupplierName(entity.getSupplierName());
        vo.setOrgId(entity.getOrgId());
        vo.setOrgName(entity.getOrgName());
        vo.setOrgCode(entity.getOrgCode() != null ? entity.getOrgCode() : null);
        vo.setParentOrgId(entity.getParentOrgId());
        vo.setParentOrgCode(entity.getParentOrgCode() != null ? entity.getParentOrgCode() : null);
        vo.setParentOrgName(entity.getParentOrgName() != null ? entity.getParentOrgName() : null);
        vo.setQueryId(entity.getProjectId() + "_" + entity.getSupplierId());
        List details = vo.getDetailList();
        Map<Long, List<TransferFlowEntity>> flowMap = list.stream().collect(Collectors.groupingBy(TransferFlowEntity::getMaterialId));
        for (Map.Entry<Long, List<TransferFlowEntity>> entry : flowMap.entrySet()) {
            TransferFlowVO fvo = this.service.getFlowData(entry.getValue());
            details.add(fvo);
        }
        vo.setDetailList(details);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @GetMapping(value={"/queryRmatDetail"})
    public CommonResponse<List<TransferFlowVO>> queryRmatDetail(@RequestParam String queryId, @RequestParam Long materialId) {
        List list = this.service.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"query_id", (Object)queryId)).eq((Object)"material_id", (Object)materialId));
        list.forEach(e -> {
            switch (e.getFlowType()) {
                case "1": {
                    e.setSupplierId(e.getSupplierId() != null ? e.getSupplierId() : e.getProjectId());
                    e.setSupplierName(e.getSupplierName() != null ? e.getSupplierName() : e.getProjectName());
                    break;
                }
                case "3": {
                    e.setSupplierId(e.getInOutId() != null ? e.getInOutId() : e.getProjectId());
                    e.setSupplierName(e.getInOutName() != null ? e.getInOutName() : e.getProjectName());
                    break;
                }
                case "4": {
                    e.setSupplierId(e.getInOutId());
                    e.setSupplierName(e.getInOutName());
                    break;
                }
            }
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)BeanMapper.mapList((Iterable)list, TransferFlowVO.class));
    }

    @PostMapping(value={"/delete"})
    public CommonResponse<String> delete(@RequestBody List<Long> sourceIds, @RequestParam Integer flowType) {
        return CommonResponse.success((String)this.service.delete(sourceIds, flowType));
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<TransferFlowVO>> queryList(@RequestBody QueryParam param) {
        int pageNumber = param.getPageIndex();
        int pageSize = param.getPageSize();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        param.setPageIndex(1);
        param.setPageSize(-1);
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page();
        List flowVo = BeanMapper.mapList((Iterable)page.getRecords(), TransferFlowVO.class);
        List<TransferFlowVO> list = this.service.getListData(flowVo);
        pageData.setCurrent((long)pageNumber);
        pageData.setSize((long)pageSize);
        pageData.setTotal((long)list.size());
        list = PageUtil.listToPage(list, pageNumber, pageSize);
        pageData.setRecords(list);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (!param.getParams().containsKey("orgId")) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        List list = this.service.queryList(param);
        List<TransferFlowVO> flowVoS = this.service.getListData(BeanMapper.mapList((Iterable)list, TransferFlowVO.class));
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", BeanMapper.mapList(flowVoS, TransferFlowEntity.class));
        ExcelExport.getInstance().export("TransferFlow-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refTransferFlowData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<TransferFlowVO>> refTransferFlowData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getFuzzyFields().add("materialCode");
        param.getFuzzyFields().add("materialName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSON.parseObject((String)condition, Map.class);
            if (null == conditionMap.get("supplierId")) {
                return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)new Page());
            }
            Long supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
            param.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
            if (null != conditionMap.get("projectId")) {
                Long projectId = Long.valueOf(conditionMap.get("projectId").toString());
                param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
            }
        }
        IPage page = this.service.queryPage(param, false);
        ArrayList<TransferFlowVO> flows = new ArrayList<TransferFlowVO>();
        Map<Long, List<TransferFlowEntity>> flowMap = page.getRecords().stream().collect(Collectors.groupingBy(TransferFlowEntity::getMaterialId));
        for (Map.Entry<Long, List<TransferFlowEntity>> entry : flowMap.entrySet()) {
            TransferFlowVO fvo = this.service.getFlowData(entry.getValue());
            if (fvo.getRealOnHandNums().compareTo(BigDecimal.ZERO) <= 0) continue;
            flows.add(fvo);
        }
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(flows);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @GetMapping(value={"/subSupplierRef"})
    @ResponseBody
    public CommonResponse<IPage<SupplierVO>> subSupplierRef(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        Long projectId = null;
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            Map conditionMap = (Map)JSON.parseObject((String)condition, Map.class);
            if (null != conditionMap.get("projectId")) {
                projectId = Long.valueOf(conditionMap.get("projectId").toString());
            }
        } else {
            return CommonResponse.success((String)"\u5206\u5305\u4f9b\u5e94\u5546\u53c2\u7167\u6210\u529f\uff01", (Object)new Page());
        }
        CommonResponse response = this.projectApi.queryProjectByIds(Arrays.asList(projectId));
        CommonResponse listCommonResponse = this.cmContractApi.querySubContractList(((ProjectRegisterVO)((List)response.getData()).get(0)).getSourceId(), searchText);
        List<SupplierVO> supplierVOS = new ArrayList();
        if (listCommonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)listCommonResponse.getData()))) {
            Set supList = ((List)listCommonResponse.getData()).stream().map(CmContract::getPkSupplier).collect(Collectors.toSet());
            for (String key : supList) {
                SupplierVO supplier = (SupplierVO)this.supplierApi.queryBySourceId(key).getData();
                if (supplier == null) continue;
                supplierVOS.add(supplier);
            }
        }
        Page pageData = new Page();
        pageData.setCurrent((long)pageNumber.intValue());
        pageData.setSize((long)pageSize.intValue());
        pageData.setTotal((long)supplierVOS.size());
        supplierVOS = PageUtil.listToPage(supplierVOS, pageNumber, pageSize);
        pageData.setRecords(supplierVOS);
        return CommonResponse.success((String)"\u5206\u5305\u4f9b\u5e94\u5546\u53c2\u7167\u6210\u529f\uff01", (Object)pageData);
    }
}

