/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.rmat.bean.PeriodDetailEntity;
import com.ejianc.business.rmat.bean.PeriodEntity;
import com.ejianc.business.rmat.bean.RmatFlowEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.consts.FlowTypeEnum;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.mapper.PeriodMapper;
import com.ejianc.business.rmat.service.IPeriodService;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.vo.PeriodVO;
import com.ejianc.business.rmat.vo.PriceFlowVO;
import com.ejianc.business.rmat.vo.RmatFlowVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="periodService")
public class PeriodServiceImpl
extends BaseServiceImpl<PeriodMapper, PeriodEntity>
implements IPeriodService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRmatFlowService rmatFlowService;
    @Autowired
    private IPriceFlowService priceFlowService;
    private static final String BILL_CODE = "RMAT_PERIOD";

    @Override
    public PeriodVO saveOrUpdate(PeriodVO periodVO) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.ne(null != periodVO.getId(), RmatFlowEntity::getSourceId, (Object)periodVO.getId());
        query.eq(RmatFlowEntity::getProjectId, (Object)periodVO.getProjectId());
        query.eq(RmatFlowEntity::getContractId, (Object)periodVO.getContractId());
        if (this.rmatFlowService.count((Wrapper)query) > 0) {
            throw new BusinessException("\u540c\u4e00\u9879\u76ee\u7684\u540c\u4e00\u5408\u540c\u5df2\u5b58\u5728\u8fdb\u573a\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u505a\u671f\u521d\u5f55\u5165\uff01");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.ne(null != periodVO.getId(), BaseEntity::getId, (Object)periodVO.getId());
        queryWrapper.eq(PeriodEntity::getProjectId, (Object)periodVO.getProjectId());
        queryWrapper.eq(PeriodEntity::getContractId, (Object)periodVO.getContractId());
        if (this.count((Wrapper)queryWrapper) > 0) {
            throw new BusinessException("\u540c\u4e00\u9879\u76ee\u7684\u540c\u4e00\u5408\u540c\u5df2\u505a\u8fc7\u671f\u521d\u5f55\u5165\uff0c\u4e0d\u80fd\u591a\u6b21\u5236\u5355\uff01");
        }
        PeriodEntity entity = (PeriodEntity)((Object)BeanMapper.map((Object)periodVO, PeriodEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        this.insertFlow(entity, "BT230606000000001", RmatCommonConsts.NO);
        return (PeriodVO)BeanMapper.map((Object)((Object)entity), PeriodVO.class);
    }

    @Override
    public Boolean insertPriceFlow(PeriodEntity entity, String billTypeCode) {
        ArrayList<PriceFlowVO> flowList = new ArrayList<PriceFlowVO>();
        List<PeriodDetailEntity> detailList = entity.getDetailList();
        for (PeriodDetailEntity detail : detailList) {
            PriceFlowVO vo = new PriceFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);
            vo.setSourceId(entity.getId());
            vo.setSourceDetailId(detail.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setProjectId(entity.getProjectId());
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());
            vo.setContractName(entity.getContractName());
            vo.setBillDate(new Date());
            vo.setEffectiveDate(new Date());
            vo.setFlowType(String.valueOf(FlowTypeEnum.\u9a8c\u6536.getFlowType()));
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));
            vo.setDetailDate(detail.getRentDate());
            vo.setInfoId(detail.getNcDetailId());
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());
            vo.setPrice(detail.getNprice());
            vo.setTaxPrice(detail.getNtaxprice());
            vo.setTaxRate(detail.getTaxrate());
            vo.setRowState(detail.getRowState());
            flowList.add(vo);
        }
        return this.priceFlowService.insertFlow(flowList);
    }

    @Override
    public Boolean insertFlow(PeriodEntity entity, String billTypeCode, Integer effectiveState) {
        ArrayList<RmatFlowVO> flowList = new ArrayList<RmatFlowVO>();
        List<PeriodDetailEntity> detailList = entity.getDetailList();
        for (PeriodDetailEntity detail : detailList) {
            RmatFlowVO vo = new RmatFlowVO();
            vo.setCreateTime(detail.getCreateTime());
            vo.setCreateUserCode(detail.getCreateUserCode());
            vo.setTenantId(detail.getTenantId());
            vo.setBillTypeCode(billTypeCode);
            vo.setSourceId(entity.getId());
            vo.setSourceDetailId(detail.getId());
            vo.setBillCode(entity.getBillCode());
            vo.setProjectId(entity.getProjectId());
            vo.setProjectName(entity.getProjectName());
            vo.setOrgId(entity.getOrgId());
            vo.setOrgName(entity.getOrgName());
            vo.setContractId(entity.getContractId());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setEmployeeId(Long.valueOf(InvocationInfoProxy.getEmployeeId()));
            vo.setEmployeeName(InvocationInfoProxy.getUsercode());
            vo.setBillDate(new Date());
            vo.setEffectiveDate(RmatCommonConsts.YES.equals(effectiveState) ? new Date() : null);
            vo.setEffectiveState(effectiveState);
            vo.setFlowType(String.valueOf(FlowTypeEnum.\u9a8c\u6536.getFlowType()));
            vo.setInOutFlag(RmatCommonConsts.IN);
            vo.setUseStatus(String.valueOf(RmatCommonConsts.YES));
            vo.setDetailDate(detail.getRentDate());
            vo.setInfoId(detail.getNcDetailId());
            vo.setMaterialTypeId(detail.getMaterialTypeId());
            vo.setMaterialTypeName(detail.getMaterialTypeName());
            vo.setMaterialId(detail.getMaterialId());
            vo.setMaterialCode(detail.getMaterialCode());
            vo.setMaterialName(detail.getMaterialName());
            vo.setMaterialSourceId(detail.getMaterialSourceId());
            vo.setSpec(detail.getSpec());
            vo.setUnitId(detail.getUnitId());
            vo.setUnitName(detail.getUnit());
            vo.setNum(detail.getCheckNumsSum());
            vo.setRealUnitId(detail.getRealUnitId());
            vo.setRealUnitName(detail.getRealUnitName());
            vo.setRealNum(detail.getRealNum());
            vo.setRealTransScale(detail.getRealTransScale());
            vo.setRentUnitId(detail.getRentUnitId());
            vo.setRentUnitName(detail.getRentUnitName());
            vo.setRentNum(detail.getRentNum());
            vo.setRentTransScale(detail.getRentTransScale());
            vo.setSignRowType(detail.getSignRowType());
            vo.setRowState(detail.getRowState());
            flowList.add(vo);
        }
        return this.rmatFlowService.insertFlow(flowList);
    }

    @Override
    public Boolean delFlow(List<Long> ids) {
        return this.rmatFlowService.delFlow(ids, BillTypeEnum.\u9a8c\u6536\u5355.getCode());
    }

    @Override
    public void delete(List<PeriodVO> vos) {
        List<Long> idList = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        this.delFlow(idList);
        this.removeByIds(idList, true);
    }
}

