/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.rmat.bean.DailyEntity;
import com.ejianc.business.rmat.bean.ReportDailyEntity;
import com.ejianc.business.rmat.mapper.ReportDailyMapper;
import com.ejianc.business.rmat.service.IReportDailyService;
import com.ejianc.business.rmat.vo.ReportDailyVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="reportDailyService")
public class ReportDailyServiceImpl
extends BaseServiceImpl<ReportDailyMapper, ReportDailyEntity>
implements IReportDailyService {
    @Autowired
    private IProjectApi projectApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String REPORT_RMAT_DAILY = "REPORT_RMAT_DAILY";

    @Override
    public ReportDailyVO saveOrUpdate(ReportDailyVO reportDailyVO) {
        ReportDailyEntity entity = (ReportDailyEntity)((Object)BeanMapper.map((Object)((Object)reportDailyVO), ReportDailyEntity.class));
        if (StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(REPORT_RMAT_DAILY, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        return (ReportDailyVO)((Object)BeanMapper.map((Object)((Object)entity), ReportDailyVO.class));
    }

    @Override
    public void makeReportDailyData(List<DailyEntity> dailyList) {
        ReportDailyVO reportVO;
        List reportList = this.list();
        Map reportMap = reportList.stream().collect(Collectors.toMap(ReportDailyEntity::getProjectId, Function.identity(), (key1, key2) -> key1));
        List<ReportDailyVO> caclMny = ((ReportDailyMapper)this.baseMapper).getCaclMny();
        List<ReportDailyVO> restitueMny = ((ReportDailyMapper)this.baseMapper).getRestitueMny();
        List<ReportDailyVO> repairMny = ((ReportDailyMapper)this.baseMapper).getRepairMny();
        List<ReportDailyVO> pcOtherMny = ((ReportDailyMapper)this.baseMapper).getPcOtherMny();
        List<ReportDailyVO> calcOtherMny = ((ReportDailyMapper)this.baseMapper).getCalcOtherMny();
        HashMap<Long, ReportDailyVO> newReportMap = new HashMap<Long, ReportDailyVO>();
        if (CollectionUtils.isNotEmpty(dailyList)) {
            for (DailyEntity dailyEntity : dailyList) {
                reportVO = new ReportDailyVO();
                reportVO.setProjectId(dailyEntity.getProjectId());
                newReportMap.put(dailyEntity.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(caclMny)) {
            for (ReportDailyVO reportDailyVO : caclMny) {
                reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? (ReportDailyVO)((Object)newReportMap.get(reportDailyVO.getProjectId())) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumRentTaxMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumRentTaxMny(), (BigDecimal)reportDailyVO.getSumRentTaxMny()));
                reportVO.setSumRentMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumRentMny(), (BigDecimal)reportDailyVO.getSumRentMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(restitueMny)) {
            for (ReportDailyVO reportDailyVO : restitueMny) {
                reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? (ReportDailyVO)((Object)newReportMap.get(reportDailyVO.getProjectId())) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumScrapTaxMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumScrapTaxMny(), (BigDecimal)reportDailyVO.getSumScrapTaxMny()));
                reportVO.setSumScrapMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumScrapMny(), (BigDecimal)reportDailyVO.getSumScrapMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(repairMny)) {
            for (ReportDailyVO reportDailyVO : repairMny) {
                reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? (ReportDailyVO)((Object)newReportMap.get(reportDailyVO.getProjectId())) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumRepairTaxMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumRepairTaxMny(), (BigDecimal)reportDailyVO.getSumRepairTaxMny()));
                reportVO.setSumRepairMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumRepairMny(), (BigDecimal)reportDailyVO.getSumRepairMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(pcOtherMny)) {
            for (ReportDailyVO reportDailyVO : pcOtherMny) {
                reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? (ReportDailyVO)((Object)newReportMap.get(reportDailyVO.getProjectId())) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumOtherTaxMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumOtherTaxMny(), (BigDecimal)reportDailyVO.getSumOtherTaxMny()));
                reportVO.setSumOtherMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumOtherMny(), (BigDecimal)reportDailyVO.getSumOtherMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        if (CollectionUtils.isNotEmpty(calcOtherMny)) {
            for (ReportDailyVO reportDailyVO : calcOtherMny) {
                reportVO = newReportMap.containsKey(reportDailyVO.getProjectId()) ? (ReportDailyVO)((Object)newReportMap.get(reportDailyVO.getProjectId())) : new ReportDailyVO();
                reportVO.setProjectId(reportDailyVO.getProjectId());
                reportVO.setSumOtherTaxMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumOtherTaxMny(), (BigDecimal)reportDailyVO.getSumOtherTaxMny()));
                reportVO.setSumOtherMny(ComputeUtil.safeAdd((BigDecimal)reportVO.getSumOtherMny(), (BigDecimal)reportDailyVO.getSumOtherMny()));
                newReportMap.put(reportDailyVO.getProjectId(), reportVO);
            }
        }
        ArrayList<ReportDailyEntity> reportSaveList = new ArrayList<ReportDailyEntity>();
        for (Long key : newReportMap.keySet()) {
            ReportDailyVO reportDailyVO = (ReportDailyVO)((Object)newReportMap.get(key));
            ReportDailyEntity reportDailyEntity = null;
            if (reportMap.containsKey(key)) {
                reportDailyEntity = (ReportDailyEntity)((Object)reportMap.get(key));
            } else {
                CommonResponse commonResponse;
                reportDailyEntity = new ReportDailyEntity();
                reportDailyEntity.setBillState(BillStateEnum.COMMITED_STATE.getBillStateCode());
                reportDailyEntity.setProjectId(reportDailyVO.getProjectId());
                if (StringUtils.isEmpty((CharSequence)reportDailyEntity.getBillCode())) {
                    CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(REPORT_RMAT_DAILY, InvocationInfoProxy.getTenantid());
                    if (billCode.isSuccess()) {
                        reportDailyEntity.setBillCode((String)billCode.getData());
                    } else {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                }
                if ((commonResponse = this.projectApi.queryProjectByIds(Arrays.asList(reportDailyVO.getProjectId()))).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
                    ProjectRegisterVO projectRegisterVO = (ProjectRegisterVO)((List)commonResponse.getData()).get(0);
                    reportDailyEntity.setProjectCode(projectRegisterVO.getCode());
                    reportDailyEntity.setProjectName(projectRegisterVO.getName());
                    reportDailyEntity.setProjectSourceId(projectRegisterVO.getSourceId());
                    reportDailyEntity.setOrgId(projectRegisterVO.getProjectDepartmentId());
                    reportDailyEntity.setOrgName(projectRegisterVO.getName());
                    reportDailyEntity.setRealCorpId(projectRegisterVO.getRealCorpId());
                    reportDailyEntity.setRealNcCorp(projectRegisterVO.getRealNcCorp());
                    reportDailyEntity.setRealCorpName(projectRegisterVO.getRealCorpName());
                    CommonResponse response = this.orgApi.getOneById(projectRegisterVO.getOrgId());
                    if (response.isSuccess() && response.getData() != null) {
                        OrgVO orgVO = (OrgVO)response.getData();
                        reportDailyEntity.setParentOrgId(orgVO.getId());
                        reportDailyEntity.setParentOrgCode(orgVO.getCode());
                        reportDailyEntity.setParentOrgName(orgVO.getName());
                    }
                }
            }
            reportDailyEntity.setSumRentTaxMny(reportDailyVO.getSumRentTaxMny());
            reportDailyEntity.setSumRentMny(reportDailyVO.getSumRentMny());
            reportDailyEntity.setSumScrapTaxMny(reportDailyVO.getSumScrapTaxMny());
            reportDailyEntity.setSumScrapMny(reportDailyVO.getSumScrapMny());
            reportDailyEntity.setSumRepairTaxMny(reportDailyVO.getSumRepairTaxMny());
            reportDailyEntity.setSumRepairMny(reportDailyVO.getSumRepairMny());
            reportDailyEntity.setSumOtherTaxMny(reportDailyVO.getSumOtherTaxMny());
            reportDailyEntity.setSumOtherMny(reportDailyVO.getSumOtherMny());
            reportSaveList.add(reportDailyEntity);
        }
        if (CollectionUtils.isNotEmpty(reportSaveList)) {
            this.saveOrUpdateBatch(reportSaveList, reportSaveList.size());
        }
    }
}

