/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.rmat.bean.RestituteEntity;
import com.ejianc.business.rmat.consts.BillTypeEnum;
import com.ejianc.business.rmat.mapper.RestituteMapper;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IRestituteService;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.util.HttpTookit;
import com.ejianc.business.rmat.util.ValidateUtil;
import com.ejianc.business.rmat.vo.ExitGFVO;
import com.ejianc.business.rmat.vo.RestituteVO;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="restituteService")
public class RestituteServiceImpl
extends BaseServiceImpl<RestituteMapper, RestituteEntity>
implements IRestituteService {
    @Autowired
    private IMaterialService materialService;
    @Value(value="${openApi.wjRestituteUrl}")
    private String wjRestituteUrl;
    @Value(value="${openApi.wjRestituteDeleteUrl}")
    private String wjRestituteDeleteUrl;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String OPERATE = "START_BILL_SYNC";
    private static final String BILL_TYPE = BillTypeEnum.\u8d54\u507f\u5355.getCode();
    private static final String BILL_NAME = BillTypeEnum.\u8d54\u507f\u5355.getName();
    private static final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/restitute/billSync";
    private static final String DEL_SUP_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/assistrmat/restitute/billDel";

    @Override
    public String validateContract(Long contractId, Long billId) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        if (billId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.queryList(queryParam, false)))) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u9000\u8d54\u5355\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public String validateTime(RestituteVO restituteVO, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", restituteVO.getContractId());
        if (restituteVO.getId() != null) {
            params.put("billType", "\u9000\u8d54\u5355");
            params.put("billId", restituteVO.getId());
        }
        Date lastDate = this.materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.materialService.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate(restituteVO.getRestituteDate(), lastDate, maxTimeMap, restituteVO.getCreateTime())) {
            throw new BusinessException(DateUtil.formatDate(restituteVO.getRestituteDate()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate(lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    @Override
    public CommonResponse<String> pushConfirmEntity(Map<String, String> headers, RestituteEntity restituteEntity) {
        String url = this.wjRestituteUrl;
        RestituteVO restituteVO = (RestituteVO)BeanMapper.map((Object)((Object)restituteEntity), RestituteVO.class);
        restituteVO.setSysmark("xpt");
        restituteVO.setPkProject(restituteVO.getProjectSourceId());
        restituteVO.setPkSupplier(restituteVO.getSupplierSourceId());
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)restituteVO).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            String back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)restituteVO).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.set(RestituteEntity::getPushFlag, (Object)1);
                updateWrapper.set(RestituteEntity::getCommitId, (Object)InvocationInfoProxy.getUserid().toString());
                updateWrapper.eq(BaseEntity::getId, (Object)restituteVO.getId());
                boolean flag = this.update((Wrapper)updateWrapper);
                if (!flag) {
                    throw new BusinessException("\u63a8\u9001\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff01");
                }
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("message"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u63a8\u9001\u4f9b\u65b9\u8d54\u507f\u5355\u5f02\u5e38!");
        }
    }

    @Override
    public CommonResponse<RestituteVO> updateConfirmFlag(RestituteVO restituteVO) {
        RestituteEntity entity = (RestituteEntity)((Object)super.getById((Serializable)restituteVO.getId()));
        entity.setConfirmFlag(restituteVO.getConfirmFlag());
        entity.setConfirmDate(DateFormater.getCurrentDate());
        entity.setSupOperatorName(restituteVO.getSupOperatorName());
        entity.setConfirmNote(restituteVO.getConfirmNote());
        if (restituteVO.getConfirmFlag() == 2) {
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        }
        super.saveOrUpdate((Object)entity, false);
        ArrayList<String> receiver = new ArrayList<String>();
        receiver.add(String.valueOf(entity.getCommitId()));
        String formurl = this.baseHost + "cscec5b-rmat-frontend/#/restitute/card?id=" + entity.getId();
        String subject = "\u60a8\u7684\u8d54\u507f\u5355\u3010" + entity.getProjectName() + "--" + entity.getBillCode() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + entity.getSupplierName() + "\u3011" + (restituteVO.getConfirmFlag() == 1 ? "\u786e\u8ba4" : "\u62d2\u7edd") + " \u3002";
        String content = "\u60a8\u7684\u8d54\u507f\u5355\u3010" + entity.getProjectName() + "--" + entity.getBillCode() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + entity.getSupplierName() + "\u3011" + (restituteVO.getConfirmFlag() == 1 ? "\u786e\u8ba4" : "\u62d2\u7edd") + "\u3002<a href=" + '\"' + formurl + '\"' + ">\u524d\u5f80\u70b9\u51fb</a>";
        PushMsgParameter parameter = new PushMsgParameter();
        parameter.setChannel(new String[]{"sys", "wjy"});
        parameter.setReceivers(receiver.toArray(new String[receiver.size()]));
        parameter.setMsgType("notice");
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(String.valueOf(entity.getTenantId()));
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        this.logger.info(">>>>>>\u5f00\u59cb\u53d1\u9001\u6d88\u606f:  , \u63a5\u6536\u4ebaid : {}, baseHost : {}", (Object)entity.getCommitId(), (Object)this.baseHost);
        this.logger.info(">>>>>>\u53d1\u9001\u6d88\u606f\u7ed3\u675f:  , \u63a5\u6536\u4ebaid : {}, baseHost : {}", (Object)entity.getCommitId(), (Object)this.baseHost);
        return CommonResponse.success();
    }

    @Override
    public CommonResponse<String> pushDelete(Map<String, String> headers, RestituteEntity entity) {
        String url = this.wjRestituteDeleteUrl;
        ExitGFVO purchase = new ExitGFVO();
        purchase.setId(String.valueOf(entity.getId()));
        String back = null;
        try {
            this.logger.info("---url:" + url);
            this.logger.info("---\u5165\u53c2:" + JSONObject.toJSON((Object)purchase).toString());
            this.logger.info("---headers:" + JSONObject.toJSON(headers).toString());
            back = HttpTookit.postByJson(url, JSONObject.toJSON((Object)purchase).toString(), headers);
            JSONObject jsonBack = JSONObject.parseObject((String)back);
            this.logger.info("---\u56de\u53c2:" + jsonBack);
            if ("200".equals(jsonBack.getString("code"))) {
                return CommonResponse.success();
            }
            return CommonResponse.error((String)jsonBack.getString("msg"));
        }
        catch (Exception e) {
            return CommonResponse.error((String)"\u5220\u9664\u4f9b\u65b9\u8d54\u507f\u5355\u5f02\u5e38!");
        }
    }
}

