/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.rmat.service.impl;

import com.ejianc.business.rmat.bean.StartEntity;
import com.ejianc.business.rmat.consts.RmatCommonConsts;
import com.ejianc.business.rmat.service.IMaterialService;
import com.ejianc.business.rmat.service.IPriceFlowService;
import com.ejianc.business.rmat.service.IRmatFlowService;
import com.ejianc.business.rmat.service.IStartService;
import com.ejianc.business.rmat.util.DateUtil;
import com.ejianc.business.rmat.util.ValidateUtil;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="start")
public class StartBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRmatFlowService rmatFlowService;
    @Autowired
    private IStartService service;
    @Autowired
    private IPriceFlowService priceFlowService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMaterialService materialService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        StartEntity entity = (StartEntity)((Object)this.service.selectById(billId));
        if (!this.rmatFlowService.insertStartFlow(entity, billTypeCode, RmatCommonConsts.YES).booleanValue()) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        if (!this.priceFlowService.insertStartFlow(entity, billTypeCode).booleanValue()) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u8c03\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        StartEntity entity = (StartEntity)((Object)this.service.selectById(billId));
        this.validateTime(entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        StartEntity entity = (StartEntity)((Object)this.service.selectById(billId));
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(billId);
        if (!this.priceFlowService.delFlow(ids, billTypeCode).booleanValue()) {
            return CommonResponse.error((String)"\u64a4\u56de\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        this.logger.info("\u5220\u9664\u5355\u4ef7\u6d41\u6c34\u6210\u529f--" + billId + billTypeCode);
        if (!this.rmatFlowService.insertStartFlow(entity, billTypeCode, RmatCommonConsts.NO).booleanValue()) {
            return CommonResponse.error((String)"\u64a4\u56de\u5931\u8d25\uff0c\u5355\u636e\u63a8\u9001\u6d41\u6c34\u5931\u8d25\uff01");
        }
        return CommonResponse.success();
    }

    private String validateTime(StartEntity entity) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contractId", entity.getContractId());
        params.put("billType", "\u505c\u7528\u5355");
        params.put("queryType", "all");
        params.put("billId", entity.getId());
        Date lastDate = this.materialService.getLastDate(params);
        Map<Date, Date> maxTimeMap = this.materialService.getMaxTime(params);
        if (lastDate == null) {
            return "\u672a\u83b7\u53d6\u6700\u5927\u5355\u636e\u65e5\u671f\uff01";
        }
        if (ValidateUtil.compareDate(entity.getStartTime(), lastDate, maxTimeMap, entity.getCreateTime())) {
            throw new BusinessException(DateUtil.formatDate(entity.getStartTime()) + "\u5c0f\u4e8e\u6700\u5927\u5355\u636e\u65e5\u671f\u3010" + DateUtil.formatDate(lastDate) + "\u3011\uff0c\u4e0d\u5141\u8bb8\u64a4\u56de!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }
}

