package com.ejianc.business.rmat.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 租金计算单
 *
 * @author generator
 *
 */
 @TableName("ejc_rmat_calculate")
public class CalculateEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; //
    @TableField(value="project_source_id")
    private String projectSourceId; // 项目来源ID
    @TableField(value="org_id")
    private Long orgId; // 项目组织id
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="org_name")
    private String orgName; //
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; //
    @TableField(value="contract_id")
    private String contractId; // 合同id
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="contract_name")
    private String contractName; //
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商
    @TableField(value="supplier_name")
    private String supplierName; //
    @TableField(value="rent_date")
    private Date rentDate; // 租金计算日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="rent_tax_mny")
    private BigDecimal rentTaxMny; // 本次租赁金额
    @TableField(value="rent_mny")
    private BigDecimal rentMny; // 本次租赁金额(无税)
    @TableField(value="rent_tax")
    private BigDecimal rentTax; // 本次租赁税额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="calculate_type")
    private String calculateType; // 租金计算类型（0：手动计算，1：自动计算）
    @TableField(value="scrap_tax_mny")
    private BigDecimal scrapTaxMny; // 本次退赔金额
    @TableField(value="scrap_mny")
    private BigDecimal scrapMny; // 本次退赔金额(无税)
    @TableField(value="scrap_tax")
    private BigDecimal scrapTax; // 本次退赔税额
    @TableField(value="other_tax_mny")
    private BigDecimal otherTaxMny; // 本次其他费用金额
    @TableField(value="other_mny")
    private BigDecimal otherMny; // 本次其他费用金额(无税)
    @TableField(value="other_tax")
    private BigDecimal otherTax; // 本次其他费用税额
    @TableField(value="daily_tax_mny")
    private BigDecimal dailyTaxMny; // 日租金额
    @TableField(value="daily_mny")
    private BigDecimal dailyMny; // 日租金额(无税)
    @TableField(value="daily_tax")
    private BigDecimal dailyTax; // 日租税额
    @TableField(value="nc_settle_flag")
    private Integer ncSettleFlag; // NC结算标识0-未结算 1-已结算



    @TableField(exist=false)
    @SubEntity(serviceName="calculateDailyService", pidName = "calculateId")
    private List<CalculateDailyEntity> dailyList = new ArrayList<>(); // 租金计算单-日租
    @TableField(exist=false)
    @SubEntity(serviceName="calculateScrapService", pidName = "calculateId")
    private List<CalculateScrapEntity> scrapList = new ArrayList<>(); // 租金计算单-退赔
    @TableField(exist=false)
    @SubEntity(serviceName="calculateOtherService", pidName = "calculateId")
    private List<CalculateOtherEntity> otherList = new ArrayList<>(); // 租金计算单-其他费用


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getRentDate() {
        return rentDate;
    }

    public void setRentDate(Date rentDate) {
        this.rentDate = rentDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getRentTaxMny() {
        return rentTaxMny;
    }

    public void setRentTaxMny(BigDecimal rentTaxMny) {
        this.rentTaxMny = rentTaxMny;
    }
    public BigDecimal getRentMny() {
        return rentMny;
    }

    public void setRentMny(BigDecimal rentMny) {
        this.rentMny = rentMny;
    }
    public BigDecimal getRentTax() {
        return rentTax;
    }

    public void setRentTax(BigDecimal rentTax) {
        this.rentTax = rentTax;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getCalculateType() {
        return calculateType;
    }

    public void setCalculateType(String calculateType) {
        this.calculateType = calculateType;
    }
    public BigDecimal getScrapTaxMny() {
        return scrapTaxMny;
    }

    public void setScrapTaxMny(BigDecimal scrapTaxMny) {
        this.scrapTaxMny = scrapTaxMny;
    }
    public BigDecimal getScrapMny() {
        return scrapMny;
    }

    public void setScrapMny(BigDecimal scrapMny) {
        this.scrapMny = scrapMny;
    }
    public BigDecimal getScrapTax() {
        return scrapTax;
    }

    public void setScrapTax(BigDecimal scrapTax) {
        this.scrapTax = scrapTax;
    }
    public BigDecimal getOtherTaxMny() {
        return otherTaxMny;
    }

    public void setOtherTaxMny(BigDecimal otherTaxMny) {
        this.otherTaxMny = otherTaxMny;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    public BigDecimal getOtherTax() {
        return otherTax;
    }

    public void setOtherTax(BigDecimal otherTax) {
        this.otherTax = otherTax;
    }
    public BigDecimal getDailyTaxMny() {
        return dailyTaxMny;
    }

    public void setDailyTaxMny(BigDecimal dailyTaxMny) {
        this.dailyTaxMny = dailyTaxMny;
    }
    public BigDecimal getDailyMny() {
        return dailyMny;
    }

    public void setDailyMny(BigDecimal dailyMny) {
        this.dailyMny = dailyMny;
    }
    public BigDecimal getDailyTax() {
        return dailyTax;
    }

    public void setDailyTax(BigDecimal dailyTax) {
        this.dailyTax = dailyTax;
    }

    public List<CalculateDailyEntity> getDailyList() {
        return dailyList;
    }

    public void setDailyList(List<CalculateDailyEntity> dailyList) {
        this.dailyList = dailyList;
    }

    public List<CalculateScrapEntity> getScrapList() {
        return scrapList;
    }

    public void setScrapList(List<CalculateScrapEntity> scrapList) {
        this.scrapList = scrapList;
    }

    public List<CalculateOtherEntity> getOtherList() {
        return otherList;
    }

    public void setOtherList(List<CalculateOtherEntity> otherList) {
        this.otherList = otherList;
    }

    public Integer getNcSettleFlag() {
        return ncSettleFlag;
    }

    public void setNcSettleFlag(Integer ncSettleFlag) {
        this.ncSettleFlag = ncSettleFlag;
    }
}
