package com.ejianc.business.rmat.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
/**
 * 日租金
 *
 * @author generator
 *
 */
 @TableName("ejc_rmat_daily")
public class DailyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_source_id")
    private String projectSourceId; // 项目来源ID
    @TableField(value="org_id")
    private Long orgId; // 项目组织id
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="org_name")
    private String orgName; // 项目组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父级组织id
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value="rent_date")
    private Date rentDate; // 租金计算日期
    @TableField(value="rent_tax_mny")
    private BigDecimal rentTaxMny; // 租赁金额
    @TableField(value="rent_mny")
    private BigDecimal rentMny; // 租赁金额(无税)
    @TableField(value="rent_tax")
    private BigDecimal rentTax; // 租赁税额
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="calc_tax_mny")
    private BigDecimal calcTaxMny; // 租金计算金额
    @TableField(value="calc_mny")
    private BigDecimal calcMny; // 租金计算金额(无税)
    @TableField(value="calc_tax")
    private BigDecimal calcTax; // 租金计算税额
    @TableField(value="real_corp_id")
    private java.lang.Long realCorpId; // NC所属组织ID
    @TableField(value="real_nc_corp")
    private java.lang.String realNcCorp; // NC所属组织PK
    @TableField(value="real_corp_name")
    private java.lang.String realCorpName; // NC所属组织名称

    @TableField(exist=false)
    @SubEntity(serviceName="dailyDetailService", pidName = "dailyId")
    private List<DailyDetailEntity> detailList = new ArrayList<>(); // 日租金子表


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Date getRentDate() {
        return rentDate;
    }

    public void setRentDate(Date rentDate) {
        this.rentDate = rentDate;
    }
    public BigDecimal getRentTaxMny() {
        return rentTaxMny;
    }

    public void setRentTaxMny(BigDecimal rentTaxMny) {
        this.rentTaxMny = rentTaxMny;
    }
    public BigDecimal getRentMny() {
        return rentMny;
    }

    public void setRentMny(BigDecimal rentMny) {
        this.rentMny = rentMny;
    }
    public BigDecimal getRentTax() {
        return rentTax;
    }

    public void setRentTax(BigDecimal rentTax) {
        this.rentTax = rentTax;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getCalcTaxMny() {
        return calcTaxMny;
    }

    public void setCalcTaxMny(BigDecimal calcTaxMny) {
        this.calcTaxMny = calcTaxMny;
    }
    public BigDecimal getCalcMny() {
        return calcMny;
    }

    public void setCalcMny(BigDecimal calcMny) {
        this.calcMny = calcMny;
    }
    public BigDecimal getCalcTax() {
        return calcTax;
    }

    public void setCalcTax(BigDecimal calcTax) {
        this.calcTax = calcTax;
    }

    public Long getRealCorpId() {
        return realCorpId;
    }

    public void setRealCorpId(Long realCorpId) {
        this.realCorpId = realCorpId;
    }

    public String getRealNcCorp() {
        return realNcCorp;
    }

    public void setRealNcCorp(String realNcCorp) {
        this.realNcCorp = realNcCorp;
    }

    public String getRealCorpName() {
        return realCorpName;
    }

    public void setRealCorpName(String realCorpName) {
        this.realCorpName = realCorpName;
    }

    public List<DailyDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<DailyDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
