package com.ejianc.business.rmat.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.rmat.bean.TransferDetailEntity;
/**
 * 内部调拨单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_rmat_transfer")
public class TransferEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目code
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 上级组织code
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_code")
    private String orgCode; // 组织code
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="allot_in_id")
    private Long allotInId; // 调入单位id
    @TableField(value="allot_in_name")
    private String allotInName; // 调入单位名称
    @TableField(value="allot_out_id")
    private Long allotOutId; // 调出单位id
    @TableField(value="allot_out_name")
    private String allotOutName; // 调出单位名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="transfer_date")
    private Date transferDate; // 调拨日期
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="transferDetailService",pidName = "transId")
    private List<TransferDetailEntity> detailList = new ArrayList<>(); // 内部调拨单明细
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getAllotInId() {
        return allotInId;
    }

    public void setAllotInId(Long allotInId) {
        this.allotInId = allotInId;
    }
    public String getAllotInName() {
        return allotInName;
    }

    public void setAllotInName(String allotInName) {
        this.allotInName = allotInName;
    }
    public Long getAllotOutId() {
        return allotOutId;
    }

    public void setAllotOutId(Long allotOutId) {
        this.allotOutId = allotOutId;
    }
    public String getAllotOutName() {
        return allotOutName;
    }

    public void setAllotOutName(String allotOutName) {
        this.allotOutName = allotOutName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getTransferDate() {
        return transferDate;
    }

    public void setTransferDate(Date transferDate) {
        this.transferDate = transferDate;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public List<TransferDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<TransferDetailEntity> detailList) {
        this.detailList = detailList;
    }
}
