package com.ejianc.business.rmat.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.rmat.util.PageUtil;
import com.ejianc.business.rmat.vo.ArchivesVOS;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.rmat.bean.ArchivesEntity;
import com.ejianc.business.rmat.service.IArchivesService;
import com.ejianc.business.rmat.vo.ArchivesVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 周转材档案实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("archives")
public class ArchivesController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IArchivesService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ArchivesVO>> saveOrUpdate(@RequestBody List<ArchivesVO> saveOrUpdateVO) {
        List<ArchivesVO> vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description saveCategory 根据分类新增
     */
    @RequestMapping(value = "/saveCategory", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ArchivesVO>> saveCategory(@RequestBody List<ArchivesVO> saveOrUpdateVO) {
        List<ArchivesVO> vo = service.saveCategory(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }



    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ArchivesVO> queryDetail(Long id) {
    	ArchivesEntity entity = service.selectById(id);
    	ArchivesVO vo = BeanMapper.map(entity, ArchivesVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ArchivesVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ArchivesVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ArchivesVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ArchivesVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        if (param.getParams().size()!=0 && param.getParams().get("categoryId") != null){
            param.getParams().put("categoryInnerCode", new Parameter(QueryParam.LIKE, param.getParams().get("categoryId").getValue()));
            param.getParams().remove("categoryId");
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getOrgId()));//只查询当前组织，不查询本下
        IPage<ArchivesEntity> page = service.queryPage(param,false);
        IPage<ArchivesVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ArchivesVO.class));


        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ArchivesEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Archives-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refArchivesData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ArchivesVO>> refArchivesData(
            @RequestParam(defaultValue = "1") Integer pageNumber,
            @RequestParam(defaultValue = "10") Integer pageSize,
            @RequestParam(value = "condition", required = false) String condition,
            @RequestParam(value = "searchText", required = false) String searchText,
            @RequestParam(required=false) String searchObject) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        fuzzyFields.add("materialTypeName");
        param.setPageSize(1);
        param.setPageIndex(-1);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("status", new Parameter(QueryParam.EQ, 1));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));
        String materialTypeId = null;
        Long orgId1 = null;
        if (StringUtils.isNotBlank(condition)){
            Map<String, Object> conditionMap = JSON.parseObject(condition, Map.class);
            if (null != conditionMap.get("materialTypeId")){
                materialTypeId = conditionMap.get("materialTypeId").toString();
            }
            if (null != conditionMap.get("orgId")){
                orgId1 = Long.valueOf(conditionMap.get("orgId").toString());
            }
            if (null != conditionMap.get("sourceOrgId")){
                orgId1 = Long.valueOf(conditionMap.get("sourceOrgId").toString());
            }
        }
        IPage<ArchivesVO> page = new Page<>();
        CommonResponse<OrgVO> orgVo;
        if (orgId1!= null){
            orgVo = iOrgApi.detailById(orgId1);
        }else {
            orgVo = iOrgApi.detailById(InvocationInfoProxy.getOrgId());
        }
        List<Long> orgIds = Arrays.stream(orgVo.getData().getInnerCode().split("\\|")).map(Long::parseLong).collect(Collectors.toList());
        Collections.reverse(orgIds);  // 倒叙的当前组织orgInnerCode
        param.getParams().put("org_id", new Parameter(QueryParam.IN, orgIds));
        if (materialTypeId!=null){
            param.getParams().put("material_type_id", new Parameter(QueryParam.EQ, materialTypeId));
        }
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<ArchivesEntity> list = service.geMaterialDetail(wrapper);
        //List<ArchivesEntity>  list = service.list(new QueryWrapper<ArchivesEntity>().in("org_id",orgIds).eq(materialTypeId!=null,"material_type_id",materialTypeId));
        List<Long> materialIds = new ArrayList<>();
        List<ArchivesVO> lists = BeanMapper.mapList(list,ArchivesVO.class);
        List<ArchivesVO> archivesVOList = new ArrayList<>();
        for (Long orgId : orgIds) {
            for (ArchivesVO vo : lists) {
                if (materialIds.contains(vo.getMaterialId())){
                    continue;
                }
                if (orgId.equals(vo.getOrgId())) {
                    archivesVOList.add(vo);
                    materialIds.add(vo.getMaterialId());
                }
            }
        }
        page.setCurrent(StringUtils.isNotBlank(searchObject)?1:pageNumber);
        page.setSize(pageSize);
        page.setTotal(archivesVOList.size());
        archivesVOList = PageUtil.listToPage(archivesVOList, StringUtils.isNotBlank(searchObject)?1:pageNumber, pageSize);
        page.setRecords(archivesVOList);
        return CommonResponse.success("查询参照数据成功！",page);
     }


    @RequestMapping(value = "/lazyMaterialCategory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialCategoryVO>> lazyMaterialCategory(Long parentId) {
        List<MaterialCategoryVO> materialCategoryVO = new ArrayList<>();
        List list = new ArrayList();
        LambdaQueryWrapper<ArchivesEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ArchivesEntity::getDr,0);
        queryWrapper.eq(ArchivesEntity::getOrgId,InvocationInfoProxy.getOrgId());//只查询当前组织
        queryWrapper.like(parentId != null,ArchivesEntity::getCategoryInnerCode,parentId);
        List<ArchivesEntity> archivesEntities = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(archivesEntities)){
            for (ArchivesEntity archivesEntity:archivesEntities){
                list.add(archivesEntity.getMaterialTypeId());
            }
            CommonResponse<List<MaterialCategoryVO>> materialCategoryVOS = materialApi.queryCategoryListByChildren(list);
            List<MaterialCategoryVO> dateList = materialCategoryVOS.getData();
            if (parentId != null){ // 选择树形查找子集
                for (MaterialCategoryVO materialCategoryVO1 : dateList){
                    if (materialCategoryVO1.getParentId() !=null && materialCategoryVO1.getParentId().equals(parentId)){
                        materialCategoryVO.add(materialCategoryVO1);
                    }
                }
            }else { // 刷新页面查询全部树形
                for (MaterialCategoryVO materialCategoryVO1 : dateList){
                    if (materialCategoryVO1.getParentId() ==null ){
                        materialCategoryVO.add(materialCategoryVO1);
                    }
                }
            }
        }
        return CommonResponse.success(materialCategoryVO);
    }

    /**
     * @Description 启用停用
     */
    @RequestMapping(value = "/turnSwitch", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> turnSwitch(@RequestBody Long id) {
        return CommonResponse.success(service.turnSwitch(id));
    }

    /**
     * @Description 查询最近上级的周转材档案
     */
    @RequestMapping(value = "/queryArchives", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ArchivesVO> queryArchives(@RequestBody ArchivesVO vo) {
        return CommonResponse.success(service.queryArchives(vo));
    }

    /**
     * @Description 查询最近上级的周转材档案根据材料ids
     */
    @RequestMapping(value = "/queryByIds", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map<Long,ArchivesVO>> queryByIds(@RequestBody ArchivesVO vo) {
        return CommonResponse.success(service.queryByIds(vo.getIds(),vo.getOrgId()));
    }

    /**
     * @Description 查询最近上级的周转材档案根据材料ids
     */
    @RequestMapping(value = "/queryIds", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ArchivesVO>> queryIds(@RequestBody ArchivesVOS vos) {
        return CommonResponse.success(service.queryIds(vos));
    }

}
