package com.ejianc.business.rmat.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.rmat.service.IReportDailyService;
import com.ejianc.business.rmat.vo.ReportCorpTopVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;

/**
 * 公司租金分析
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("reportCorp")
public class ReportCorpController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IReportDailyService service;

    /**
     * @Description qryTopInfo
     * @param orgId
     */
    @RequestMapping(value = "/qryTopInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReportCorpTopVO> qryTopInfo(@RequestParam(value = "orgId", required = false) Long orgId) {
        return CommonResponse.success("查询数据成功！", service.qryTopInfo(InvocationInfoProxy.getOrgId()));
    }

    /**
     * @Description qryDailyRise 查询日租金涨幅情况
     * @param orgId
     */
    @RequestMapping(value = "/qryDailyRise", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<JSONObject>> qryDailyRise(@RequestParam(value = "orgId", required = false) Long orgId) {
        return CommonResponse.success("查询数据成功！", service.qryDailyRise(InvocationInfoProxy.getOrgId()));
    }

    /**
     * @Description qryRentMnyDistribution 查询累计租金分布
     * @param orgId
     */
    @RequestMapping(value = "/qryRentMnyDistribution", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> qryRentMnyDistribution(@RequestParam(value = "orgId", required = false) Long orgId) {
        return CommonResponse.success("查询数据成功！", service.qryRentMnyDistribution(InvocationInfoProxy.getOrgId()));
    }
}
